/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world;

import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Vec2;
import java.util.Arrays;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.Tile;

public class Edges {
    private static final int maxRadius = 12;
    private static Point2[][] edges;
    private static Point2[][] edgeInside;
    private static Vec2[][] polygons;

    public static Tile getFacingEdge(Building tile, Building other) {
        Tile res = Edges.getFacingEdge(tile.block, tile.tileX(), tile.tileY(), other.tile);
        return res == null ? tile.tile : res;
    }

    public static Tile getFacingEdge(Tile tile, Tile other) {
        Tile res = Edges.getFacingEdge(tile.block, tile.x, tile.y, other);
        return res == null ? tile : res;
    }

    public static Tile getFacingEdge(Block block, int tilex, int tiley, Tile other) {
        if (!block.isMultiblock()) {
            return Vars.world.tile(tilex, tiley);
        }
        int size = block.size;
        return Vars.world.tile(tilex + Mathf.clamp(other.x - tilex, -(size - 1) / 2, size / 2), tiley + Mathf.clamp(other.y - tiley, -(size - 1) / 2, size / 2));
    }

    public static Vec2[] getPixelPolygon(float radius) {
        if (radius < 1.0f || radius > 12.0f) {
            throw new RuntimeException("Polygon size must be between 1 and 12");
        }
        return polygons[(int)(radius * 2.0f) - 1];
    }

    public static Point2[] getEdges(int size) {
        if (size < 0 || size > 16) {
            throw new RuntimeException("Block size must be between 0 and 16");
        }
        return edges[size - 1];
    }

    public static Point2[] getInsideEdges(int size) {
        if (size < 0 || size > 16) {
            throw new RuntimeException("Block size must be between 0 and 16");
        }
        return edgeInside[size - 1];
    }

    static {
        int i;
        edges = new Point2[16][0];
        edgeInside = new Point2[16][0];
        polygons = new Vec2[24][0];
        for (i = 0; i < 24; ++i) {
            Edges.polygons[i] = Geometry.pixelCircle((float)(i + 1) / 2.0f);
        }
        for (i = 0; i < 16; ++i) {
            int j;
            int bot = -((int)((float)i / 2.0f)) - 1;
            int top = (int)((float)i / 2.0f + 0.5f) + 1;
            Edges.edges[i] = new Point2[(i + 1) * 4];
            int idx = 0;
            for (j = 0; j < i + 1; ++j) {
                Edges.edges[i][idx++] = new Point2(bot + 1 + j, bot);
                Edges.edges[i][idx++] = new Point2(bot + 1 + j, top);
                Edges.edges[i][idx++] = new Point2(bot, bot + j + 1);
                Edges.edges[i][idx++] = new Point2(top, bot + j + 1);
            }
            Arrays.sort(edges[i], (e1, e2) -> Float.compare(Mathf.angle(e1.x, e1.y), Mathf.angle(e2.x, e2.y)));
            Edges.edgeInside[i] = new Point2[edges[i].length];
            for (j = 0; j < edges[i].length; ++j) {
                Point2 point = edges[i][j];
                Edges.edgeInside[i][j] = new Point2(Mathf.clamp(point.x, -((int)((float)i / 2.0f)), (int)((float)i / 2.0f + 0.5f)), Mathf.clamp(point.y, -((int)((float)i / 2.0f)), (int)((float)i / 2.0f + 0.5f)));
            }
        }
    }
}

