/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui;

import arc.Core;
import arc.Graphics;
import arc.assets.AssetManager;
import arc.files.Fi;
import arc.freetype.FreeTypeFontGenerator;
import arc.freetype.FreeTypeFontGeneratorLoader;
import arc.freetype.FreetypeFontLoader;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.Gl;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.PixmapPacker;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.layout.Scl;
import arc.struct.IntMap;
import arc.struct.ObjectIntMap;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Scaling;
import arc.util.Tmp;
import java.io.BufferedReader;
import java.io.IOException;
import mindustry.core.UI;
import mindustry.game.Team;
import mindustry.gen.Iconc;

public class Fonts {
    private static final String mainFont = "fonts/font.woff";
    private static final ObjectSet<String> unscaled = ObjectSet.with("iconLarge", "logic");
    private static ObjectIntMap<String> unicodeIcons = new ObjectIntMap();
    private static IntMap<String> unicodeToName = new IntMap();
    private static ObjectMap<String, String> stringIcons = new ObjectMap();
    private static ObjectMap<String, TextureRegion> largeIcons = new ObjectMap();
    public static Font def;
    public static Font outline;
    public static Font icon;
    public static Font iconLarge;
    public static Font tech;
    public static Font logic;
    public static Font monospace;

    public static int getUnicode(String content) {
        return unicodeIcons.get(content, 0);
    }

    public static String getUnicodeStr(String content) {
        return stringIcons.get(content, "");
    }

    public static boolean hasUnicodeStr(String content) {
        return stringIcons.containsKey(content);
    }

    public static void loadSystemCursors() {
        Graphics.Cursor.SystemCursor.arrow.set(Core.graphics.newCursor("cursor", Fonts.cursorScale()));
        Graphics.Cursor.SystemCursor.hand.set(Core.graphics.newCursor("hand", Fonts.cursorScale()));
        Graphics.Cursor.SystemCursor.ibeam.set(Core.graphics.newCursor("ibeam", Fonts.cursorScale()));
        Core.graphics.restoreCursor();
    }

    public static int cursorScale() {
        return 1;
    }

    public static void loadFonts() {
        largeIcons.clear();
        FreeTypeFontGenerator.FreeTypeFontParameter param = Fonts.fontParameter();
        Core.assets.load((String)"default", Font.class, new FreetypeFontLoader.FreeTypeFontLoaderParameter((String)mainFont, (FreeTypeFontGenerator.FreeTypeFontParameter)param)).loaded = f -> {
            def = f;
        };
        Core.assets.load((String)"monospace", Font.class, new FreetypeFontLoader.FreeTypeFontLoaderParameter((String)"fonts/monospace.woff", (FreeTypeFontGenerator.FreeTypeFontParameter)new FreeTypeFontGenerator.FreeTypeFontParameter(){
            {
                this.size = 16;
                this.incremental = true;
                this.characters = "\u0000 ";
            }
        })).loaded = f -> {
            monospace = f;
        };
        Core.assets.load((String)"icon", Font.class, new FreetypeFontLoader.FreeTypeFontLoaderParameter((String)"fonts/icon.ttf", (FreeTypeFontGenerator.FreeTypeFontParameter)new FreeTypeFontGenerator.FreeTypeFontParameter(){
            {
                this.size = 30;
                this.incremental = true;
                this.characters = "\u0000";
            }
        })).loaded = f -> {
            icon = f;
        };
        Core.assets.load((String)"iconLarge", Font.class, new FreetypeFontLoader.FreeTypeFontLoaderParameter((String)"fonts/icon.ttf", (FreeTypeFontGenerator.FreeTypeFontParameter)new FreeTypeFontGenerator.FreeTypeFontParameter(){
            {
                this.size = 48;
                this.incremental = false;
                this.characters = "\u0000\uf15c\uf15b\uf0f6\ue802\ue803\ue804\ue805\ue807\ue800\ue808\ue809\ue80b\ue80f\uf300\uf1c5\ue813\ue816\ue819\ue81a\uf0b0\ue81d\ue822\ue824\ue825\ue826\ue827\ue823\ue829\ue806\ue811\ue815\ue818\uf120\ue835\ue836\uf129\ue837\ue839\ue83a\ue83b\ue83e\ue83f\uf12d\ue801\uf029\ue812\ue842\ue844\ue80d\ue81e\uf281\uf308\ue83d\ue845\uf181\ue80e\ue814\ue817\ue81b\ue81c\ue82a\ue82b\ue82c\ue82d\ue830\ue84c\ue852\ue853\ue85b\ue85c\ue85d\ue85e\ue85f\ue861\ue865\ue867\ue868\ue869\ue86a\ue86b\ue86c\ue86d\ue86e\ue86f\ue870\ue871\ue872\ue873\ue874\ue875\ue876\ue877\ue878\ue879\ue87b\ue87c\ue87d\ue88a\ue88b\ue810\ue88c\ue88d\ue88e\ue88f\u26a0\ue864\ue84d\ue833";
                this.borderWidth = 5.0f;
                this.borderColor = Color.darkGray;
            }
        })).loaded = f -> {
            iconLarge = f;
        };
        Core.assets.load((String)"logic", Font.class, new FreetypeFontLoader.FreeTypeFontLoaderParameter((String)"fonts/logic.ttf", (FreeTypeFontGenerator.FreeTypeFontParameter)new FreeTypeFontGenerator.FreeTypeFontParameter(){
            {
                this.size = 16;
                this.incremental = false;
                this.characters = "\u0000ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890\"!`?'.,;:()[]{}<>|/@\\^$\u20ac-%+=#_&~*";
            }
        })).loaded = f -> {
            logic = f;
        };
    }

    @Nullable
    public static String unicodeToName(int unicode) {
        return (String)((Object)unicodeToName.get(unicode, (String)((Object)((Prov<String>)() -> Iconc.codeToName.get(unicode)))));
    }

    public static TextureRegion getLargeIcon(String name) {
        return (TextureRegion)((Object)largeIcons.get(name, (TextureRegion)((Object)((Prov<TextureRegion>)() -> {
            TextureRegion region = new TextureRegion();
            int code = Iconc.codes.get(name, 63700);
            Font.Glyph glyph = iconLarge.getData().getGlyph((char)code);
            if (glyph == null) {
                return Core.atlas.find(name);
            }
            region.set(Fonts.iconLarge.getRegion().texture);
            region.set(glyph.u, glyph.v2, glyph.u2, glyph.v);
            return region;
        }))));
    }

    public static void registerIcon(String name, String regionName, int ch, TextureRegion region) {
        int size = (int)(Fonts.def.getData().lineHeight / Fonts.def.getData().scaleY);
        unicodeIcons.put(name, ch);
        stringIcons.put(name, (char)ch + "");
        unicodeToName.put(ch, regionName);
        Vec2 out = Scaling.fit.apply(region.width, region.height, size, size);
        Font.Glyph glyph = new Font.Glyph();
        glyph.id = ch;
        glyph.srcX = 0;
        glyph.srcY = 0;
        glyph.width = (int)out.x;
        glyph.height = (int)out.y;
        glyph.u = region.u;
        glyph.v = region.v2;
        glyph.u2 = region.u2;
        glyph.v2 = region.v;
        glyph.xoffset = 0;
        glyph.yoffset = -size;
        glyph.xadvance = size;
        glyph.kerning = null;
        glyph.fixedWidth = true;
        glyph.page = 0;
        def.getData().setGlyph(ch, glyph);
        outline.getData().setGlyph(ch, glyph);
    }

    public static void loadContentIcons() {
        Texture uitex = Core.atlas.find((String)"logo").texture;
        try (BufferedReader reader = Core.files.internal("icons/icons.properties").reader(8192);){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] split = line.split("=");
                String[] nametex = split[1].split("\\|");
                String character = split[0];
                String texture = nametex[1];
                int ch = Integer.parseInt(character);
                TextureAtlas.AtlasRegion region = Core.atlas.find(texture);
                if (region.texture != uitex) continue;
                Fonts.registerIcon(nametex[0], texture, ch, region);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        stringIcons.put("alphachan", stringIcons.get("alphaaaa"));
        for (Team team : Team.baseTeams) {
            team.emoji = stringIcons.get(team.name, "");
        }
    }

    public static void loadContentIconsHeadless() {
        try (BufferedReader reader = Core.files.internal("icons/icons.properties").reader(8192);){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] split = line.split("=");
                String[] nametex = split[1].split("\\|");
                String character = split[0];
                int ch = Integer.parseInt(character);
                unicodeIcons.put(nametex[0], ch);
                stringIcons.put(nametex[0], (char)ch + "");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        stringIcons.put("alphachan", stringIcons.get("alphaaaa"));
        for (Team team : Team.baseTeams) {
            team.emoji = stringIcons.get(team.name, "");
        }
    }

    public static void loadDefaultFont() {
        int max = Gl.getInt(3379);
        UI.packer = new PixmapPacker(max >= 4096 ? 4096 : 2048, 2048, 2, true);
        Core.assets.setLoader(FreeTypeFontGenerator.class, new FreeTypeFontGeneratorLoader(Core.files::internal));
        Core.assets.setLoader(Font.class, null, new FreetypeFontLoader(Core.files::internal){
            ObjectSet<FreeTypeFontGenerator.FreeTypeFontParameter> scaled = new ObjectSet();

            @Override
            public Font loadSync(AssetManager manager, String fileName, Fi file, FreetypeFontLoader.FreeTypeFontLoaderParameter parameter) {
                if (fileName.equals("outline")) {
                    parameter.fontParameters.borderWidth = Scl.scl(2.0f);
                    parameter.fontParameters.spaceX = (int)((float)parameter.fontParameters.spaceX - parameter.fontParameters.borderWidth);
                }
                if (!this.scaled.contains(parameter.fontParameters) && !unscaled.contains(fileName)) {
                    parameter.fontParameters.size = (int)Scl.scl(parameter.fontParameters.size);
                    this.scaled.add(parameter.fontParameters);
                }
                parameter.fontParameters.magFilter = Texture.TextureFilter.linear;
                parameter.fontParameters.minFilter = Texture.TextureFilter.linear;
                parameter.fontParameters.packer = UI.packer;
                return super.loadSync(manager, fileName, file, parameter);
            }
        });
        FreeTypeFontGenerator.FreeTypeFontParameter param = new FreeTypeFontGenerator.FreeTypeFontParameter(){
            {
                this.borderColor = Color.darkGray;
                this.incremental = true;
                this.size = 18;
            }
        };
        Core.assets.load((String)"outline", Font.class, new FreetypeFontLoader.FreeTypeFontLoaderParameter((String)mainFont, (FreeTypeFontGenerator.FreeTypeFontParameter)param)).loaded = t -> {
            outline = t;
        };
        Core.assets.load((String)"tech", Font.class, new FreetypeFontLoader.FreeTypeFontLoaderParameter((String)"fonts/tech.ttf", (FreeTypeFontGenerator.FreeTypeFontParameter)new FreeTypeFontGenerator.FreeTypeFontParameter(){
            {
                this.size = 18;
            }
        })).loaded = f -> {
            tech = f;
            Fonts.tech.getData().down *= 1.5f;
        };
    }

    public static void mergeFontAtlas(TextureAtlas atlas) {
        Texture texture = atlas.find((String)"logo").texture;
        PixmapPacker.Page page = UI.packer.getPages().first();
        Seq<TextureAtlas.AtlasRegion> regions = atlas.getRegions().select(t -> t.texture == texture);
        for (TextureAtlas.AtlasRegion region : regions) {
            page.setDirty(false);
            Rect rect = UI.packer.pack(region.name, atlas.getPixmap(region), region.splits, region.pads);
            region.texture = UI.packer.getPages().first().getTexture();
            region.set((int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
            atlas.getTextures().add(region.texture);
            region.pixmapRegion = null;
        }
        atlas.getTextures().remove(texture);
        texture.dispose();
        atlas.disposePixmap(texture);
        page.setDirty(true);
        page.updateTexture(Texture.TextureFilter.linear, Texture.TextureFilter.linear, false);
    }

    public static TextureRegionDrawable getGlyph(Font font, char glyph) {
        Font.Glyph found = font.getData().getGlyph(glyph);
        if (found == null) {
            Log.warn("No icon found for glyph: @ (@)", Character.valueOf(glyph), glyph);
            found = font.getData().getGlyph('F');
        }
        final Font.Glyph g = found;
        final float size = Math.max(g.width, g.height);
        TextureRegionDrawable draw = new TextureRegionDrawable(new TextureRegion(font.getRegion().texture, g.u, g.v2, g.u2, g.v)){

            @Override
            public void draw(float x, float y, float width, float height) {
                Draw.color(Tmp.c1.set(this.tint).mul(Draw.getColor()).toFloatBits());
                float cx = x + width / 2.0f - (float)g.width / 2.0f;
                float cy = y + height / 2.0f - (float)g.height / 2.0f;
                cx = (int)cx;
                cy = (int)cy;
                Draw.rect(this.region, cx + (float)g.width / 2.0f, cy + (float)g.height / 2.0f, (float)g.width, (float)g.height);
            }

            @Override
            public void draw(float x, float y, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation) {
                Draw.color(Tmp.c1.set(this.tint).mul(Draw.getColor()).toFloatBits());
                float cx = x + (width *= scaleX) / 2.0f - (float)g.width / 2.0f;
                float cy = y + (height *= scaleY) / 2.0f - (float)g.height / 2.0f;
                cx = (int)cx;
                cy = (int)cy;
                originX = (float)g.width / 2.0f;
                originY = (float)g.height / 2.0f;
                Draw.rect(this.region, cx + (float)g.width / 2.0f, cy + (float)g.height / 2.0f, (float)g.width * scaleX, (float)g.height * scaleY, originX, originY, rotation);
            }

            @Override
            public float imageSize() {
                return size;
            }
        };
        draw.setMinWidth(size);
        draw.setMinHeight(size);
        return draw;
    }

    static FreeTypeFontGenerator.FreeTypeFontParameter fontParameter() {
        return new FreeTypeFontGenerator.FreeTypeFontParameter(){
            {
                this.size = 18;
                this.shadowColor = Color.darkGray;
                this.shadowOffsetY = 2;
                this.incremental = true;
            }
        };
    }
}

