/*
 * Decompiled with CFR 0.152.
 */
package mindustry.logic;

import arc.Core;
import arc.graphics.Color;
import arc.scene.ui.Image;
import arc.scene.ui.Label;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import mindustry.Vars;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.logic.GlobalVars;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class GlobalVarsDialog
extends BaseDialog {
    public GlobalVarsDialog() {
        super("@logic.globals");
        this.addCloseButton();
        this.shown(this::setup);
        this.onResize(this::setup);
    }

    void setup() {
        float prefWidth = Math.min((float)Core.graphics.getWidth() * 0.9f / Scl.scl(1.0f) - 240.0f, 600.0f);
        this.cont.clearChildren();
        this.cont.pane((Table t) -> {
            t.margin(10.0f).marginRight(16.0f);
            t.defaults().fillX().fillY();
            for (GlobalVars.VarEntry entry : Vars.logicVars.getEntries()) {
                if (entry.name.startsWith("section")) {
                    Color color = Pal.accent;
                    t.add("@lglobal." + entry.name).fillX().center().labelAlign(1).colspan(4).color(color).padTop(4.0f).padBottom(2.0f).row();
                    t.image(Tex.whiteui).height(4.0f).color(color).colspan(4).padBottom(8.0f).row();
                    continue;
                }
                Color varColor = Pal.gray;
                float stub = 8.0f;
                float mul = 0.5f;
                float pad = 4.0f;
                String desc = entry.description;
                if (desc == null || desc.isEmpty()) {
                    desc = Core.bundle.get("lglobal." + entry.name, "");
                }
                String fdesc = desc;
                t.add(new Image(Tex.whiteui, varColor.cpy().mul(mul))).width(stub);
                t.stack(new Image(Tex.whiteui, varColor), new Label(" " + entry.name + " ", Styles.outlineLabel)).padRight(pad);
                t.add(new Image(Tex.whiteui, Pal.gray.cpy().mul(mul))).width(stub);
                t.table(Tex.pane, out -> out.add(fdesc).style(Styles.outlineLabel).width(prefWidth).padLeft(2.0f).padRight(2.0f).wrap()).padRight(pad);
                t.row();
                t.add().fillX().colspan(4).height(4.0f).row();
            }
        }).grow();
    }
}

