/*
 * Decompiled with CFR 0.152.
 */
package mindustry.io;

import arc.func.Prov;
import arc.graphics.Color;
import arc.math.geom.Point2;
import arc.util.Strings;
import arc.util.serialization.Json;
import arc.util.serialization.JsonReader;
import arc.util.serialization.JsonValue;
import arc.util.serialization.UBJsonReader;
import arc.util.serialization.UBJsonWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Items;
import mindustry.content.Liquids;
import mindustry.content.Planets;
import mindustry.ctype.ContentType;
import mindustry.ctype.MappableContent;
import mindustry.ctype.UnlockableContent;
import mindustry.game.MapObjectives;
import mindustry.game.Rules;
import mindustry.game.SpawnGroup;
import mindustry.game.Team;
import mindustry.io.SaveVersion;
import mindustry.maps.Maps;
import mindustry.maps.filters.GenerateFilter;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.Liquid;
import mindustry.type.Planet;
import mindustry.type.Sector;
import mindustry.type.SectorPreset;
import mindustry.type.UnitType;
import mindustry.type.Weather;
import mindustry.world.Block;
import mindustry.world.meta.Attribute;

public class JsonIO {
    private static final CustomJson jsonBase = new CustomJson();
    public static final Json json = new Json(){
        {
            JsonIO.apply(this);
        }

        @Override
        public void writeValue(Object value, Class knownType, Class elementType) {
            if (value instanceof MappableContent) {
                MappableContent c = (MappableContent)value;
                try {
                    this.getWriter().value(c.name);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                super.writeValue(value, knownType, elementType);
            }
        }

        @Override
        protected String convertToString(Object object) {
            if (object instanceof MappableContent) {
                MappableContent c = (MappableContent)object;
                return c.name;
            }
            return super.convertToString(object);
        }
    };

    public static void writeBytes(Object value, Class<?> elementType, DataOutputStream output) {
        json.setWriter(new UBJsonWriter(output));
        json.writeValue(value, value == null ? null : value.getClass(), elementType);
    }

    public static <T> T readBytes(Class<T> type, Class<?> elementType, DataInputStream input) throws IOException {
        return json.readValue(type, elementType, new UBJsonReader().parseWihoutClosing(input));
    }

    public static String write(Object object) {
        return json.toJson(object, object.getClass());
    }

    public static <T> T copy(T object, T dest) {
        json.copyFields(object, dest);
        return dest;
    }

    public static <T> T copy(T object) {
        return (T)JsonIO.read(object.getClass(), JsonIO.write(object));
    }

    public static <T> T read(Class<T> type, String string) {
        return json.fromJson(type, string.replace("io.anuke.", ""));
    }

    public static <T> T read(Class<T> type, T base, String string) {
        return jsonBase.fromBaseJson(type, base, string.replace("io.anuke.", ""));
    }

    public static String print(String in) {
        return json.prettyPrint(in);
    }

    public static void classTag(String tag, Class<?> type) {
        json.addClassTag(tag, type);
        jsonBase.addClassTag(tag, type);
    }

    static void apply(Json json) {
        json.setElementType(Rules.class, "spawns", SpawnGroup.class);
        json.setElementType(Rules.class, "loadout", ItemStack.class);
        json.setSerializer(Color.class, new Json.Serializer<Color>(){

            @Override
            public void write(Json json, Color object, Class knownType) {
                json.writeValue(object.toString());
            }

            @Override
            public Color read(Json json, JsonValue jsonData, Class type) {
                if (jsonData.isString()) {
                    return Color.valueOf(jsonData.asString());
                }
                Color out = new Color();
                json.readFields(out, jsonData);
                return out;
            }
        });
        json.setSerializer(Sector.class, new Json.Serializer<Sector>(){

            @Override
            public void write(Json json, Sector object, Class knownType) {
                json.writeValue(object.planet.name + "-" + object.id);
            }

            @Override
            public Sector read(Json json, JsonValue jsonData, Class type) {
                String name = jsonData.asString();
                int idx = name.lastIndexOf(45);
                return ((Planet)Vars.content.getByName((ContentType)ContentType.planet, (String)name.substring((int)0, (int)idx))).sectors.get(Integer.parseInt(name.substring(idx + 1)));
            }
        });
        json.setSerializer(SectorPreset.class, new Json.Serializer<SectorPreset>(){

            @Override
            public void write(Json json, SectorPreset object, Class knownType) {
                json.writeValue(object.name);
            }

            @Override
            public SectorPreset read(Json json, JsonValue jsonData, Class type) {
                return (SectorPreset)Vars.content.getByName(ContentType.sector, jsonData.asString());
            }
        });
        json.setSerializer(Liquid.class, new Json.Serializer<Liquid>(){

            @Override
            public void write(Json json, Liquid object, Class knownType) {
                json.writeValue(object.name);
            }

            @Override
            public Liquid read(Json json, JsonValue jsonData, Class type) {
                if (jsonData.asString() == null) {
                    return Liquids.water;
                }
                Liquid i = (Liquid)Vars.content.getByName(ContentType.liquid, jsonData.asString());
                return i == null ? Liquids.water : i;
            }
        });
        json.setSerializer(Attribute.class, new Json.Serializer<Attribute>(){

            @Override
            public void write(Json json, Attribute object, Class knownType) {
                json.writeValue(object.name);
            }

            @Override
            public Attribute read(Json json, JsonValue jsonData, Class type) {
                return Attribute.get(jsonData.asString());
            }
        });
        json.setSerializer(Item.class, new Json.Serializer<Item>(){

            @Override
            public void write(Json json, Item object, Class knownType) {
                json.writeValue(object.name);
            }

            @Override
            public Item read(Json json, JsonValue jsonData, Class type) {
                if (jsonData.asString() == null) {
                    return Items.copper;
                }
                Item i = (Item)Vars.content.getByName(ContentType.item, jsonData.asString());
                return i == null ? Items.copper : i;
            }
        });
        json.setSerializer(Team.class, new Json.Serializer<Team>(){

            @Override
            public void write(Json json, Team object, Class knownType) {
                json.writeValue(object.id);
            }

            @Override
            public Team read(Json json, JsonValue jsonData, Class type) {
                return Team.get(jsonData.asInt());
            }
        });
        json.setSerializer(Block.class, new Json.Serializer<Block>(){

            @Override
            public void write(Json json, Block object, Class knownType) {
                json.writeValue(object.name);
            }

            @Override
            public Block read(Json json, JsonValue jsonData, Class type) {
                Block block = (Block)Vars.content.getByName(ContentType.block, jsonData.asString());
                if (block == null) {
                    block = (Block)Vars.content.getByName(ContentType.block, SaveVersion.fallback.get(jsonData.asString(), ""));
                }
                return block == null ? Blocks.air : block;
            }
        });
        json.setSerializer(Planet.class, new Json.Serializer<Planet>(){

            @Override
            public void write(Json json, Planet object, Class knownType) {
                json.writeValue(object.name);
            }

            @Override
            public Planet read(Json json, JsonValue jsonData, Class type) {
                if (jsonData.asString() == null) {
                    return null;
                }
                Planet block = (Planet)Vars.content.getByName(ContentType.planet, jsonData.asString());
                return block == null ? Planets.serpulo : block;
            }
        });
        json.setSerializer(Weather.class, new Json.Serializer<Weather>(){

            @Override
            public void write(Json json, Weather object, Class knownType) {
                json.writeValue(object.name);
            }

            @Override
            public Weather read(Json json, JsonValue jsonData, Class type) {
                return (Weather)Vars.content.getByName(ContentType.weather, jsonData.asString());
            }
        });
        json.setSerializer(UnitType.class, new Json.Serializer<UnitType>(){

            @Override
            public void write(Json json, UnitType object, Class knownType) {
                json.writeValue(object.name);
            }

            @Override
            public UnitType read(Json json, JsonValue jsonData, Class type) {
                return (UnitType)Vars.content.getByName(ContentType.unit, jsonData.asString());
            }
        });
        json.setSerializer(ItemStack.class, new Json.Serializer<ItemStack>(){

            @Override
            public void write(Json json, ItemStack object, Class knownType) {
                json.writeObjectStart();
                json.writeValue("item", object.item);
                json.writeValue("amount", object.amount);
                json.writeObjectEnd();
            }

            @Override
            public ItemStack read(Json json, JsonValue jsonData, Class type) {
                return new ItemStack(json.getSerializer(Item.class).read(json, jsonData.get("item"), Item.class), jsonData.getInt("amount"));
            }
        });
        json.setSerializer(UnlockableContent.class, new Json.Serializer<UnlockableContent>(){

            @Override
            public void write(Json json, UnlockableContent object, Class knownType) {
                json.writeValue(object == null ? null : object.name);
            }

            @Override
            public UnlockableContent read(Json json, JsonValue jsonData, Class type) {
                UnlockableContent u;
                if (jsonData.isNull()) {
                    return null;
                }
                String str = jsonData.asString();
                MappableContent map = Vars.content.byName(str);
                return map instanceof UnlockableContent ? (u = (UnlockableContent)map) : null;
            }
        });
        json.setSerializer(MapObjectives.class, new Json.Serializer<MapObjectives>(){

            @Override
            public void write(Json json, MapObjectives exec, Class knownType) {
                json.writeArrayStart();
                for (MapObjectives.MapObjective obj : exec) {
                    json.writeObjectStart(obj.getClass().isAnonymousClass() ? obj.getClass().getSuperclass() : obj.getClass(), null);
                    json.writeFields(obj);
                    json.writeArrayStart("parents");
                    for (MapObjectives.MapObjective parent : obj.parents) {
                        json.writeValue(exec.all.indexOf(parent));
                    }
                    json.writeArrayEnd();
                    json.writeValue("editorPos", Point2.pack(obj.editorX, obj.editorY));
                    json.writeObjectEnd();
                }
                json.writeArrayEnd();
            }

            @Override
            public MapObjectives read(Json json, JsonValue data, Class type) {
                MapObjectives exec = new MapObjectives();
                JsonValue value = data.child;
                while (value != null) {
                    if (value.has("class") && Character.isLowerCase(value.getString("class").charAt(0))) {
                        return new MapObjectives();
                    }
                    MapObjectives.MapObjective obj = json.readValue(MapObjectives.MapObjective.class, value);
                    if (value.has("editorPos")) {
                        int pos = value.getInt("editorPos");
                        obj.editorX = Point2.x(pos);
                        obj.editorY = Point2.y(pos);
                    }
                    exec.all.add(obj);
                    obj.validate();
                    value = value.next;
                }
                int i = 0;
                JsonValue value2 = data.child;
                while (value2 != null) {
                    JsonValue parent = value2.get((String)"parents").child;
                    while (parent != null) {
                        int val = parent.asInt();
                        if (val >= 0 && val < exec.all.size) {
                            exec.all.get((int)i).parents.add(exec.all.get(val));
                        }
                        parent = parent.next;
                    }
                    value2 = value2.next;
                    ++i;
                }
                return exec;
            }
        });
        for (Prov<GenerateFilter> filter : Maps.allFilterTypes) {
            GenerateFilter i = filter.get();
            json.addClassTag(Strings.camelize(i.getClass().getSimpleName().replace("Filter", "")), i.getClass());
        }
    }

    static class CustomJson
    extends Json {
        private Object baseObject;

        CustomJson() {
            JsonIO.apply(this);
        }

        @Override
        public <T> T fromJson(Class<T> type, String json) {
            return this.fromBaseJson(type, null, json);
        }

        public <T> T fromBaseJson(Class<T> type, T base, String json) {
            this.baseObject = base;
            return this.readValue(type, null, new JsonReader().parse(json));
        }

        @Override
        protected Object newInstance(Class type) {
            if (this.baseObject == null || this.baseObject.getClass() != type) {
                return super.newInstance(type);
            }
            return this.baseObject;
        }
    }
}

