/*
 * Decompiled with CFR 0.152.
 */
package mindustry.input;

import arc.Core;
import arc.func.Boolf;
import arc.func.Boolf2;
import arc.math.Mathf;
import arc.math.geom.Bresenham2;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.struct.IntFloatMap;
import arc.struct.IntIntMap;
import arc.struct.IntSet;
import arc.struct.PQueue;
import arc.struct.Seq;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.Build;
import mindustry.world.Tile;
import mindustry.world.blocks.distribution.ChainedBuilding;
import mindustry.world.blocks.distribution.DirectionBridge;
import mindustry.world.blocks.distribution.ItemBridge;

public class Placement {
    private static final Seq<BuildPlan> plans1 = new Seq();
    private static final Seq<Point2> tmpPoints = new Seq();
    private static final Seq<Point2> tmpPoints2 = new Seq();
    private static final NormalizeResult result = new NormalizeResult();
    private static final NormalizeDrawResult drawResult = new NormalizeDrawResult();
    private static final Bresenham2 bres = new Bresenham2();
    private static final Seq<Point2> points = new Seq();
    private static final IntFloatMap costs = new IntFloatMap();
    private static final IntIntMap parents = new IntIntMap();
    private static final IntSet closed = new IntSet();

    public static Seq<Point2> pathfindLine(boolean conveyors, int startX, int startY, int endX, int endY) {
        Pools.freeAll(points);
        points.clear();
        if (conveyors && Core.settings.getBool("conveyorpathfinding")) {
            if (Placement.astar(startX, startY, endX, endY)) {
                return points;
            }
            return Placement.normalizeLine(startX, startY, endX, endY);
        }
        return bres.lineNoDiagonal(startX, startY, endX, endY, Pools.get(Point2.class, Point2::new), points);
    }

    public static Seq<Point2> normalizeLine(int startX, int startY, int endX, int endY) {
        Pools.freeAll(points);
        points.clear();
        if (Math.abs(startX - endX) > Math.abs(startY - endY)) {
            for (int i = 0; i <= Math.abs(startX - endX); ++i) {
                points.add(Pools.obtain(Point2.class, Point2::new).set(startX + i * Mathf.sign(endX - startX), startY));
            }
        } else {
            for (int i = 0; i <= Math.abs(startY - endY); ++i) {
                points.add(Pools.obtain(Point2.class, Point2::new).set(startX, startY + i * Mathf.sign(endY - startY)));
            }
        }
        return points;
    }

    public static Seq<Point2> normalizeRectangle(int startX, int startY, int endX, int endY, int blockSize) {
        Pools.freeAll(points);
        points.clear();
        int minX = Math.min(startX, endX);
        int minY = Math.min(startY, endY);
        int maxX = Math.max(startX, endX);
        int maxY = Math.max(startY, endY);
        for (int y = 0; y <= maxY - minY; y += blockSize) {
            for (int x = 0; x <= maxX - minX; x += blockSize) {
                points.add(Pools.obtain(Point2.class, Point2::new).set(startX + x * Mathf.sign(endX - startX), startY + y * Mathf.sign(endY - startY)));
            }
        }
        return points;
    }

    public static Seq<Point2> upgradeLine(int startX, int startY, int endX, int endY) {
        closed.clear();
        Pools.freeAll(points);
        points.clear();
        Building build = Vars.world.build(startX, startY);
        points.add(Pools.obtain(Point2.class, Point2::new).set(startX, startY));
        while (build instanceof ChainedBuilding) {
            ChainedBuilding chain = (ChainedBuilding)((Object)build);
            if (build.tile.x == endX && build.tile.y == endY || !closed.add(build.id)) break;
            if (chain.next() == null) {
                return Placement.pathfindLine(true, startX, startY, endX, endY);
            }
            build = chain.next();
            points.add(Pools.obtain(Point2.class, Point2::new).set(build.tile.x, build.tile.y));
        }
        return points;
    }

    public static void calculateNodes(Seq<Point2> points, Block block, int rotation, Boolf2<Point2, Point2> overlapper) {
        Seq<Point2> base = tmpPoints2;
        Seq<Point2> result = tmpPoints.clear();
        base.selectFrom(points, p -> p == points.first() || p == points.peek() || Build.validPlace(block, Vars.player.team(), p.x, p.y, rotation));
        boolean addedLast = false;
        int i = 0;
        block0: while (i < base.size) {
            Point2 point = base.get(i);
            result.add(point);
            if (i == base.size - 1) {
                addedLast = true;
            }
            for (int j = base.size - 1; j > i; --j) {
                Point2 other = base.get(j);
                boolean over = overlapper.get(point, other);
                if (!over) continue;
                i = j;
                continue block0;
            }
            ++i;
        }
        if (!addedLast && !base.isEmpty()) {
            result.add(base.peek());
        }
        points.clear();
        points.addAll(result);
    }

    public static boolean isSidePlace(Seq<BuildPlan> plans) {
        return plans.size > 1 && Mathf.mod(Tile.relativeTo(plans.first().x, plans.first().y, plans.get((int)1).x, plans.get((int)1).y) - plans.first().rotation, 2) == 1;
    }

    public static void calculateBridges(Seq<BuildPlan> plans, ItemBridge bridge) {
        Placement.calculateBridges(plans, bridge, false, (Block t) -> false);
    }

    public static void calculateBridges(Seq<BuildPlan> plans, ItemBridge bridge, boolean hasJunction, Boolf<Block> avoid) {
        if (Placement.isSidePlace(plans) || plans.size == 0) {
            return;
        }
        if (plans.first().x != plans.peek().x && plans.first().y != plans.peek().y || !bridge.unlockedNow()) {
            return;
        }
        Boolf<BuildPlan> placeable = plan -> (plan.placeable(Vars.player.team()) || plan.tile() != null && plan.tile().block() == plan.block) && (plan == plans.first() || plan.build() == null || plan.build().rotation == plan.rotation || !avoid.get(plan.tile().block()));
        Seq<BuildPlan> result = plans1.clear();
        boolean rotated = plans.first().tile() != null && plans.first().tile().absoluteRelativeTo(plans.peek().x, plans.peek().y) == Mathf.mod(plans.first().rotation + 2, 4);
        int i = 0;
        block0: while (i < plans.size) {
            BuildPlan cur = plans.get(i);
            result.add(cur);
            if (i < plans.size - 1 && placeable.get(cur) && !placeable.get(plans.get(i + 1))) {
                int j;
                boolean wereSame = true;
                for (j = i + 1; j < plans.size; ++j) {
                    BuildPlan other = plans.get(j);
                    if (!bridge.positionsValid(cur.x, cur.y, other.x, other.y)) {
                        for (int k = i + 1; k < j; ++k) {
                            result.add(plans.get(k));
                        }
                        i = j;
                        continue block0;
                    }
                    if (placeable.get(other)) {
                        if (wereSame && hasJunction) {
                            ++i;
                            continue block0;
                        }
                        cur.block = bridge;
                        other.block = bridge;
                        if (rotated) {
                            other.config = new Point2(cur.x - other.x, cur.y - other.y);
                        } else {
                            cur.config = new Point2(other.x - cur.x, other.y - cur.y);
                        }
                        i = j;
                        continue block0;
                    }
                    if (other.tile() == null || avoid.get(other.tile().block())) continue;
                    wereSame = false;
                }
                for (j = i + 1; j < plans.size; ++j) {
                    result.add(plans.get(j));
                }
                break;
            }
            ++i;
        }
        plans.set(result);
    }

    public static void calculateBridges(Seq<BuildPlan> plans, DirectionBridge bridge, boolean hasJunction, Boolf<Block> avoid) {
        if (Placement.isSidePlace(plans) || plans.size == 0) {
            return;
        }
        if (plans.first().x != plans.peek().x && plans.first().y != plans.peek().y || !bridge.unlockedNow()) {
            return;
        }
        Boolf<BuildPlan> placeable = plan -> (plan.placeable(Vars.player.team()) || plan.tile() != null && plan.tile().block() == plan.block) && (plan == plans.first() || plan.build() == null || plan.build().rotation == plan.rotation || !avoid.get(plan.tile().block()));
        Seq<BuildPlan> result = plans1.clear();
        int i = 0;
        block0: while (i < plans.size) {
            BuildPlan cur = plans.get(i);
            result.add(cur);
            if (i < plans.size - 1 && placeable.get(cur) && !placeable.get(plans.get(i + 1))) {
                int j;
                boolean wereSame = true;
                for (j = i + 1; j < plans.size; ++j) {
                    BuildPlan other = plans.get(j);
                    if (!bridge.positionsValid(cur.x, cur.y, other.x, other.y)) {
                        for (int k = i + 1; k < j; ++k) {
                            result.add(plans.get(k));
                        }
                        i = j;
                        continue block0;
                    }
                    if (placeable.get(other)) {
                        if (wereSame && hasJunction) {
                            ++i;
                            continue block0;
                        }
                        cur.block = bridge;
                        other.block = bridge;
                        i = j;
                        continue block0;
                    }
                    if (other.tile() == null || avoid.get(other.tile().block())) continue;
                    wereSame = false;
                }
                for (j = i + 1; j < plans.size; ++j) {
                    result.add(plans.get(j));
                }
                break;
            }
            ++i;
        }
        plans.set(result);
    }

    private static float tileHeuristic(Tile tile, Tile other) {
        Tile prev;
        Block block = Vars.control.input.block;
        if (!other.block().alwaysReplace && (block == null || !block.canReplace(other.block())) || other.floor().isDeep()) {
            return 20.0f;
        }
        if (parents.containsKey(tile.pos()) && tile.relativeTo(prev = Vars.world.tile(parents.get(tile.pos(), 0))) != other.relativeTo(tile)) {
            return 8.0f;
        }
        return 1.0f;
    }

    private static float distanceHeuristic(int x1, int y1, int x2, int y2) {
        return Math.abs(x1 - x2) + Math.abs(y1 - y2);
    }

    private static boolean validNode(Tile tile, Tile other) {
        Block block = Vars.control.input.block;
        if (block != null && block.canReplace(other.block())) {
            return true;
        }
        return other.block().alwaysReplace;
    }

    private static boolean astar(int startX, int startY, int endX, int endY) {
        Tile end;
        Tile start = Vars.world.tile(startX, startY);
        if (start == (end = Vars.world.tile(endX, endY)) || start == null || end == null) {
            return false;
        }
        costs.clear();
        closed.clear();
        parents.clear();
        int nodeLimit = 1000;
        int totalNodes = 0;
        PQueue<Tile> queue = new PQueue<Tile>(10, (a, b) -> Float.compare(costs.get(a.pos(), 0.0f) + Placement.distanceHeuristic(a.x, a.y, end.x, end.y), costs.get(b.pos(), 0.0f) + Placement.distanceHeuristic(b.x, b.y, end.x, end.y)));
        queue.add(start);
        boolean found = false;
        while (!queue.empty() && totalNodes++ < nodeLimit) {
            Tile next = (Tile)queue.poll();
            float baseCost = costs.get(next.pos(), 0.0f);
            if (next == end) {
                found = true;
                break;
            }
            closed.add(Point2.pack(next.x, next.y));
            for (Point2 point : Geometry.d4) {
                int newx = next.x + point.x;
                int newy = next.y + point.y;
                Tile child = Vars.world.tile(newx, newy);
                if (child == null || !Placement.validNode(next, child) || !closed.add(child.pos())) continue;
                parents.put(child.pos(), next.pos());
                costs.put(child.pos(), Placement.tileHeuristic(next, child) + baseCost);
                queue.add(child);
            }
        }
        if (!found) {
            return false;
        }
        int total = 0;
        points.add(Pools.obtain(Point2.class, Point2::new).set(endX, endY));
        Tile current = end;
        while (current != start && total++ < nodeLimit) {
            if (current == null) {
                return false;
            }
            int newPos = parents.get(current.pos(), -1);
            if (newPos == -1) {
                return false;
            }
            points.add(Pools.obtain(Point2.class, Point2::new).set(Point2.x(newPos), Point2.y(newPos)));
            current = Vars.world.tile(newPos);
        }
        points.reverse();
        return true;
    }

    public static NormalizeDrawResult normalizeDrawArea(Block block, int startx, int starty, int endx, int endy, boolean snap, int maxLength, float scaling) {
        Placement.normalizeArea(startx, starty, endx, endy, 0, snap, maxLength);
        float offset = block.offset;
        Placement.drawResult.x = Placement.result.x * 8;
        Placement.drawResult.y = Placement.result.y * 8;
        Placement.drawResult.x2 = Placement.result.x2 * 8;
        Placement.drawResult.y2 = Placement.result.y2 * 8;
        Placement.drawResult.x -= (float)block.size * scaling * 8.0f / 2.0f;
        Placement.drawResult.x2 += (float)block.size * scaling * 8.0f / 2.0f;
        Placement.drawResult.y -= (float)block.size * scaling * 8.0f / 2.0f;
        Placement.drawResult.y2 += (float)block.size * scaling * 8.0f / 2.0f;
        Placement.drawResult.x += offset;
        Placement.drawResult.y += offset;
        Placement.drawResult.x2 += offset;
        Placement.drawResult.y2 += offset;
        return drawResult;
    }

    public static NormalizeResult normalizeArea(int tilex, int tiley, int endx, int endy, int rotation, boolean snap, int maxLength) {
        int t;
        if (snap) {
            if (Math.abs(tilex - endx) > Math.abs(tiley - endy)) {
                endy = tiley;
            } else {
                endx = tilex;
            }
        }
        if (maxLength > 0) {
            if (Math.abs(endx - tilex) > maxLength) {
                endx = Mathf.sign(endx - tilex) * maxLength + tilex;
            }
            if (Math.abs(endy - tiley) > maxLength) {
                endy = Mathf.sign(endy - tiley) * maxLength + tiley;
            }
        }
        int dx = endx - tilex;
        int dy = endy - tiley;
        if (Math.abs(dx) > Math.abs(dy)) {
            rotation = dx >= 0 ? 0 : 2;
        } else if (Math.abs(dx) < Math.abs(dy)) {
            rotation = dy >= 0 ? 1 : 3;
        }
        if (endx < tilex) {
            t = endx;
            endx = tilex;
            tilex = t;
        }
        if (endy < tiley) {
            t = endy;
            endy = tiley;
            tiley = t;
        }
        Placement.result.x2 = endx;
        Placement.result.y2 = endy;
        Placement.result.x = tilex;
        Placement.result.y = tiley;
        Placement.result.rotation = rotation;
        return result;
    }

    public static class NormalizeResult {
        public int x;
        public int y;
        public int x2;
        public int y2;
        public int rotation;
    }

    public static class NormalizeDrawResult {
        public float x;
        public float y;
        public float x2;
        public float y2;
    }
}

