/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics.g3d;

import arc.graphics.Color;
import arc.math.geom.Vec3;
import arc.util.noise.Simplex;
import mindustry.graphics.Shaders;
import mindustry.graphics.g3d.HexMesh;
import mindustry.graphics.g3d.HexMesher;
import mindustry.graphics.g3d.MeshBuilder;
import mindustry.type.Planet;

public class NoiseMesh
extends HexMesh {
    public NoiseMesh(Planet planet, final int seed, int divisions, final Color color, float radius, final int octaves, final float persistence, final float scale, final float mag) {
        this.planet = planet;
        this.shader = Shaders.planet;
        this.mesh = MeshBuilder.buildHex(new HexMesher(){

            @Override
            public float getHeight(Vec3 position) {
                return Simplex.noise3d(7 + seed, octaves, persistence, scale, 5.0f + position.x, 5.0f + position.y, 5.0f + position.z) * mag;
            }

            @Override
            public void getColor(Vec3 position, Color out) {
                out.set(color);
            }
        }, divisions, radius, 0.2f);
    }

    public NoiseMesh(Planet planet, final int seed, int divisions, float radius, final int octaves, final float persistence, final float scale, final float mag, final Color color1, final Color color2, final int coct, final float cper, final float cscl, final float cthresh) {
        this.planet = planet;
        this.shader = Shaders.planet;
        this.mesh = MeshBuilder.buildHex(new HexMesher(){

            @Override
            public float getHeight(Vec3 position) {
                return Simplex.noise3d(7 + seed, octaves, persistence, scale, 5.0f + position.x, 5.0f + position.y, 5.0f + position.z) * mag;
            }

            @Override
            public void getColor(Vec3 position, Color out) {
                out.set(Simplex.noise3d(8 + seed, coct, cper, cscl, 5.0f + position.x, 5.0f + position.y, 5.0f + position.z) > cthresh ? color2 : color1);
            }
        }, divisions, radius, 0.2f);
    }
}

