/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import arc.util.pooling.Pool;
import arc.util.pooling.Pools;
import java.nio.FloatBuffer;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Bullets;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.core.World;
import mindustry.ctype.ContentType;
import mindustry.entities.Damage;
import mindustry.entities.EntityGroup;
import mindustry.entities.Fires;
import mindustry.entities.Puddles;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Drawc;
import mindustry.gen.Entityc;
import mindustry.gen.Firec;
import mindustry.gen.Groups;
import mindustry.gen.IndexableEntity__all;
import mindustry.gen.IndexableEntity__draw;
import mindustry.gen.IndexableEntity__fire;
import mindustry.gen.IndexableEntity__sync;
import mindustry.gen.Player;
import mindustry.gen.Posc;
import mindustry.gen.Puddle;
import mindustry.gen.Sounds;
import mindustry.gen.Syncc;
import mindustry.gen.Timedc;
import mindustry.gen.Unitc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.io.TypeIO;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.meta.Attribute;

public class Fire
implements Pool.Poolable,
Drawc,
Entityc,
Firec,
IndexableEntity__all,
IndexableEntity__draw,
IndexableEntity__fire,
IndexableEntity__sync,
Posc,
Syncc,
Timedc {
    protected static final float damageDelay = 40.0f;
    public static final int duration = 90;
    protected static final float fireballDelay = 40.0f;
    public static final int frames = 40;
    public static final TextureRegion[] regions = new TextureRegion[40];
    protected static final float spreadDelay = 22.0f;
    protected static final float ticksPerFrame = 2.25f;
    protected static final float tileDamage = 1.8f;
    protected static final float unitDamage = 3.0f;
    protected static final float warmupDuration = 20.0f;
    protected transient boolean added;
    protected transient float animation = Mathf.random(39);
    protected transient float damageTimer = Mathf.random(40.0f);
    protected transient float fireballTimer = Mathf.random(40.0f);
    public transient int id = EntityGroup.nextId();
    protected transient int index__all = -1;
    protected transient int index__draw = -1;
    protected transient int index__fire = -1;
    protected transient int index__sync = -1;
    public transient long lastUpdated;
    public float lifetime;
    protected transient float puddleFlammability;
    protected transient float spreadTimer = Mathf.random(22.0f);
    public Tile tile;
    public float time;
    public transient long updateSpacing;
    protected transient float warmup = 0.0f;
    public float x;
    private transient float x_LAST_;
    private transient float x_TARGET_;
    public float y;
    private transient float y_LAST_;
    private transient float y_TARGET_;

    protected Fire() {
    }

    @Override
    @Nullable
    public Building buildOn() {
        return Vars.world.buildWorld(this.x, this.y);
    }

    @Override
    @Nullable
    public Tile tileOn() {
        return Vars.world.tileWorld(this.x, this.y);
    }

    @Override
    public float lifetime() {
        return this.lifetime;
    }

    @Override
    public float time() {
        return this.time;
    }

    @Override
    public float x() {
        return this.x;
    }

    @Override
    public float y() {
        return this.y;
    }

    @Override
    public int classId() {
        return 10;
    }

    @Override
    public int id() {
        return this.id;
    }

    public String toString() {
        return "Fire#" + this.id;
    }

    @Override
    public long lastUpdated() {
        return this.lastUpdated;
    }

    @Override
    public long updateSpacing() {
        return this.updateSpacing;
    }

    @Override
    public void id(int id) {
        this.id = id;
    }

    @Override
    public void lastUpdated(long lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    @Override
    public void lifetime(float lifetime) {
        this.lifetime = lifetime;
    }

    @Override
    public void setIndex__all(int index) {
        this.index__all = index;
    }

    @Override
    public void setIndex__draw(int index) {
        this.index__draw = index;
    }

    @Override
    public void setIndex__fire(int index) {
        this.index__fire = index;
    }

    @Override
    public void setIndex__sync(int index) {
        this.index__sync = index;
    }

    @Override
    public void time(float time) {
        this.time = time;
    }

    @Override
    public void updateSpacing(long updateSpacing) {
        this.updateSpacing = updateSpacing;
    }

    @Override
    public void x(float x) {
        this.x = x;
    }

    @Override
    public void y(float y) {
        this.y = y;
    }

    @Override
    public void read(Reads read) {
        short REV = read.s();
        if (REV == 0) {
            read.f();
            Vars.content.getByID(ContentType.block, read.s());
            this.lifetime = read.f();
            read.f();
            this.tile = TypeIO.readTile(read);
            this.time = read.f();
            this.x = read.f();
            this.y = read.f();
        } else if (REV == 1) {
            this.lifetime = read.f();
            this.tile = TypeIO.readTile(read);
            this.time = read.f();
            this.x = read.f();
            this.y = read.f();
        } else {
            throw new IllegalArgumentException("Unknown revision '" + REV + "' for entity type 'FireComp'");
        }
        this.afterRead();
    }

    @Override
    public void write(Writes write) {
        write.s(1);
        write.f(this.lifetime);
        TypeIO.writeTile(write, this.tile);
        write.f(this.time);
        write.f(this.x);
        write.f(this.y);
    }

    @Override
    public <T extends Entityc> T self() {
        return (T)this;
    }

    @Override
    public <T> T as() {
        return (T)this;
    }

    @Override
    public boolean isAdded() {
        return this.added;
    }

    @Override
    public boolean isLocal() {
        Unitc u;
        Fire fire;
        return this == Vars.player || (fire = this) instanceof Unitc && (u = (Unitc)((Object)fire)).controller() == Vars.player;
    }

    @Override
    public boolean isRemote() {
        Unitc u;
        Fire fire = this;
        return fire instanceof Unitc && (u = (Unitc)((Object)fire)).isPlayer() && !this.isLocal();
    }

    @Override
    public boolean isSyncHidden(Player player) {
        return false;
    }

    @Override
    public boolean onSolid() {
        Tile tile = this.tileOn();
        return tile == null || tile.solid();
    }

    @Override
    public boolean serialize() {
        return true;
    }

    @Override
    public float clipSize() {
        return 25.0f;
    }

    @Override
    public float fin() {
        return this.time / this.lifetime;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public int tileX() {
        return World.toTile(this.x);
    }

    @Override
    public int tileY() {
        return World.toTile(this.y);
    }

    @Override
    public Block blockOn() {
        Tile tile = this.tileOn();
        return tile == null ? Blocks.air : tile.block();
    }

    @Override
    public Floor floorOn() {
        Tile tile = this.tileOn();
        return tile == null || tile.block() != Blocks.air ? (Floor)Blocks.air : tile.floor();
    }

    public static Fire create() {
        return Pools.obtain(Fire.class, Fire::new);
    }

    @Override
    public void add() {
        if (this.added) {
            return;
        }
        this.index__all = Groups.all.addIndex(this);
        this.index__sync = Groups.sync.addIndex(this);
        this.index__draw = Groups.draw.addIndex(this);
        this.index__fire = Groups.fire.addIndex(this);
        this.added = true;
    }

    @Override
    public void afterRead() {
        Fires.register(this);
    }

    @Override
    public void afterReadAll() {
    }

    @Override
    public void afterSync() {
        Fires.register(this);
    }

    @Override
    public void beforeWrite() {
    }

    @Override
    public void draw() {
        if (regions[0] == null) {
            for (int i = 0; i < 40; ++i) {
                Fire.regions[i] = Core.atlas.find("fire" + i);
            }
        }
        Draw.color(1.0f, 1.0f, 1.0f, Mathf.clamp(this.warmup / 20.0f));
        Draw.z(110.0f);
        Draw.rect(regions[Math.min((int)this.animation, regions.length - 1)], this.x + Mathf.randomSeedRange((int)this.y, 2.0f), this.y + Mathf.randomSeedRange((int)this.x, 2.0f));
        Draw.reset();
        Drawf.light(this.x, this.y, 50.0f + Mathf.absin(5.0f, 5.0f), Pal.lightFlame, 0.6f * Mathf.clamp(this.warmup / 20.0f));
    }

    @Override
    public void handleSyncHidden() {
    }

    @Override
    public void interpolate() {
        if (this.lastUpdated != 0L && this.updateSpacing != 0L) {
            float timeSinceUpdate = Time.timeSinceMillis(this.lastUpdated);
            float alpha = Math.min(timeSinceUpdate / (float)this.updateSpacing, 2.0f);
            this.x = Mathf.lerp(this.x_LAST_, this.x_TARGET_, alpha);
            this.y = Mathf.lerp(this.y_LAST_, this.y_TARGET_, alpha);
        } else if (this.lastUpdated != 0L) {
            this.x = this.x_TARGET_;
            this.y = this.y_TARGET_;
        }
    }

    @Override
    public void readSync(Reads read) {
        if (this.lastUpdated != 0L) {
            this.updateSpacing = Time.timeSinceMillis(this.lastUpdated);
        }
        this.lastUpdated = Time.millis();
        boolean islocal = this.isLocal();
        this.lifetime = read.f();
        this.tile = TypeIO.readTile(read);
        this.time = read.f();
        if (!islocal) {
            this.x_LAST_ = this.x;
            this.x_TARGET_ = read.f();
        } else {
            read.f();
            this.x_LAST_ = this.x;
            this.x_TARGET_ = this.x;
        }
        if (!islocal) {
            this.y_LAST_ = this.y;
            this.y_TARGET_ = read.f();
        } else {
            read.f();
            this.y_LAST_ = this.y;
            this.y_TARGET_ = this.y;
        }
        this.afterSync();
    }

    @Override
    public void readSyncManual(FloatBuffer buffer) {
        if (this.lastUpdated != 0L) {
            this.updateSpacing = Time.timeSinceMillis(this.lastUpdated);
        }
        this.lastUpdated = Time.millis();
        this.x_LAST_ = this.x;
        this.x_TARGET_ = buffer.get();
        this.y_LAST_ = this.y;
        this.y_TARGET_ = buffer.get();
    }

    @Override
    public void remove() {
        if (!this.added) {
            return;
        }
        Groups.all.removeIndex(this, this.index__all);
        this.index__all = -1;
        Groups.sync.removeIndex(this, this.index__sync);
        this.index__sync = -1;
        Groups.draw.removeIndex(this, this.index__draw);
        this.index__draw = -1;
        Groups.fire.removeIndex(this, this.index__fire);
        this.index__fire = -1;
        this.added = false;
        Fx.fireRemove.at(this.x, this.y, this.animation);
        Fires.remove(this.tile);
        if (Vars.net.client()) {
            Vars.netClient.addRemovedEntity(this.id());
        }
        Groups.queueFree(this);
    }

    @Override
    public void reset() {
        this.added = false;
        this.animation = Mathf.random(39);
        this.damageTimer = Mathf.random(40.0f);
        this.fireballTimer = Mathf.random(40.0f);
        this.id = EntityGroup.nextId();
        this.lastUpdated = 0L;
        this.lifetime = 0.0f;
        this.puddleFlammability = 0.0f;
        this.spreadTimer = Mathf.random(22.0f);
        this.tile = null;
        this.time = 0.0f;
        this.updateSpacing = 0L;
        this.warmup = 0.0f;
        this.x = 0.0f;
        this.y = 0.0f;
    }

    @Override
    public void set(Position pos) {
        this.set(pos.getX(), pos.getY());
    }

    @Override
    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void snapInterpolation() {
        this.updateSpacing = 16L;
        this.lastUpdated = Time.millis();
        this.x_LAST_ = this.x;
        this.x_TARGET_ = this.x;
        this.y_LAST_ = this.y;
        this.y_TARGET_ = this.y;
    }

    @Override
    public void snapSync() {
        this.updateSpacing = 16L;
        this.lastUpdated = Time.millis();
        this.x_LAST_ = this.x_TARGET_;
        this.x = this.x_TARGET_;
        this.y_LAST_ = this.y_TARGET_;
        this.y = this.y_TARGET_;
    }

    @Override
    public void trns(Position pos) {
        this.trns(pos.getX(), pos.getY());
    }

    @Override
    public void trns(float x, float y) {
        this.set(this.x + x, this.y + y);
    }

    @Override
    public void update() {
        this.animation += Time.delta / 2.25f;
        this.warmup += Time.delta;
        this.animation %= 40.0f;
        if (!Vars.headless) {
            Vars.control.sound.loop(Sounds.fire, this, 0.07f);
        }
        float speedMultiplier = 1.0f + Math.max(Vars.state.envAttrs.get(Attribute.water) * 10.0f, 0.0f);
        this.time = Mathf.clamp(this.time + Time.delta * speedMultiplier, 0.0f, this.lifetime);
        if (!Vars.net.client()) {
            if (this.time >= this.lifetime || this.tile == null || Float.isNaN(this.lifetime)) {
                this.remove();
            } else {
                float f;
                Object p;
                Building entity = this.tile.build;
                boolean damage = entity != null;
                float flammability = this.tile.getFlammability() + this.puddleFlammability;
                if (!damage && flammability <= 0.0f) {
                    this.time += Time.delta * 8.0f;
                }
                if (damage) {
                    this.lifetime += Mathf.clamp(flammability / 8.0f, 0.0f, 0.6f) * Time.delta;
                }
                if (flammability > 1.0f) {
                    float f2;
                    this.spreadTimer += Time.delta * Mathf.clamp(flammability / 5.0f, 0.3f, 2.0f);
                    if (f2 >= 22.0f) {
                        this.spreadTimer = 0.0f;
                        p = Geometry.d4[Mathf.random(3)];
                        Tile other = Vars.world.tile(this.tile.x + ((Point2)p).x, this.tile.y + ((Point2)p).y);
                        Fires.create(other);
                    }
                }
                if (flammability > 0.0f) {
                    float f3;
                    this.fireballTimer += Time.delta * Mathf.clamp(flammability / 10.0f, 0.0f, 0.5f);
                    if (f3 >= 40.0f) {
                        this.fireballTimer = 0.0f;
                        Bullets.fireball.createNet(Team.derelict, this.x, this.y, Mathf.random(360.0f), -1.0f, 1.0f, 1.0f);
                    }
                }
                this.damageTimer += Time.delta;
                if (f >= 40.0f) {
                    this.damageTimer = 0.0f;
                    p = Puddles.get(this.tile);
                    float f4 = this.puddleFlammability = p != null ? ((Puddle)p).getFlammability() / 3.0f : 0.0f;
                    if (damage) {
                        entity.damage(1.8f);
                    }
                    Damage.damageUnits(null, this.tile.worldx(), this.tile.worldy(), 8.0f, 3.0f, unit -> !unit.isFlying() && !unit.isImmune(StatusEffects.burning), unit -> unit.apply(StatusEffects.burning, 300.0f));
                }
            }
        }
        if (Vars.net.client() && !this.isLocal() || this.isRemote()) {
            this.interpolate();
        }
        this.time = Math.min(this.time + Time.delta, this.lifetime);
        if (this.time >= this.lifetime) {
            this.remove();
        }
    }

    @Override
    public void writeSync(Writes write) {
        write.f(this.lifetime);
        TypeIO.writeTile(write, this.tile);
        write.f(this.time);
        write.f(this.x);
        write.f(this.y);
    }

    @Override
    public void writeSyncManual(FloatBuffer buffer) {
        buffer.put(this.x);
        buffer.put(this.y);
    }
}

