/*
 * Decompiled with CFR 0.152.
 */
package mindustry.game;

import arc.Core;
import arc.func.Boolf;
import arc.func.Cons;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.math.geom.Vec2;
import arc.scene.ui.layout.Scl;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Pack;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Tmp;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Iterator;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Items;
import mindustry.content.UnitTypes;
import mindustry.core.UI;
import mindustry.ctype.UnlockableContent;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Unit;
import mindustry.gen.WorldLabel;
import mindustry.graphics.Pal;
import mindustry.io.JsonIO;
import mindustry.logic.LMarkerControl;
import mindustry.type.Item;
import mindustry.type.UnitType;
import mindustry.world.Block;

public class MapObjectives
implements Iterable<MapObjective>,
Eachable<MapObjective> {
    public static final Seq<Prov<? extends MapObjective>> allObjectiveTypes = new Seq();
    public static final Seq<Prov<? extends ObjectiveMarker>> allMarkerTypes = new Seq();
    public static final ObjectMap<String, Prov<? extends ObjectiveMarker>> markerNameToType = new ObjectMap();
    public static final Seq<String> allMarkerTypeNames = new Seq();
    public Seq<MapObjective> all = new Seq(4);

    @SafeVarargs
    public static void registerObjective(Prov<? extends MapObjective> ... providers) {
        for (Prov<? extends MapObjective> prov : providers) {
            allObjectiveTypes.add(prov);
            Class<?> type = prov.get().getClass();
            String name = type.getSimpleName().replace("Objective", "");
            JsonIO.classTag(Strings.camelize(name), type);
            JsonIO.classTag(name, type);
        }
    }

    @SafeVarargs
    public static void registerMarker(Prov<? extends ObjectiveMarker> ... providers) {
        for (Prov<? extends ObjectiveMarker> prov : providers) {
            allMarkerTypes.add(prov);
            Class<?> type = prov.get().getClass();
            String name = type.getSimpleName().replace("Marker", "");
            allMarkerTypeNames.add(Strings.camelize(name));
            markerNameToType.put(name, prov);
            markerNameToType.put(Strings.camelize(name), prov);
            JsonIO.classTag(Strings.camelize(name), type);
            JsonIO.classTag(name, type);
        }
    }

    public static void registerLegacyMarker(String name, Prov<? extends ObjectiveMarker> prov) {
        Class<?> type = prov.get().getClass();
        markerNameToType.put(name, prov);
        markerNameToType.put(Strings.camelize(name), prov);
        JsonIO.classTag(Strings.camelize(name), type);
        JsonIO.classTag(name, type);
    }

    public MapObjectives(Seq<MapObjective> all) {
        this.all.addAll(all);
    }

    public MapObjectives() {
    }

    public void add(MapObjective ... objectives) {
        for (MapObjective objective : objectives) {
            this.flatten(objective);
        }
    }

    private void flatten(MapObjective objective) {
        for (MapObjective child : objective.children) {
            this.flatten(child);
        }
        objective.children.clear();
        this.all.add(objective);
    }

    public void update() {
        this.eachRunning(obj -> {
            if (obj.update() && !Vars.net.client()) {
                Call.completeObjective(this.all.indexOf((MapObjective)obj));
            }
        });
    }

    @Nullable
    public MapObjective get(int index) {
        return index < 0 || index >= this.all.size ? null : this.all.get(index);
    }

    public boolean any() {
        return this.all.count(MapObjective::qualified) > 0;
    }

    public void clear() {
        this.all.clear();
    }

    public void eachRunning(Cons<MapObjective> cons) {
        this.all.each(MapObjective::qualified, cons);
    }

    public <T extends MapObjective> void eachRunning(Boolf<? super MapObjective> pred, Cons<T> cons) {
        this.all.each(obj -> obj.qualified() && pred.get((MapObjective)obj), cons);
    }

    @Override
    public Iterator<MapObjective> iterator() {
        return this.all.iterator();
    }

    @Override
    public void each(Cons<? super MapObjective> cons) {
        this.all.each(cons);
    }

    private static void lookupRegion(String name, TextureRegion out) {
        TextureAtlas.AtlasRegion region = Core.atlas.find(name);
        if (region.found()) {
            out.set(region);
        } else if (Core.assets.isLoaded(name, Texture.class)) {
            out.set(Core.assets.get(name, Texture.class));
        } else {
            out.set(Core.atlas.find("error"));
        }
    }

    static {
        MapObjectives.registerObjective(ResearchObjective::new, ProduceObjective::new, ItemObjective::new, CoreItemObjective::new, BuildCountObjective::new, UnitCountObjective::new, DestroyUnitsObjective::new, TimerObjective::new, DestroyBlockObjective::new, DestroyBlocksObjective::new, DestroyCoreObjective::new, CommandModeObjective::new, FlagObjective::new);
        MapObjectives.registerMarker(ShapeTextMarker::new, PointMarker::new, ShapeMarker::new, TextMarker::new, LineMarker::new, TextureMarker::new, QuadMarker::new);
        MapObjectives.registerLegacyMarker("Minimap", PointMarker::new);
    }

    public static abstract class MapObjective {
        public boolean hidden;
        @Nullable
        @Multiline
        public String details;
        @Unordered
        public String[] flagsAdded = new String[0];
        @Unordered
        public String[] flagsRemoved = new String[0];
        public ObjectiveMarker[] markers = new ObjectiveMarker[0];
        public transient Seq<MapObjective> parents = new Seq(2);
        private final transient Seq<MapObjective> children = new Seq(2);
        public transient int editorX = -999;
        public transient int editorY = -999;
        private boolean completed;
        private transient boolean depFinished;

        public abstract boolean update();

        public void reset() {
        }

        public void done() {
            Vars.state.rules.objectiveFlags.removeAll((String[])this.flagsRemoved);
            Vars.state.rules.objectiveFlags.addAll((String[])this.flagsAdded);
            this.completed = true;
        }

        public final boolean dependencyFinished() {
            if (this.depFinished) {
                return true;
            }
            for (MapObjective parent : this.parents) {
                if (parent.isCompleted()) continue;
                return false;
            }
            this.depFinished = true;
            return true;
        }

        public final boolean isCompleted() {
            return this.completed;
        }

        public boolean qualified() {
            return !this.completed && this.dependencyFinished();
        }

        public MapObjective child(MapObjective child) {
            child.parents.add(this);
            this.children.add(child);
            return this;
        }

        public MapObjective parent(MapObjective parent) {
            this.parents.add(parent);
            return this;
        }

        public MapObjective details(String details) {
            this.details = details;
            return this;
        }

        public MapObjective flagsAdded(String ... flagsAdded) {
            this.flagsAdded = flagsAdded;
            return this;
        }

        public MapObjective flagsRemoved(String ... flagsRemoved) {
            this.flagsRemoved = flagsRemoved;
            return this;
        }

        public MapObjective markers(ObjectiveMarker ... markers) {
            this.markers = markers;
            return this;
        }

        @Nullable
        public String text() {
            return null;
        }

        @Nullable
        public String details() {
            return this.details;
        }

        public String typeName() {
            String className = this.getClass().getSimpleName().replace("Objective", "");
            return Core.bundle == null ? className : Core.bundle.get("objective." + className.toLowerCase() + ".name", className);
        }

        public void validate() {
        }
    }

    public static abstract class ObjectiveMarker {
        public transient int arrayIndex;
        public boolean world = true;
        public boolean minimap = false;
        public boolean autoscale = false;
        protected float drawLayer = 120.0f;

        public void draw(float scaleFactor) {
        }

        public void control(LMarkerControl type, double p1, double p2, double p3) {
            if (Double.isNaN(p1)) {
                return;
            }
            switch (type) {
                case world: {
                    this.world = !Mathf.equal((float)p1, 0.0f);
                    break;
                }
                case minimap: {
                    this.minimap = !Mathf.equal((float)p1, 0.0f);
                    break;
                }
                case autoscale: {
                    this.autoscale = !Mathf.equal((float)p1, 0.0f);
                    break;
                }
                case drawLayer: {
                    this.drawLayer = (float)p1;
                }
            }
        }

        public void setText(String text, boolean fetch) {
        }

        public void setTexture(String textureName) {
        }

        public String typeName() {
            String className = this.getClass().getSimpleName().replace("Marker", "");
            return Core.bundle == null ? className : Core.bundle.get("marker." + className.toLowerCase() + ".name", className);
        }

        public static String fetchText(String text) {
            if (text == null) {
                return "";
            }
            if (text.startsWith("@")) {
                String key = text.substring(1);
                String out = Vars.mobile ? (Vars.state.mapLocales.containsProperty(key + ".mobile") ? Vars.state.mapLocales.getProperty(key + ".mobile") : (Vars.state.mapLocales.containsProperty(key) ? Vars.state.mapLocales.getProperty(key) : Core.bundle.get(key + ".mobile", Core.bundle.get(key)))) : (Vars.state.mapLocales.containsProperty(key) ? Vars.state.mapLocales.getProperty(key) : Core.bundle.get(key));
                return UI.formatIcons(out);
            }
            return UI.formatIcons(text);
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TilePos {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Second {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Multiline {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Synthetic {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Researchable {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Alignment {
        public boolean hor() default true;

        public boolean ver() default true;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface LabelFlag {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Vertices {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Immutable {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Unordered {
    }

    public static class QuadMarker
    extends ObjectiveMarker {
        public String textureName = "white";
        @Vertices
        public float[] vertices = new float[24];
        private boolean mapRegion = true;
        @Nullable
        private transient TextureRegion fetchedRegion;

        public QuadMarker() {
            for (int i = 0; i < 4; ++i) {
                this.vertices[i * 6 + 2] = Color.white.toFloatBits();
                this.vertices[i * 6 + 5] = Color.clearFloatBits;
            }
        }

        @Override
        public void draw(float scaleFactor) {
            if (this.fetchedRegion == null) {
                this.setTexture(this.textureName);
            }
            Draw.z(this.drawLayer);
            Draw.vert(this.fetchedRegion.texture, this.vertices, 0, this.vertices.length);
        }

        @Override
        public void control(LMarkerControl type, double p1, double p2, double p3) {
            super.control(type, p1, p2, p3);
            if (!Double.isNaN(p1)) {
                switch (type) {
                    case color: {
                        float col = Tmp.c1.fromDouble(p1).toFloatBits();
                        for (int i = 0; i < 4; ++i) {
                            this.vertices[i * 6 + 2] = col;
                        }
                        break;
                    }
                    case pos: {
                        this.vertices[0] = (float)p1 * 8.0f;
                        break;
                    }
                    case posi: {
                        this.setPos((int)p1, p2, p3);
                        break;
                    }
                    case uvi: {
                        this.setUv((int)p1, p2, p3);
                    }
                }
            }
            if (!Double.isNaN(p2)) {
                switch (type) {
                    case pos: {
                        this.vertices[1] = (float)p1 * 8.0f;
                    }
                }
            }
            if (!Double.isNaN(p1) && !Double.isNaN(p2)) {
                switch (type) {
                    case colori: {
                        this.setColor((int)p1, p2);
                    }
                }
            }
        }

        @Override
        public void setTexture(String textureName) {
            block5: {
                block4: {
                    boolean firstUpdate;
                    this.textureName = textureName;
                    if (Vars.headless) {
                        return;
                    }
                    boolean bl = firstUpdate = this.fetchedRegion == null;
                    if (firstUpdate) {
                        this.fetchedRegion = new TextureRegion();
                    }
                    Tmp.tr1.set(this.fetchedRegion);
                    MapObjectives.lookupRegion(textureName, this.fetchedRegion);
                    if (!firstUpdate) break block4;
                    if (!this.mapRegion) break block5;
                    this.mapRegion = false;
                    for (int i = 0; i < 4; ++i) {
                        this.setUv(i, this.vertices[i * 6 + 3], this.vertices[i * 6 + 4]);
                    }
                    break block5;
                }
                for (int i = 0; i < 4; ++i) {
                    this.setUv(i, QuadMarker.unmap(this.vertices[i * 6 + 3], Tmp.tr1.u, Tmp.tr1.u2), 1.0f - QuadMarker.unmap(this.vertices[i * 6 + 4], Tmp.tr1.v, Tmp.tr1.v2));
                }
            }
        }

        private static float unmap(float x, float from, float to) {
            if (Mathf.equal(from, to)) {
                return x;
            }
            return (x - from) / (to - from);
        }

        private void setPos(int i, double x, double y) {
            if (i >= 0 && i < 4) {
                if (!Double.isNaN(x)) {
                    this.vertices[i * 6] = (float)x * 8.0f;
                }
                if (!Double.isNaN(y)) {
                    this.vertices[i * 6 + 1] = (float)y * 8.0f;
                }
            }
        }

        private void setColor(int i, double c) {
            if (i >= 0 && i < 4) {
                this.vertices[i * 6 + 2] = Tmp.c1.fromDouble(c).toFloatBits();
            }
        }

        private void setUv(int i, double u, double v) {
            if (Vars.headless) {
                return;
            }
            if (i >= 0 && i < 4) {
                if (this.fetchedRegion == null) {
                    this.setTexture(this.textureName);
                }
                if (!Double.isNaN(u)) {
                    boolean clampU = this.fetchedRegion.texture.getUWrap() != Texture.TextureWrap.mirroredRepeat && this.fetchedRegion.texture.getUWrap() != Texture.TextureWrap.repeat;
                    this.vertices[i * 6 + 3] = Mathf.map(clampU ? Mathf.clamp((float)u) : (float)u, this.fetchedRegion.u, this.fetchedRegion.u2);
                }
                if (!Double.isNaN(v)) {
                    boolean clampV = this.fetchedRegion.texture.getVWrap() != Texture.TextureWrap.mirroredRepeat && this.fetchedRegion.texture.getVWrap() != Texture.TextureWrap.repeat;
                    this.vertices[i * 6 + 4] = Mathf.map(clampV ? 1.0f - Mathf.clamp((float)v) : 1.0f - (float)v, this.fetchedRegion.v, this.fetchedRegion.v2);
                }
            }
        }
    }

    public static class TextureMarker
    extends PosMarker {
        public float rotation = 0.0f;
        public float width = 0.0f;
        public float height = 0.0f;
        public String textureName = "";
        public Color color = Color.white.cpy();
        private transient TextureRegion fetchedRegion;

        public TextureMarker(String textureName, float x, float y, float width, float height) {
            this.textureName = textureName;
            this.pos.set(x, y);
            this.width = width;
            this.height = height;
        }

        public TextureMarker(String textureName, float x, float y) {
            this.textureName = textureName;
            this.pos.set(x, y);
        }

        public TextureMarker() {
        }

        @Override
        public void control(LMarkerControl type, double p1, double p2, double p3) {
            super.control(type, p1, p2, p3);
            if (!Double.isNaN(p1)) {
                switch (type) {
                    case rotation: {
                        this.rotation = (float)p1;
                        break;
                    }
                    case textureSize: {
                        this.width = (float)p1 * 8.0f;
                        break;
                    }
                    case color: {
                        this.color.fromDouble(p1);
                    }
                }
            }
            if (!Double.isNaN(p2)) {
                switch (type) {
                    case textureSize: {
                        this.height = (float)p2 * 8.0f;
                    }
                }
            }
        }

        @Override
        public void draw(float scaleFactor) {
            if (this.textureName.isEmpty()) {
                return;
            }
            if (this.fetchedRegion == null) {
                this.setTexture(this.textureName);
            }
            if (Mathf.equal(this.width, 0.0f)) {
                this.width = (float)this.fetchedRegion.width * this.fetchedRegion.scl() * Draw.xscl;
            }
            if (Mathf.equal(this.height, 0.0f)) {
                this.height = (float)this.fetchedRegion.height * this.fetchedRegion.scl() * Draw.yscl;
            }
            Draw.z(this.drawLayer);
            Draw.color(this.color);
            Draw.rect(this.fetchedRegion, this.pos.x, this.pos.y, this.width * scaleFactor, this.height * scaleFactor, this.rotation);
        }

        @Override
        public void setTexture(String textureName) {
            this.textureName = textureName;
            if (Vars.headless) {
                return;
            }
            if (this.fetchedRegion == null) {
                this.fetchedRegion = new TextureRegion();
            }
            MapObjectives.lookupRegion(textureName, this.fetchedRegion);
        }
    }

    public static class LineMarker
    extends PosMarker {
        @TilePos
        public Vec2 endPos = new Vec2();
        public float stroke = 1.0f;
        public boolean outline = true;
        public Color color1 = Color.valueOf("ffd37f");
        public Color color2 = Color.valueOf("ffd37f");

        public LineMarker(float x1, float y1, float x2, float y2, float stroke) {
            this.stroke = stroke;
            this.pos.set(x1, y1);
            this.endPos.set(x2, y2);
        }

        public LineMarker(float x1, float y1, float x2, float y2) {
            this.pos.set(x1, y1);
            this.endPos.set(x2, y2);
        }

        public LineMarker() {
        }

        @Override
        public void draw(float scaleFactor) {
            Draw.z(this.drawLayer);
            if (this.outline) {
                Lines.stroke((this.stroke + 2.0f) * scaleFactor, Pal.gray);
                Lines.line(this.pos.x, this.pos.y, this.endPos.x, this.endPos.y);
            }
            Lines.stroke(this.stroke * scaleFactor, Color.white);
            Lines.line(this.pos.x, this.pos.y, this.color1, this.endPos.x, this.endPos.y, this.color2);
        }

        @Override
        public void control(LMarkerControl type, double p1, double p2, double p3) {
            super.control(type, p1, p2, p3);
            if (!Double.isNaN(p1)) {
                switch (type) {
                    case endPos: {
                        this.endPos.x = (float)p1 * 8.0f;
                        break;
                    }
                    case stroke: {
                        this.stroke = (float)p1;
                        break;
                    }
                    case color: {
                        this.color1.set(this.color2.fromDouble(p1));
                        break;
                    }
                    case outline: {
                        boolean bl = this.outline = !Mathf.equal((float)p1, 0.0f);
                    }
                }
            }
            if (!Double.isNaN(p2)) {
                switch (type) {
                    case endPos: {
                        this.endPos.y = (float)p2 * 8.0f;
                    }
                }
            }
            if (!Double.isNaN(p1) && !Double.isNaN(p2)) {
                switch (type) {
                    case posi: {
                        ((int)p1 == 0 ? this.pos : ((int)p1 == 1 ? this.endPos : Tmp.v1)).x = (float)p2 * 8.0f;
                        break;
                    }
                    case colori: {
                        ((int)p1 == 0 ? this.color1 : ((int)p1 == 1 ? this.color2 : Tmp.c1)).fromDouble(p2);
                    }
                }
            }
            if (!Double.isNaN(p1) && !Double.isNaN(p3)) {
                switch (type) {
                    case posi: {
                        ((int)p1 == 0 ? this.pos : ((int)p1 == 1 ? this.endPos : Tmp.v1)).y = (float)p3 * 8.0f;
                    }
                }
            }
        }
    }

    public static class TextMarker
    extends PosMarker {
        @Multiline
        public String text = "uwu";
        public float fontSize = 1.0f;
        @LabelFlag
        public byte flags = (byte)3;
        @Alignment
        public int textAlign = 1;
        @Alignment(ver=false)
        public int lineAlign = 1;
        private transient String fetchedText;

        public TextMarker(String text, float x, float y, float fontSize, byte flags) {
            this.text = text;
            this.fontSize = fontSize;
            this.flags = flags;
            this.pos.set(x, y);
        }

        public TextMarker(String text, float x, float y) {
            this.text = text;
            this.pos.set(x, y);
        }

        public TextMarker() {
        }

        @Override
        public void draw(float scaleFactor) {
            if (Mathf.equal(this.fontSize, 0.0f)) {
                return;
            }
            if (this.fetchedText == null) {
                this.fetchedText = TextMarker.fetchText(this.text);
            }
            WorldLabel.drawAt(this.fetchedText, this.pos.x, this.pos.y, this.drawLayer, this.flags, this.fontSize * scaleFactor, this.textAlign, this.lineAlign);
        }

        @Override
        public void control(LMarkerControl type, double p1, double p2, double p3) {
            super.control(type, p1, p2, p3);
            if (!Double.isNaN(p1)) {
                switch (type) {
                    case fontSize: {
                        this.fontSize = (float)p1;
                        break;
                    }
                    case textAlign: {
                        this.textAlign = (int)p1;
                        break;
                    }
                    case lineAlign: {
                        this.lineAlign = (int)p1;
                        break;
                    }
                    case outline: {
                        this.flags = (byte)Pack.bitmask(this.flags, 2, !Mathf.equal((float)p1, 0.0f));
                        break;
                    }
                    case labelFlags: {
                        this.flags = (byte)Pack.bitmask(this.flags, 1, !Mathf.equal((float)p1, 0.0f));
                    }
                }
            }
            if (!Double.isNaN(p2)) {
                switch (type) {
                    case labelFlags: {
                        this.flags = (byte)Pack.bitmask(this.flags, 2, !Mathf.equal((float)p2, 0.0f));
                    }
                }
            }
        }

        @Override
        public void setText(String text, boolean fetch) {
            this.text = text;
            this.fetchedText = fetch ? TextMarker.fetchText(this.text) : this.text;
        }
    }

    public static class ShapeMarker
    extends PosMarker {
        public float radius = 8.0f;
        public float rotation = 0.0f;
        public float stroke = 1.0f;
        public float startAngle = 0.0f;
        public float endAngle = 360.0f;
        public boolean fill = false;
        public boolean outline = true;
        public int sides = 4;
        public Color color = Color.valueOf("ffd37f");

        public ShapeMarker(float x, float y) {
            this.pos.set(x, y);
        }

        public ShapeMarker(float x, float y, float radius, float rotation) {
            this.pos.set(x, y);
            this.radius = radius;
            this.rotation = rotation;
        }

        public ShapeMarker() {
        }

        @Override
        public void draw(float scaleFactor) {
            int sides = Math.min(this.sides, 200);
            Draw.z(this.drawLayer);
            if (!this.fill) {
                if (this.outline) {
                    Lines.stroke((this.stroke + 2.0f) * scaleFactor, Pal.gray);
                    Lines.poly(this.pos.x, this.pos.y, sides, (this.radius + 1.0f) * scaleFactor, this.rotation + this.startAngle, this.rotation + this.endAngle);
                }
                Lines.stroke(this.stroke * scaleFactor, this.color);
                Lines.poly(this.pos.x, this.pos.y, sides, (this.radius + 1.0f) * scaleFactor, this.rotation + this.startAngle, this.rotation + this.endAngle);
            } else {
                Draw.color(this.color);
                if (this.startAngle < this.endAngle) {
                    Fill.arc(this.pos.x, this.pos.y, this.radius * scaleFactor, (this.endAngle - this.startAngle) / 360.0f, this.rotation + this.startAngle, sides);
                } else {
                    Fill.arc(this.pos.x, this.pos.y, this.radius * scaleFactor, (this.startAngle - this.endAngle) / 360.0f, this.rotation + this.endAngle, sides);
                }
            }
            Draw.reset();
        }

        @Override
        public void control(LMarkerControl type, double p1, double p2, double p3) {
            super.control(type, p1, p2, p3);
            if (!Double.isNaN(p1)) {
                switch (type) {
                    case radius: {
                        this.radius = (float)p1;
                        break;
                    }
                    case stroke: {
                        this.stroke = (float)p1;
                        break;
                    }
                    case outline: {
                        this.outline = !Mathf.equal((float)p1, 0.0f);
                        break;
                    }
                    case rotation: {
                        this.rotation = (float)p1;
                        break;
                    }
                    case color: {
                        this.color.fromDouble(p1);
                        break;
                    }
                    case shape: {
                        this.sides = (int)p1;
                        break;
                    }
                    case arc: {
                        this.startAngle = (float)p1;
                    }
                }
            }
            if (!Double.isNaN(p2)) {
                switch (type) {
                    case shape: {
                        this.fill = !Mathf.equal((float)p2, 0.0f);
                        break;
                    }
                    case arc: {
                        this.endAngle = (float)p2;
                    }
                }
            }
            if (!Double.isNaN(p3) && type == LMarkerControl.shape) {
                this.outline = !Mathf.equal((float)p3, 0.0f);
            }
        }
    }

    public static class PointMarker
    extends PosMarker {
        public float radius = 5.0f;
        public float stroke = 11.0f;
        public Color color = Color.valueOf("f25555");

        public PointMarker(int x, int y) {
            this.pos.set(x, y);
        }

        public PointMarker(int x, int y, Color color) {
            this.pos.set(x, y);
            this.color = color;
        }

        public PointMarker(int x, int y, float radius, float stroke, Color color) {
            this.pos.set(x, y);
            this.stroke = stroke;
            this.radius = radius;
            this.color = color;
        }

        public PointMarker() {
        }

        @Override
        public void draw(float scaleFactor) {
            float rad = this.radius * 8.0f * scaleFactor;
            float fin = Interp.pow2Out.apply(Time.globalTime / 100.0f % 1.0f);
            Draw.z(this.drawLayer);
            Lines.stroke(Scl.scl((1.0f - fin) * this.stroke + 0.1f), this.color);
            Lines.circle(this.pos.x, this.pos.y, rad * fin);
            Draw.reset();
        }

        @Override
        public void control(LMarkerControl type, double p1, double p2, double p3) {
            super.control(type, p1, p2, p3);
            if (!Double.isNaN(p1)) {
                switch (type) {
                    case radius: {
                        this.radius = (float)p1;
                        break;
                    }
                    case stroke: {
                        this.stroke = (float)p1;
                        break;
                    }
                    case color: {
                        this.color.fromDouble(p1);
                    }
                }
            }
        }
    }

    public static class ShapeTextMarker
    extends PosMarker {
        @Multiline
        public String text = "frog";
        public float fontSize = 1.0f;
        public float textHeight = 7.0f;
        @LabelFlag
        public byte flags = (byte)3;
        @Alignment
        public int textAlign = 1;
        @Alignment(ver=false)
        public int lineAlign = 1;
        public float radius = 6.0f;
        public float rotation = 0.0f;
        public int sides = 4;
        public Color color = Color.valueOf("ffd37f");
        private transient String fetchedText;

        public ShapeTextMarker(String text, float x, float y) {
            this.text = text;
            this.pos.set(x, y);
        }

        public ShapeTextMarker(String text, float x, float y, float radius) {
            this.text = text;
            this.pos.set(x, y);
            this.radius = radius;
        }

        public ShapeTextMarker(String text, float x, float y, float radius, float rotation) {
            this.text = text;
            this.pos.set(x, y);
            this.radius = radius;
            this.rotation = rotation;
        }

        public ShapeTextMarker(String text, float x, float y, float radius, float rotation, float textHeight) {
            this.text = text;
            this.pos.set(x, y);
            this.radius = radius;
            this.rotation = rotation;
            this.textHeight = textHeight;
        }

        public ShapeTextMarker(String text, float x, float y, float radius, float rotation, float textHeight, int textAlign) {
            this.text = text;
            this.pos.set(x, y);
            this.radius = radius;
            this.rotation = rotation;
            this.textHeight = textHeight;
            this.textAlign = textAlign;
        }

        public ShapeTextMarker() {
        }

        @Override
        public void draw(float scaleFactor) {
            int sides = Math.min(this.sides, 300);
            Draw.z(this.drawLayer);
            Lines.stroke(3.0f * scaleFactor, Pal.gray);
            Lines.poly(this.pos.x, this.pos.y, sides, (this.radius + 1.0f) * scaleFactor, this.rotation);
            Lines.stroke(scaleFactor, this.color);
            Lines.poly(this.pos.x, this.pos.y, sides, (this.radius + 1.0f) * scaleFactor, this.rotation);
            Draw.reset();
            if (this.fetchedText == null) {
                this.fetchedText = ShapeTextMarker.fetchText(this.text);
            }
            if (Mathf.equal(this.fontSize, 0.0f)) {
                return;
            }
            WorldLabel.drawAt(this.fetchedText, this.pos.x, this.pos.y + this.radius * scaleFactor + this.textHeight * scaleFactor, this.drawLayer, this.flags, this.fontSize * scaleFactor, this.textAlign, this.lineAlign);
        }

        @Override
        public void control(LMarkerControl type, double p1, double p2, double p3) {
            super.control(type, p1, p2, p3);
            if (!Double.isNaN(p1)) {
                switch (type) {
                    case fontSize: {
                        this.fontSize = (float)p1;
                        break;
                    }
                    case textHeight: {
                        this.textHeight = (float)p1;
                        break;
                    }
                    case textAlign: {
                        this.textAlign = (int)p1;
                        break;
                    }
                    case lineAlign: {
                        this.lineAlign = (int)p1;
                        break;
                    }
                    case outline: {
                        this.flags = (byte)Pack.bitmask(this.flags, 2, !Mathf.equal((float)p1, 0.0f));
                        break;
                    }
                    case labelFlags: {
                        this.flags = (byte)Pack.bitmask(this.flags, 1, !Mathf.equal((float)p1, 0.0f));
                        break;
                    }
                    case radius: {
                        this.radius = (float)p1;
                        break;
                    }
                    case rotation: {
                        this.rotation = (float)p1;
                        break;
                    }
                    case color: {
                        this.color.fromDouble(p1);
                        break;
                    }
                    case shape: {
                        this.sides = (int)p1;
                    }
                }
            }
            if (!Double.isNaN(p2)) {
                switch (type) {
                    case labelFlags: {
                        this.flags = (byte)Pack.bitmask(this.flags, 2, !Mathf.equal((float)p2, 0.0f));
                    }
                }
            }
        }

        @Override
        public void setText(String text, boolean fetch) {
            this.text = text;
            this.fetchedText = fetch ? ShapeTextMarker.fetchText(this.text) : this.text;
        }
    }

    public static abstract class PosMarker
    extends ObjectiveMarker {
        @TilePos
        public Vec2 pos = new Vec2();

        @Override
        public void control(LMarkerControl type, double p1, double p2, double p3) {
            super.control(type, p1, p2, p3);
            if (!Double.isNaN(p1) && type == LMarkerControl.pos) {
                this.pos.x = (float)p1 * 8.0f;
            }
            if (!Double.isNaN(p2) && type == LMarkerControl.pos) {
                this.pos.y = (float)p2 * 8.0f;
            }
        }
    }

    public static class DestroyCoreObjective
    extends MapObjective {
        @Override
        public boolean update() {
            return Vars.state.rules.waveTeam.cores().size == 0;
        }

        @Override
        public String text() {
            return Core.bundle.get("objective.destroycore");
        }
    }

    public static class FlagObjective
    extends MapObjective {
        public String flag = "flag";
        @Multiline
        public String text;

        public FlagObjective(String flag, String text) {
            this.flag = flag;
            this.text = text;
        }

        public FlagObjective() {
        }

        @Override
        public boolean update() {
            return Vars.state.rules.objectiveFlags.contains(this.flag);
        }

        @Override
        @Nullable
        public String text() {
            if (this.text == null) {
                return null;
            }
            if (this.text.startsWith("@")) {
                if (Vars.state.mapLocales.containsProperty(this.text.substring(1))) {
                    return Vars.state.mapLocales.getProperty(this.text.substring(1));
                }
                return Core.bundle.get(this.text.substring(1));
            }
            return this.text;
        }
    }

    public static class CommandModeObjective
    extends MapObjective {
        @Override
        public boolean update() {
            return Vars.headless || Vars.control.input.selectedUnits.contains((Unit)((Object)((Boolf<Unit>)u -> u.isCommandable() && u.command().hasCommand())));
        }

        @Override
        public String text() {
            return Core.bundle.get("objective.command");
        }
    }

    public static class DestroyBlocksObjective
    extends MapObjective {
        @Unordered
        public Point2[] positions = new Point2[0];
        public Team team = Team.crux;
        @Synthetic
        public Block block = Blocks.router;

        public DestroyBlocksObjective(Block block, Team team, Point2 ... positions) {
            this.block = block;
            this.team = team;
            this.positions = positions;
        }

        public DestroyBlocksObjective() {
        }

        public int progress() {
            int count = 0;
            for (Point2 pos : this.positions) {
                Building build = Vars.world.build(pos.x, pos.y);
                if (build != null && build.team == this.team && build.block == this.block) continue;
                ++count;
            }
            return count;
        }

        @Override
        public boolean update() {
            return this.progress() >= this.positions.length;
        }

        @Override
        public String text() {
            return Core.bundle.format("objective.destroyblocks", this.progress(), this.positions.length, this.block.emoji(), this.block.localizedName);
        }

        @Override
        public void validate() {
            if (this.block == null) {
                this.block = Blocks.router;
            }
        }
    }

    public static class DestroyBlockObjective
    extends MapObjective {
        public Point2 pos = new Point2();
        public Team team = Team.crux;
        @Synthetic
        public Block block = Blocks.router;

        public DestroyBlockObjective(Block block, int x, int y, Team team) {
            this.block = block;
            this.team = team;
            this.pos.set(x, y);
        }

        public DestroyBlockObjective() {
        }

        @Override
        public boolean update() {
            Building build = Vars.world.build(this.pos.x, this.pos.y);
            return build == null || build.team != this.team || build.block != this.block;
        }

        @Override
        public String text() {
            return Core.bundle.format("objective.destroyblock", this.block.emoji(), this.block.localizedName);
        }

        @Override
        public void validate() {
            if (this.block == null) {
                this.block = Blocks.router;
            }
        }
    }

    public static class TimerObjective
    extends MapObjective {
        @Multiline
        public String text;
        @Second
        public float duration = 1800.0f;
        protected float countup;

        public TimerObjective(String text, float duration) {
            this.text = text;
            this.duration = duration;
        }

        public TimerObjective() {
        }

        @Override
        public boolean update() {
            float f;
            this.countup += Time.delta;
            return f >= this.duration * Vars.state.rules.objectiveTimerMultiplier;
        }

        @Override
        public void reset() {
            this.countup = 0.0f;
        }

        @Override
        @Nullable
        public String text() {
            if (this.text != null) {
                int i = (int)((this.duration * Vars.state.rules.objectiveTimerMultiplier - this.countup) / 60.0f);
                StringBuilder timeString = new StringBuilder();
                int m = i / 60;
                int s = i % 60;
                if (m > 0) {
                    timeString.append(m);
                    timeString.append(":");
                    if (s < 10) {
                        timeString.append("0");
                    }
                }
                timeString.append(s);
                if (this.text.startsWith("@")) {
                    if (Vars.state.mapLocales.containsProperty(this.text.substring(1))) {
                        try {
                            return Vars.state.mapLocales.getFormatted(this.text.substring(1), timeString.toString());
                        }
                        catch (IllegalArgumentException e) {
                            this.text = "";
                        }
                    }
                    return Core.bundle.format(this.text.substring(1), timeString.toString());
                }
                try {
                    return Core.bundle.formatString(this.text, timeString.toString());
                }
                catch (IllegalArgumentException e) {
                    this.text = "";
                }
            }
            return null;
        }
    }

    public static class DestroyUnitsObjective
    extends MapObjective {
        public int count = 1;

        public DestroyUnitsObjective(int count) {
            this.count = count;
        }

        public DestroyUnitsObjective() {
        }

        @Override
        public boolean update() {
            return Vars.state.stats.enemyUnitsDestroyed >= this.count;
        }

        @Override
        public String text() {
            return Core.bundle.format("objective.destroyunits", this.count - Vars.state.stats.enemyUnitsDestroyed);
        }
    }

    public static class UnitCountObjective
    extends MapObjective {
        public UnitType unit = UnitTypes.dagger;
        public int count = 1;

        public UnitCountObjective(UnitType unit, int count) {
            this.unit = unit;
            this.count = count;
        }

        public UnitCountObjective() {
        }

        @Override
        public boolean update() {
            return Vars.state.rules.defaultTeam.data().countType(this.unit) >= this.count;
        }

        @Override
        public String text() {
            return Core.bundle.format("objective.buildunit", this.count - Vars.state.rules.defaultTeam.data().countType(this.unit), this.unit.emoji(), this.unit.localizedName);
        }

        @Override
        public void validate() {
            if (this.unit == null) {
                this.unit = UnitTypes.dagger;
            }
        }
    }

    public static class BuildCountObjective
    extends MapObjective {
        @Synthetic
        public Block block = Blocks.conveyor;
        public int count = 1;

        public BuildCountObjective(Block block, int count) {
            this.block = block;
            this.count = count;
        }

        public BuildCountObjective() {
        }

        @Override
        public boolean update() {
            return Vars.state.stats.placedBlockCount.get(this.block, 0) >= this.count;
        }

        @Override
        public String text() {
            return Core.bundle.format("objective.build", this.count - Vars.state.stats.placedBlockCount.get(this.block, 0), this.block.emoji(), this.block.localizedName);
        }

        @Override
        public void validate() {
            if (this.block == null) {
                this.block = Blocks.conveyor;
            }
        }
    }

    public static class CoreItemObjective
    extends MapObjective {
        public Item item = Items.copper;
        public int amount = 2;

        public CoreItemObjective(Item item, int amount) {
            this.item = item;
            this.amount = amount;
        }

        public CoreItemObjective() {
        }

        @Override
        public boolean update() {
            return Vars.state.stats.coreItemCount.get(this.item) >= this.amount;
        }

        @Override
        public String text() {
            return Core.bundle.format("objective.coreitem", Vars.state.stats.coreItemCount.get(this.item), this.amount, this.item.emoji(), this.item.localizedName);
        }

        @Override
        public void validate() {
            if (this.item == null) {
                this.item = Items.copper;
            }
        }
    }

    public static class ItemObjective
    extends MapObjective {
        public Item item = Items.copper;
        public int amount = 1;

        public ItemObjective(Item item, int amount) {
            this.item = item;
            this.amount = amount;
        }

        public ItemObjective() {
        }

        @Override
        public boolean update() {
            return Vars.state.rules.defaultTeam.items().has(this.item, this.amount);
        }

        @Override
        public String text() {
            return Core.bundle.format("objective.item", Vars.state.rules.defaultTeam.items().get(this.item), this.amount, this.item.emoji(), this.item.localizedName);
        }

        @Override
        public void validate() {
            if (this.item == null) {
                this.item = Items.copper;
            }
        }
    }

    public static class ProduceObjective
    extends MapObjective {
        @Researchable
        public UnlockableContent content = Items.copper;

        public ProduceObjective(UnlockableContent content) {
            this.content = content;
        }

        public ProduceObjective() {
        }

        @Override
        public boolean update() {
            return this.content.unlocked();
        }

        @Override
        public String text() {
            return Core.bundle.format("objective.produce", this.content.emoji(), this.content.localizedName);
        }

        @Override
        public void validate() {
            if (this.content == null) {
                this.content = Items.copper;
            }
        }
    }

    public static class ResearchObjective
    extends MapObjective {
        @Researchable
        public UnlockableContent content = Items.copper;

        public ResearchObjective(UnlockableContent content) {
            this.content = content;
        }

        public ResearchObjective() {
        }

        @Override
        public boolean update() {
            return this.content.unlocked();
        }

        @Override
        public String text() {
            return Core.bundle.format("objective.research", this.content.emoji(), this.content.localizedName);
        }

        @Override
        public void validate() {
            if (this.content == null) {
                this.content = Items.copper;
            }
        }
    }
}

