/*
 * Decompiled with CFR 0.152.
 */
package mindustry.game;

import arc.struct.IntMap;
import arc.struct.Seq;
import arc.util.Nullable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import mindustry.game.MapObjectives;
import mindustry.io.JsonIO;

public class MapMarkers
implements Iterable<MapObjectives.ObjectiveMarker> {
    private IntMap<MapObjectives.ObjectiveMarker> map = new IntMap();
    private Seq<MapObjectives.ObjectiveMarker> all = new Seq(false);

    public void add(int id, MapObjectives.ObjectiveMarker marker) {
        if (marker == null) {
            return;
        }
        MapObjectives.ObjectiveMarker prev = this.map.put(id, marker);
        if (prev != null) {
            this.all.set(prev.arrayIndex, marker);
            marker.arrayIndex = prev.arrayIndex;
        } else {
            this.all.add(marker);
            marker.arrayIndex = this.all.size - 1;
        }
    }

    public void remove(int id) {
        MapObjectives.ObjectiveMarker prev = this.map.remove(id);
        if (prev != null) {
            if (this.all.size > prev.arrayIndex + 1) {
                this.all.remove(prev.arrayIndex);
                this.all.get((int)prev.arrayIndex).arrayIndex = prev.arrayIndex;
            } else {
                this.all.remove(prev.arrayIndex);
            }
        }
    }

    @Nullable
    public MapObjectives.ObjectiveMarker get(int id) {
        return this.map.get(id);
    }

    public boolean has(int id) {
        return this.get(id) != null;
    }

    public int size() {
        return this.all.size;
    }

    public void write(DataOutput stream) throws IOException {
        JsonIO.writeBytes(this.map, MapObjectives.ObjectiveMarker.class, (DataOutputStream)stream);
    }

    public void read(DataInput stream) throws IOException {
        this.all.clear();
        this.map = JsonIO.readBytes(IntMap.class, MapObjectives.ObjectiveMarker.class, (DataInputStream)stream);
        for (IntMap.Entry<MapObjectives.ObjectiveMarker> entry : this.map.entries()) {
            this.all.add((MapObjectives.ObjectiveMarker)entry.value);
            ((MapObjectives.ObjectiveMarker)entry.value).arrayIndex = this.all.size - 1;
        }
    }

    @Override
    public Iterator<MapObjectives.ObjectiveMarker> iterator() {
        return this.all.iterator();
    }
}

