/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.bullet;

import arc.math.geom.Geometry;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Unit;

public class PointBulletType
extends BulletType {
    private static float cdist = 0.0f;
    private static Unit result;
    public float trailSpacing = 10.0f;

    public PointBulletType() {
        this.scaleLife = true;
        this.lifetime = 100.0f;
        this.collides = false;
        this.reflectable = false;
        this.keepVelocity = false;
    }

    @Override
    public void init(Bullet b) {
        Building build;
        super.init(b);
        float px = b.x + b.lifetime * b.vel.x;
        float py = b.y + b.lifetime * b.vel.y;
        float rot = b.rotation();
        Geometry.iterateLine(0.0f, b.x, b.y, px, py, this.trailSpacing, (x, y) -> this.trailEffect.at(x, y, rot));
        b.time = b.lifetime;
        b.set(px, py);
        cdist = 0.0f;
        result = null;
        float range = 1.0f;
        Units.nearbyEnemies(b.team, px - range, py - range, range * 2.0f, range * 2.0f, e -> {
            if (e.dead() || !e.checkTarget(this.collidesAir, this.collidesGround) || !e.hittable()) {
                return;
            }
            e.hitbox(Tmp.r1);
            if (!Tmp.r1.contains(px, py)) {
                return;
            }
            float dst = e.dst(px, py) - e.hitSize;
            if (result == null || dst < cdist) {
                result = e;
                cdist = dst;
            }
        });
        if (result != null) {
            b.collision(result, px, py);
        } else if (this.collidesTiles && (build = Vars.world.buildWorld(px, py)) != null && build.team != b.team) {
            build.collision(b);
            this.hit(b, px, py);
            b.hit = true;
        }
        b.remove();
        b.vel.setZero();
    }
}

