/*
 * Decompiled with CFR 0.152.
 */
package mindustry.content;

import arc.struct.IntSet;
import arc.struct.ObjectFloatMap;
import arc.struct.Seq;
import arc.util.Structs;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Items;
import mindustry.content.Liquids;
import mindustry.content.Planets;
import mindustry.content.SectorPresets;
import mindustry.content.TechTree;
import mindustry.content.UnitTypes;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Objectives;
import mindustry.type.Item;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import mindustry.type.unit.ErekirUnitType;
import mindustry.world.Block;
import mindustry.world.blocks.defense.turrets.ContinuousLiquidTurret;
import mindustry.world.blocks.defense.turrets.ContinuousTurret;
import mindustry.world.blocks.defense.turrets.ItemTurret;
import mindustry.world.blocks.defense.turrets.Turret;

public class ErekirTechTree {
    static IntSet balanced = new IntSet();

    static void rebalanceBullet(BulletType bullet) {
        if (balanced.add(bullet.id)) {
            bullet.damage *= 0.75f;
        }
    }

    public static void rebalance() {
        for (UnitType unit : Vars.content.units().select(u -> u instanceof ErekirUnitType)) {
            for (Weapon weapon : unit.weapons) {
                ErekirTechTree.rebalanceBullet(weapon.bullet);
            }
        }
        for (Block block : Vars.content.blocks()) {
            if (!(block instanceof Turret)) continue;
            Turret turret = (Turret)block;
            if (!Structs.contains(block.requirements, i -> !Items.serpuloItems.contains(i.item))) continue;
            if (turret instanceof ItemTurret) {
                ItemTurret item = (ItemTurret)turret;
                for (BulletType bullet : item.ammoTypes.values()) {
                    ErekirTechTree.rebalanceBullet(bullet);
                }
                continue;
            }
            if (turret instanceof ContinuousLiquidTurret) {
                ContinuousLiquidTurret cont = (ContinuousLiquidTurret)turret;
                for (BulletType bullet : cont.ammoTypes.values()) {
                    ErekirTechTree.rebalanceBullet(bullet);
                }
                continue;
            }
            if (!(turret instanceof ContinuousTurret)) continue;
            ContinuousTurret cont = (ContinuousTurret)turret;
            ErekirTechTree.rebalanceBullet(cont.shootType);
        }
    }

    public static void load() {
        ErekirTechTree.rebalance();
        Seq<Objectives.Objective> erekirSector = Seq.with(new Objectives.OnPlanet(Planets.erekir));
        ObjectFloatMap<Item> costMultipliers = new ObjectFloatMap<Item>();
        for (Item item : Vars.content.items()) {
            costMultipliers.put(item, 0.9f);
        }
        costMultipliers.put(Items.oxide, 0.5f);
        costMultipliers.put(Items.surgeAlloy, 0.7f);
        costMultipliers.put(Items.carbide, 0.3f);
        costMultipliers.put(Items.phaseFabric, 0.2f);
        Planets.erekir.techTree = TechTree.nodeRoot("erekir", Blocks.coreBastion, true, () -> {
            TechTree.context().researchCostMultipliers = costMultipliers;
            TechTree.node((UnlockableContent)Blocks.duct, erekirSector, () -> {
                TechTree.node(Blocks.ductRouter, () -> {
                    TechTree.node(Blocks.ductBridge, () -> {
                        TechTree.node(Blocks.armoredDuct, () -> TechTree.node(Blocks.surgeConveyor, () -> TechTree.node(Blocks.surgeRouter)));
                        TechTree.node(Blocks.unitCargoLoader, () -> TechTree.node(Blocks.unitCargoUnloadPoint, () -> {}));
                    });
                    TechTree.node((UnlockableContent)Blocks.overflowDuct, Seq.with(new Objectives.OnSector(SectorPresets.aegis)), () -> {
                        TechTree.node(Blocks.underflowDuct);
                        TechTree.node(Blocks.reinforcedContainer, () -> {
                            TechTree.node(Blocks.ductUnloader, () -> {});
                            TechTree.node(Blocks.reinforcedVault, () -> {});
                        });
                    });
                    TechTree.node((UnlockableContent)Blocks.reinforcedMessage, Seq.with(new Objectives.OnSector(SectorPresets.aegis)), () -> TechTree.node(Blocks.canvas));
                });
                TechTree.node((UnlockableContent)Blocks.reinforcedPayloadConveyor, Seq.with(new Objectives.OnSector(SectorPresets.atlas)), () -> {
                    TechTree.node((UnlockableContent)Blocks.payloadMassDriver, Seq.with(new Objectives.Research(Blocks.siliconArcFurnace), new Objectives.OnSector(SectorPresets.split)), () -> {
                        TechTree.node(Blocks.payloadLoader, () -> TechTree.node(Blocks.payloadUnloader, () -> TechTree.node(Blocks.largePayloadMassDriver, () -> {})));
                        TechTree.node((UnlockableContent)Blocks.constructor, Seq.with(new Objectives.OnSector(SectorPresets.split)), () -> TechTree.node((UnlockableContent)Blocks.smallDeconstructor, Seq.with(new Objectives.OnSector(SectorPresets.peaks)), () -> {
                            TechTree.node((UnlockableContent)Blocks.largeConstructor, Seq.with(new Objectives.OnSector(SectorPresets.siege)), () -> {});
                            TechTree.node((UnlockableContent)Blocks.deconstructor, Seq.with(new Objectives.OnSector(SectorPresets.siege)), () -> {});
                        }));
                    });
                    TechTree.node(Blocks.reinforcedPayloadRouter, () -> {});
                });
            });
            TechTree.node(Blocks.plasmaBore, () -> TechTree.node((UnlockableContent)Blocks.impactDrill, Seq.with(new Objectives.OnSector(SectorPresets.aegis)), () -> TechTree.node((UnlockableContent)Blocks.largePlasmaBore, Seq.with(new Objectives.OnSector(SectorPresets.caldera)), () -> {
                TechTree.node((UnlockableContent)Blocks.eruptionDrill, Seq.with(new Objectives.OnSector(SectorPresets.stronghold)), () -> {});
                TechTree.node((UnlockableContent)Blocks.largeCliffCrusher, Seq.with(new Objectives.OnSector(SectorPresets.stronghold)), () -> {});
            })));
            TechTree.node(Blocks.turbineCondenser, () -> {
                TechTree.node(Blocks.beamNode, () -> {
                    TechTree.node((UnlockableContent)Blocks.ventCondenser, Seq.with(new Objectives.OnSector(SectorPresets.aegis)), () -> TechTree.node((UnlockableContent)Blocks.chemicalCombustionChamber, Seq.with(new Objectives.OnSector(SectorPresets.basin)), () -> TechTree.node((UnlockableContent)Blocks.pyrolysisGenerator, Seq.with(new Objectives.OnSector(SectorPresets.crevice)), () -> TechTree.node((UnlockableContent)Blocks.fluxReactor, Seq.with(new Objectives.OnSector(SectorPresets.crossroads), new Objectives.Research(Blocks.cyanogenSynthesizer)), () -> TechTree.node((UnlockableContent)Blocks.neoplasiaReactor, Seq.with(new Objectives.OnSector(SectorPresets.karst)), () -> {})))));
                    TechTree.node((UnlockableContent)Blocks.beamTower, Seq.with(new Objectives.OnSector(SectorPresets.peaks)), () -> TechTree.node((UnlockableContent)Blocks.beamLink, Seq.with(new Objectives.OnSector(SectorPresets.crossroads)), () -> {}));
                    TechTree.node((UnlockableContent)Blocks.regenProjector, Seq.with(new Objectives.OnSector(SectorPresets.peaks)), () -> TechTree.node((UnlockableContent)Blocks.buildTower, Seq.with(new Objectives.OnSector(SectorPresets.stronghold)), () -> TechTree.node((UnlockableContent)Blocks.shockwaveTower, Seq.with(new Objectives.OnSector(SectorPresets.siege)), () -> {})));
                });
                TechTree.node((UnlockableContent)Blocks.reinforcedConduit, Seq.with(new Objectives.OnSector(SectorPresets.aegis)), () -> {
                    TechTree.node((UnlockableContent)Blocks.reinforcedPump, Seq.with(new Objectives.OnSector(SectorPresets.basin)), () -> {});
                    TechTree.node(Blocks.reinforcedLiquidJunction, () -> {
                        TechTree.node(Blocks.reinforcedBridgeConduit, () -> {});
                        TechTree.node(Blocks.reinforcedLiquidRouter, () -> TechTree.node(Blocks.reinforcedLiquidContainer, () -> TechTree.node((UnlockableContent)Blocks.reinforcedLiquidTank, Seq.with(new Objectives.SectorComplete(SectorPresets.intersect)), () -> {})));
                    });
                });
                TechTree.node(Blocks.cliffCrusher, () -> TechTree.node(Blocks.siliconArcFurnace, () -> TechTree.node((UnlockableContent)Blocks.electrolyzer, Seq.with(new Objectives.OnSector(SectorPresets.atlas)), () -> {
                    TechTree.node((UnlockableContent)Blocks.oxidationChamber, Seq.with(new Objectives.Research(Blocks.tankRefabricator), new Objectives.OnSector(SectorPresets.marsh)), () -> {
                        TechTree.node((UnlockableContent)Blocks.surgeCrucible, Seq.with(new Objectives.OnSector(SectorPresets.ravine)), () -> {});
                        TechTree.node((UnlockableContent)Blocks.heatRedirector, Seq.with(new Objectives.OnSector(SectorPresets.ravine)), () -> TechTree.node((UnlockableContent)Blocks.electricHeater, Seq.with(new Objectives.OnSector(SectorPresets.ravine), new Objectives.Research(Blocks.afflict)), () -> {
                            TechTree.node((UnlockableContent)Blocks.slagHeater, Seq.with(new Objectives.OnSector(SectorPresets.caldera)), () -> {});
                            TechTree.node((UnlockableContent)Blocks.atmosphericConcentrator, Seq.with(new Objectives.OnSector(SectorPresets.caldera)), () -> TechTree.node((UnlockableContent)Blocks.cyanogenSynthesizer, Seq.with(new Objectives.OnSector(SectorPresets.siege)), () -> {}));
                            TechTree.node((UnlockableContent)Blocks.carbideCrucible, Seq.with(new Objectives.OnSector(SectorPresets.crevice)), () -> TechTree.node((UnlockableContent)Blocks.phaseSynthesizer, Seq.with(new Objectives.OnSector(SectorPresets.karst)), () -> TechTree.node((UnlockableContent)Blocks.phaseHeater, Seq.with(new Objectives.Research(Blocks.phaseSynthesizer)), () -> {})));
                            TechTree.node(Blocks.heatRouter, () -> TechTree.node(Blocks.smallHeatRedirector, () -> {}));
                        }));
                    });
                    TechTree.node((UnlockableContent)Blocks.slagIncinerator, Seq.with(new Objectives.OnSector(SectorPresets.basin)), () -> {});
                })));
            });
            TechTree.node((UnlockableContent)Blocks.breach, Seq.with(new Objectives.Research(Blocks.siliconArcFurnace), new Objectives.Research(Blocks.tankFabricator)), () -> {
                TechTree.node(Blocks.berylliumWall, () -> {
                    TechTree.node(Blocks.berylliumWallLarge, () -> {});
                    TechTree.node(Blocks.tungstenWall, () -> {
                        TechTree.node(Blocks.tungstenWallLarge, () -> TechTree.node(Blocks.blastDoor, () -> {}));
                        TechTree.node(Blocks.reinforcedSurgeWall, () -> TechTree.node(Blocks.reinforcedSurgeWallLarge, () -> TechTree.node(Blocks.shieldedWall, () -> {})));
                        TechTree.node(Blocks.carbideWall, () -> TechTree.node(Blocks.carbideWallLarge, () -> {}));
                    });
                });
                TechTree.node((UnlockableContent)Blocks.diffuse, Seq.with(new Objectives.OnSector(SectorPresets.lake)), () -> {
                    TechTree.node((UnlockableContent)Blocks.sublimate, Seq.with(new Objectives.OnSector(SectorPresets.marsh)), () -> TechTree.node((UnlockableContent)Blocks.afflict, Seq.with(new Objectives.OnSector(SectorPresets.ravine)), () -> TechTree.node((UnlockableContent)Blocks.titan, Seq.with(new Objectives.OnSector(SectorPresets.stronghold)), () -> TechTree.node((UnlockableContent)Blocks.lustre, Seq.with(new Objectives.OnSector(SectorPresets.crevice)), () -> TechTree.node((UnlockableContent)Blocks.smite, Seq.with(new Objectives.OnSector(SectorPresets.karst)), () -> {})))));
                    TechTree.node((UnlockableContent)Blocks.disperse, Seq.with(new Objectives.OnSector(SectorPresets.stronghold)), () -> TechTree.node((UnlockableContent)Blocks.scathe, Seq.with(new Objectives.OnSector(SectorPresets.siege)), () -> TechTree.node((UnlockableContent)Blocks.malign, Seq.with(new Objectives.SectorComplete(SectorPresets.karst)), () -> {})));
                });
                TechTree.node((UnlockableContent)Blocks.radar, Seq.with(new Objectives.Research(Blocks.beamNode), new Objectives.Research(Blocks.turbineCondenser), new Objectives.Research(Blocks.tankFabricator), new Objectives.OnSector(SectorPresets.aegis)), () -> {});
            });
            TechTree.node((UnlockableContent)Blocks.coreCitadel, Seq.with(new Objectives.SectorComplete(SectorPresets.peaks)), () -> TechTree.node((UnlockableContent)Blocks.coreAcropolis, Seq.with(new Objectives.SectorComplete(SectorPresets.siege)), () -> {}));
            TechTree.node((UnlockableContent)Blocks.tankFabricator, Seq.with(new Objectives.Research(Blocks.siliconArcFurnace), new Objectives.Research(Blocks.plasmaBore), new Objectives.Research(Blocks.turbineCondenser)), () -> {
                TechTree.node(UnitTypes.stell);
                TechTree.node((UnlockableContent)Blocks.unitRepairTower, Seq.with(new Objectives.OnSector(SectorPresets.ravine), new Objectives.Research(Blocks.mechRefabricator)), () -> {});
                TechTree.node((UnlockableContent)Blocks.shipFabricator, Seq.with(new Objectives.OnSector(SectorPresets.lake)), () -> {
                    TechTree.node(UnitTypes.elude);
                    TechTree.node((UnlockableContent)Blocks.mechFabricator, Seq.with(new Objectives.OnSector(SectorPresets.intersect)), () -> {
                        TechTree.node(UnitTypes.merui);
                        TechTree.node((UnlockableContent)Blocks.tankRefabricator, Seq.with(new Objectives.OnSector(SectorPresets.atlas)), () -> {
                            TechTree.node(UnitTypes.locus);
                            TechTree.node((UnlockableContent)Blocks.mechRefabricator, Seq.with(new Objectives.OnSector(SectorPresets.basin)), () -> {
                                TechTree.node(UnitTypes.cleroi);
                                TechTree.node((UnlockableContent)Blocks.shipRefabricator, Seq.with(new Objectives.OnSector(SectorPresets.peaks)), () -> {
                                    TechTree.node(UnitTypes.avert);
                                    TechTree.node((UnlockableContent)Blocks.primeRefabricator, Seq.with(new Objectives.OnSector(SectorPresets.stronghold)), () -> {
                                        TechTree.node(UnitTypes.precept);
                                        TechTree.node(UnitTypes.anthicus);
                                        TechTree.node(UnitTypes.obviate);
                                    });
                                    TechTree.node((UnlockableContent)Blocks.tankAssembler, Seq.with(new Objectives.OnSector(SectorPresets.siege), new Objectives.Research(Blocks.constructor), new Objectives.Research(Blocks.atmosphericConcentrator)), () -> {
                                        TechTree.node(UnitTypes.vanquish, () -> TechTree.node((UnlockableContent)UnitTypes.conquer, Seq.with(new Objectives.OnSector(SectorPresets.karst)), () -> {}));
                                        TechTree.node((UnlockableContent)Blocks.shipAssembler, Seq.with(new Objectives.OnSector(SectorPresets.crossroads)), () -> TechTree.node(UnitTypes.quell, () -> TechTree.node((UnlockableContent)UnitTypes.disrupt, Seq.with(new Objectives.OnSector(SectorPresets.karst)), () -> {})));
                                        TechTree.node((UnlockableContent)Blocks.mechAssembler, Seq.with(new Objectives.OnSector(SectorPresets.crossroads)), () -> TechTree.node(UnitTypes.tecta, () -> TechTree.node((UnlockableContent)UnitTypes.collaris, Seq.with(new Objectives.OnSector(SectorPresets.karst)), () -> {})));
                                        TechTree.node((UnlockableContent)Blocks.basicAssemblerModule, Seq.with(new Objectives.SectorComplete(SectorPresets.karst)), () -> {});
                                    });
                                });
                            });
                        });
                    });
                });
            });
            TechTree.node(SectorPresets.onset, () -> TechTree.node((UnlockableContent)SectorPresets.aegis, Seq.with(new Objectives.SectorComplete(SectorPresets.onset), new Objectives.Research(Blocks.ductRouter), new Objectives.Research(Blocks.ductBridge)), () -> {
                TechTree.node((UnlockableContent)SectorPresets.lake, Seq.with(new Objectives.SectorComplete(SectorPresets.aegis)), () -> {});
                TechTree.node((UnlockableContent)SectorPresets.intersect, Seq.with(new Objectives.SectorComplete(SectorPresets.aegis), new Objectives.SectorComplete(SectorPresets.lake), new Objectives.Research(Blocks.ventCondenser), new Objectives.Research(Blocks.shipFabricator)), () -> TechTree.node((UnlockableContent)SectorPresets.atlas, Seq.with(new Objectives.SectorComplete(SectorPresets.intersect), new Objectives.Research(Blocks.mechFabricator)), () -> {
                    TechTree.node((UnlockableContent)SectorPresets.split, Seq.with(new Objectives.SectorComplete(SectorPresets.atlas), new Objectives.Research(Blocks.reinforcedPayloadConveyor), new Objectives.Research(Blocks.reinforcedContainer)), () -> {});
                    TechTree.node((UnlockableContent)SectorPresets.basin, Seq.with(new Objectives.SectorComplete(SectorPresets.atlas)), () -> TechTree.node((UnlockableContent)SectorPresets.marsh, Seq.with(new Objectives.SectorComplete(SectorPresets.basin)), () -> {
                        TechTree.node((UnlockableContent)SectorPresets.ravine, Seq.with(new Objectives.SectorComplete(SectorPresets.marsh), new Objectives.Research(Liquids.slag)), () -> TechTree.node((UnlockableContent)SectorPresets.caldera, Seq.with(new Objectives.SectorComplete(SectorPresets.peaks), new Objectives.SectorComplete(SectorPresets.ravine), new Objectives.Research(Blocks.heatRedirector)), () -> TechTree.node((UnlockableContent)SectorPresets.stronghold, Seq.with(new Objectives.SectorComplete(SectorPresets.caldera), new Objectives.Research(Blocks.coreCitadel)), () -> TechTree.node((UnlockableContent)SectorPresets.crevice, Seq.with(new Objectives.SectorComplete(SectorPresets.stronghold)), () -> TechTree.node((UnlockableContent)SectorPresets.siege, Seq.with(new Objectives.SectorComplete(SectorPresets.crevice)), () -> TechTree.node((UnlockableContent)SectorPresets.crossroads, Seq.with(new Objectives.SectorComplete(SectorPresets.siege)), () -> TechTree.node((UnlockableContent)SectorPresets.karst, Seq.with(new Objectives.SectorComplete(SectorPresets.crossroads), new Objectives.Research(Blocks.coreAcropolis)), () -> TechTree.node((UnlockableContent)SectorPresets.origin, Seq.with(new Objectives.SectorComplete(SectorPresets.karst), new Objectives.Research(Blocks.coreAcropolis), new Objectives.Research(UnitTypes.vanquish), new Objectives.Research(UnitTypes.disrupt), new Objectives.Research(UnitTypes.collaris), new Objectives.Research(Blocks.malign), new Objectives.Research(Blocks.basicAssemblerModule), new Objectives.Research(Blocks.neoplasiaReactor)), () -> {}))))))));
                        TechTree.node((UnlockableContent)SectorPresets.peaks, Seq.with(new Objectives.SectorComplete(SectorPresets.marsh), new Objectives.SectorComplete(SectorPresets.split)), () -> {});
                    }));
                }));
            }));
            TechTree.nodeProduce(Items.beryllium, () -> {
                TechTree.nodeProduce(Items.sand, () -> TechTree.nodeProduce(Items.silicon, () -> TechTree.nodeProduce(Items.oxide, () -> {})));
                TechTree.nodeProduce(Liquids.water, () -> TechTree.nodeProduce(Liquids.ozone, () -> TechTree.nodeProduce(Liquids.hydrogen, () -> {
                    TechTree.nodeProduce(Liquids.nitrogen, () -> {});
                    TechTree.nodeProduce(Liquids.cyanogen, () -> TechTree.nodeProduce(Liquids.neoplasm, () -> {}));
                })));
                TechTree.nodeProduce(Items.graphite, () -> TechTree.nodeProduce(Items.tungsten, () -> {
                    TechTree.nodeProduce(Liquids.slag, () -> {});
                    TechTree.nodeProduce(Liquids.arkycite, () -> {});
                    TechTree.nodeProduce(Items.thorium, () -> TechTree.nodeProduce(Items.carbide, () -> {}));
                    TechTree.nodeProduce(Items.surgeAlloy, () -> TechTree.nodeProduce(Items.phaseFabric, () -> {}));
                }));
            });
        });
    }
}

