/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai.types;

import arc.math.Mathf;
import arc.math.Rand;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.entities.units.AIController;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Teamc;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.BlockStatus;

public class FlyingAI
extends AIController {
    static final Rand rand = new Rand();
    static final BlockFlag[] randomTargets = new BlockFlag[]{BlockFlag.core, BlockFlag.storage, BlockFlag.generator, BlockFlag.launchPad, BlockFlag.factory, BlockFlag.repair, BlockFlag.battery, BlockFlag.reactor, BlockFlag.drill};

    @Override
    public void updateMovement() {
        this.unloadPayloads();
        if (this.target != null && this.unit.hasWeapons()) {
            if (this.unit.type.circleTarget) {
                this.circleAttack(this.unit.type.circleTargetRadius);
            } else {
                this.moveTo(this.target, this.unit.type.range * 0.8f);
                this.unit.lookAt(this.target);
            }
        }
        if (this.target == null && Vars.state.rules.waves && this.unit.team == Vars.state.rules.defaultTeam) {
            this.moveTo(this.getClosestSpawner(), Vars.state.rules.dropZoneRadius + 130.0f);
        }
    }

    @Override
    public Teamc targetFlag(float x, float y, BlockFlag flag, boolean enemy) {
        if (Vars.state.rules.randomWaveAI) {
            Seq<Building> list;
            if (this.unit.team == Team.derelict) {
                return null;
            }
            Seq<Building> seq = list = enemy ? Vars.indexer.getEnemy(this.unit.team, flag) : Vars.indexer.getFlagged(this.unit.team, flag);
            if (list.isEmpty()) {
                return null;
            }
            Building closest = null;
            float cdist = 0.0f;
            for (Building t : list) {
                if ((t.items == null || !t.items.any()) && t.status() == BlockStatus.noInput || !t.block.targetable) continue;
                float dst = t.dst2(x, y);
                if (closest != null && !(dst < cdist)) continue;
                closest = t;
                cdist = dst;
            }
            return closest;
        }
        return super.targetFlag(x, y, flag, enemy);
    }

    @Override
    public Teamc findTarget(float x, float y, float range, boolean air, boolean ground) {
        Teamc result = this.findMainTarget(x, y, range, air, ground);
        return this.checkTarget(result, x, y, range) ? this.target(x, y, range, air, ground) : result;
    }

    @Override
    public Teamc findMainTarget(float x, float y, float range, boolean air, boolean ground) {
        Teamc core = this.targetFlag(x, y, BlockFlag.core, true);
        if (core != null && Mathf.within(x, y, core.getX(), core.getY(), range)) {
            return core;
        }
        if (Vars.state.rules.randomWaveAI) {
            rand.setSeed(this.unit.type.id + (Vars.state.rules.waves ? Vars.state.wave : this.unit.id));
            for (int attempt = 0; attempt < 5; ++attempt) {
                Teamc result = this.targetFlag(x, y, randomTargets[rand.random(randomTargets.length - 1)], true);
                if (result == null) continue;
                return result;
            }
            Teamc result = this.target(x, y, range, air, ground);
            if (result != null) {
                return result;
            }
        } else {
            for (BlockFlag flag : this.unit.type.targetFlags) {
                Teamc result;
                if (!(flag == null ? (result = this.target(x, y, range, air, ground)) != null : ground && (result = this.targetFlag(x, y, flag, true)) != null)) continue;
                return result;
            }
        }
        return core;
    }
}

