/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.Core;
import arc.graphics.g2d.TextureRegion;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class DrawLiquidRegion
extends DrawBlock {
    public Liquid drawLiquid;
    public TextureRegion liquid;
    public String suffix = "-liquid";
    public float alpha = 1.0f;

    public DrawLiquidRegion(Liquid drawLiquid) {
        this.drawLiquid = drawLiquid;
    }

    public DrawLiquidRegion() {
    }

    @Override
    public void draw(Building build) {
        Liquid drawn = this.drawLiquid != null ? this.drawLiquid : build.liquids.current();
        Drawf.liquid(this.liquid, build.x, build.y, build.liquids.get(drawn) / build.block.liquidCapacity * this.alpha, drawn.color);
    }

    @Override
    public void load(Block block) {
        if (!block.hasLiquids) {
            throw new RuntimeException("Block '" + block + "' has a DrawLiquidRegion, but hasLiquids is false! Make sure it is true.");
        }
        this.liquid = Core.atlas.find(block.name + this.suffix);
    }
}

