/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.distribution;

import arc.Core;
import arc.func.Boolf;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.content.Blocks;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.gen.Teamc;
import mindustry.input.Placement;
import mindustry.logic.LAccess;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.Edges;
import mindustry.world.Tile;
import mindustry.world.blocks.Autotiler;
import mindustry.world.blocks.distribution.Conveyor;
import mindustry.world.blocks.distribution.DirectionBridge;
import mindustry.world.blocks.distribution.DuctBridge;
import mindustry.world.blocks.distribution.DuctJunction;
import mindustry.world.blocks.distribution.ItemBridge;
import mindustry.world.blocks.distribution.StackConveyor;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class Duct
extends Block
implements Autotiler {
    public float speed = 5.0f;
    public boolean armored = false;
    public Color transparentColor = new Color(0.4f, 0.4f, 0.4f, 0.1f);
    public TextureRegion[] topRegions;
    public TextureRegion[] botRegions;
    @Nullable
    public Block bridgeReplacement;
    @Nullable
    public Block junctionReplacement;

    public Duct(String name) {
        super(name);
        this.group = BlockGroup.transportation;
        this.update = true;
        this.solid = false;
        this.hasItems = true;
        this.conveyorPlacement = true;
        this.unloadable = false;
        this.itemCapacity = 1;
        this.noUpdateDisabled = true;
        this.underBullets = true;
        this.rotate = true;
        this.noSideBlend = true;
        this.isDuct = true;
        this.priority = -1.0f;
        this.envEnabled = 7;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.itemsMoved, 60.0f / this.speed, StatUnit.itemsSecond);
    }

    @Override
    public void init() {
        super.init();
        if (this.bridgeReplacement == null || !(this.bridgeReplacement instanceof DuctBridge) && !(this.bridgeReplacement instanceof ItemBridge)) {
            this.bridgeReplacement = Blocks.ductBridge;
        }
    }

    @Override
    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        int[] bits = this.getTiling(plan, list);
        if (bits == null) {
            return;
        }
        Draw.scl(bits[1], bits[2]);
        Draw.alpha(0.5f);
        Draw.rect(this.botRegions[bits[0]], plan.drawx(), plan.drawy(), (float)(plan.rotation * 90));
        Draw.color();
        Draw.rect(this.topRegions[bits[0]], plan.drawx(), plan.drawy(), (float)(plan.rotation * 90));
        Draw.scl();
    }

    @Override
    public boolean blendsArmored(Tile tile, int rotation, int otherx, int othery, int otherrot, Block otherblock) {
        return Point2.equals(tile.x + Geometry.d4((int)rotation).x, tile.y + Geometry.d4((int)rotation).y, otherx, othery) || !otherblock.rotatedOutput(otherx, othery, tile) && Edges.getFacingEdge(otherblock, otherx, othery, tile) != null && Edges.getFacingEdge(otherblock, otherx, othery, tile).relativeTo(tile) == rotation || otherblock.rotatedOutput(otherx, othery, tile) && otherblock.isDuct && Point2.equals(otherx + Geometry.d4((int)otherrot).x, othery + Geometry.d4((int)otherrot).y, tile.x, tile.y);
    }

    @Override
    public boolean blends(Tile tile, int rotation, int otherx, int othery, int otherrot, Block otherblock) {
        if (!this.armored) {
            return (otherblock.outputsItems() || this.lookingAt(tile, rotation, otherx, othery, otherblock) && otherblock.hasItems) && this.lookingAtEither(tile, rotation, otherx, othery, otherrot, otherblock);
        }
        return otherblock.outputsItems() && this.blendsArmored(tile, rotation, otherx, othery, otherrot, otherblock) || this.lookingAt(tile, rotation, otherx, othery, otherblock) && otherblock.hasItems;
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{Core.atlas.find("duct-bottom"), this.topRegions[0]};
    }

    @Override
    public Block getReplacement(BuildPlan req, Seq<BuildPlan> plans) {
        if (this.junctionReplacement == null || !this.junctionReplacement.unlockedNow() || this.junctionReplacement.isHidden()) {
            return this;
        }
        Boolf<Point2> cont = p -> plans.contains(o -> o.x == req.x + p.x && o.y == req.y + p.y && (req.block instanceof Duct || req.block instanceof DuctJunction));
        return cont.get(Geometry.d4(req.rotation)) && cont.get(Geometry.d4(req.rotation - 2)) && req.tile() != null && req.tile().block() instanceof Duct && Mathf.mod(req.tile().build.rotation - req.rotation, 2) == 1 ? this.junctionReplacement : this;
    }

    @Override
    public void handlePlacementLine(Seq<BuildPlan> plans) {
        Block bridge;
        if (this.bridgeReplacement == null) {
            return;
        }
        boolean hasJunction = this.junctionReplacement != null && this.junctionReplacement.unlockedNow() && !this.junctionReplacement.isHidden();
        Block block = this.bridgeReplacement;
        if (block instanceof ItemBridge) {
            bridge = (ItemBridge)block;
            Placement.calculateBridges(plans, bridge, hasJunction, b -> b instanceof Duct || b instanceof StackConveyor || b instanceof Conveyor);
        }
        if ((block = this.bridgeReplacement) instanceof DuctBridge) {
            bridge = (DuctBridge)block;
            Placement.calculateBridges(plans, (DirectionBridge)bridge, hasJunction, b -> b instanceof Duct || b instanceof StackConveyor || b instanceof Conveyor);
        }
    }

    public class DuctBuild
    extends Building {
        public float progress;
        @Nullable
        public Item current;
        public int recDir = 0;
        public int blendbits;
        public int xscl;
        public int yscl;
        public int blending;
        @Nullable
        public Building next;
        @Nullable
        public DuctBuild nextc;

        @Override
        public void draw() {
            float rotation = this.rotdeg();
            int r = this.rotation;
            for (int i = 0; i < 4; ++i) {
                if ((this.blending & 1 << i) == 0) continue;
                int dir = r - i;
                float rot = i == 0 ? rotation : (float)(dir * 90);
                this.drawAt(this.x + (float)(Geometry.d4x(dir) * 8) * 0.75f, this.y + (float)(Geometry.d4y(dir) * 8) * 0.75f, 0, rot, i != 0 ? Autotiler.SliceMode.bottom : Autotiler.SliceMode.top);
            }
            if (this.current != null) {
                Draw.z(29.6f);
                Tmp.v1.set((float)(Geometry.d4x(this.recDir) * 8) / 2.0f, (float)(Geometry.d4y(this.recDir) * 8) / 2.0f).lerp((float)(Geometry.d4x(r) * 8) / 2.0f, (float)(Geometry.d4y(r) * 8) / 2.0f, Mathf.clamp((this.progress + 1.0f) / (2.0f - 1.0f / Duct.this.speed)));
                Draw.rect(this.current.fullIcon, this.x + Tmp.v1.x, this.y + Tmp.v1.y, 5.0f, 5.0f);
            }
            Draw.scl(this.xscl, this.yscl);
            this.drawAt(this.x, this.y, this.blendbits, rotation, Autotiler.SliceMode.none);
            Draw.reset();
        }

        @Override
        public void payloadDraw() {
            Draw.rect(Duct.this.fullIcon, this.x, this.y);
        }

        protected void drawAt(float x, float y, int bits, float rotation, Autotiler.SliceMode slice) {
            Draw.z(29.5f);
            Draw.rect(Duct.this.sliced(Duct.this.botRegions[bits], slice), x, y, rotation);
            Draw.z(29.7f);
            Draw.color(Duct.this.transparentColor);
            Draw.rect(Duct.this.sliced(Duct.this.botRegions[bits], slice), x, y, rotation);
            Draw.color();
            Draw.rect(Duct.this.sliced(Duct.this.topRegions[bits], slice), x, y, rotation);
        }

        @Override
        public void updateTile() {
            this.progress += this.edelta() / Duct.this.speed * 2.0f;
            if (this.current != null && this.next != null) {
                if (this.progress >= 1.0f - 1.0f / Duct.this.speed && this.moveForward(this.current)) {
                    this.items.remove(this.current, 1);
                    this.current = null;
                    this.progress %= 1.0f - 1.0f / Duct.this.speed;
                }
            } else {
                this.progress = 0.0f;
            }
            if (this.current == null && this.items.total() > 0) {
                this.current = this.items.first();
            }
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return this.current == null && this.items.total() == 0 && (Duct.this.armored ? source.block.rotate && source.front() == this && source.block.hasItems && source.block.isDuct || Edges.getFacingEdge(source.tile, this.tile).relativeTo(this.tile) == this.rotation : (!source.block.rotate || this.next != source) && Edges.getFacingEdge(source.tile, this.tile) != null && Math.abs(Edges.getFacingEdge(source.tile, this.tile).relativeTo(this.tile.x, this.tile.y) - this.rotation) != 2);
        }

        @Override
        public int removeStack(Item item, int amount) {
            int removed = super.removeStack(item, amount);
            if (item == this.current) {
                this.current = null;
            }
            return removed;
        }

        @Override
        public void handleStack(Item item, int amount, Teamc source) {
            super.handleStack(item, amount, source);
            this.current = item;
        }

        @Override
        public void handleItem(Building source, Item item) {
            this.current = item;
            this.progress = -1.0f;
            this.recDir = this.relativeToEdge(source.tile);
            this.items.add(item, 1);
            this.noSleep();
        }

        @Override
        public void onProximityUpdate() {
            DuctBuild d;
            super.onProximityUpdate();
            int[] bits = Duct.this.buildBlending(this.tile, this.rotation, null, true);
            this.blendbits = bits[0];
            this.xscl = bits[1];
            this.yscl = bits[2];
            this.blending = bits[4];
            Building building = this.next = this.front();
            this.nextc = building instanceof DuctBuild ? (d = (DuctBuild)building) : null;
        }

        @Override
        public byte version() {
            return 1;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.b(this.recDir);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision >= 1) {
                this.recDir = read.b();
            }
            this.current = this.items.first();
        }

        @Override
        public double sense(LAccess sensor) {
            if (sensor == LAccess.progress) {
                return this.progress;
            }
            return super.sense(sensor);
        }
    }
}

