/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense;

import arc.func.Cons;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Intersector;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Groups;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class DirectionalForceProjector
extends Block {
    protected static final Vec2 intersectOut = new Vec2();
    protected static final Vec2 p1 = new Vec2();
    protected static final Vec2 p2 = new Vec2();
    protected static DirectionalForceProjectorBuild paramEntity;
    protected static Effect paramEffect;
    protected static final Cons<Bullet> dirShieldConsumer;
    public float width = 30.0f;
    public float shieldHealth = 3000.0f;
    public float cooldownNormal = 1.75f;
    public float cooldownLiquid = 1.5f;
    public float cooldownBrokenBase = 0.35f;
    public Effect absorbEffect = Fx.absorb;
    public Effect shieldBreakEffect = Fx.shieldBreak;
    public TextureRegion topRegion;
    public float length = 40.0f;
    public float padSize = 40.0f;

    public DirectionalForceProjector(String name) {
        super(name);
        this.rotate = true;
        this.rotateDraw = false;
        this.update = true;
        this.solid = true;
        this.group = BlockGroup.projectors;
        this.envEnabled |= 2;
        this.ambientSound = Sounds.shield;
        this.ambientSoundVolume = 0.08f;
    }

    @Override
    public void init() {
        this.updateClipRadius(this.width + 3.0f);
        super.init();
        if (this.length < 0.0f) {
            this.length = (float)(this.size * 8) / 2.0f;
        }
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addBar("shield", entity -> new Bar("stat.shieldhealth", Pal.accent, () -> entity.broken ? 0.0f : 1.0f - entity.buildup / this.shieldHealth).blink(Color.white));
    }

    @Override
    public boolean outputsItems() {
        return false;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.shieldHealth, this.shieldHealth, StatUnit.none);
        this.stats.add(Stat.cooldownTime, (int)(this.shieldHealth / this.cooldownBrokenBase / 60.0f), StatUnit.seconds);
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        this.drawPotentialLinks(x, y);
        Tmp.v1.set(this.length - (float)this.size / 2.0f, this.width + (float)this.size / 2.0f).rotate(rotation * 90).add(x *= 8, (float)(y *= 8));
        Tmp.v2.set(this.length - (float)this.size / 2.0f, -(this.width + (float)this.size / 2.0f)).rotate(rotation * 90).add(x, (float)y);
        Drawf.dashLine(Color.lightGray, x, y, Tmp.v1.x, Tmp.v1.y);
        Drawf.dashLine(Color.lightGray, x, y, Tmp.v2.x, Tmp.v2.y);
        Drawf.dashLine(Pal.accent, Tmp.v1.x, Tmp.v1.y, Tmp.v2.x, Tmp.v2.y);
    }

    static {
        dirShieldConsumer = b -> {
            float deltaAdd;
            if (b.team != DirectionalForceProjector.paramEntity.team && b.type.absorbable && Intersector.intersectSegments(b.x, b.y, b.x + b.vel.x * (Time.delta + (deltaAdd = 1.1f)), b.y + b.vel.y * (Time.delta + deltaAdd), DirectionalForceProjector.p1.x, DirectionalForceProjector.p1.y, DirectionalForceProjector.p2.x, DirectionalForceProjector.p2.y, intersectOut)) {
                b.set(intersectOut);
                b.absorb();
                paramEffect.at((Position)b);
                DirectionalForceProjector.paramEntity.hit = 1.0f;
                DirectionalForceProjector.paramEntity.buildup += b.damage();
            }
        };
    }

    public class DirectionalForceProjectorBuild
    extends Building {
        public boolean broken = true;
        public float buildup;
        public float hit;
        public float warmup;
        public float shieldRadius;

        @Override
        public boolean shouldAmbientSound() {
            return !this.broken && this.shieldRadius > 1.0f;
        }

        @Override
        public void pickedUp() {
            super.pickedUp();
            this.warmup = 0.0f;
            this.shieldRadius = 0.0f;
        }

        @Override
        public void updateTile() {
            this.shieldRadius = Mathf.lerpDelta(this.shieldRadius, this.broken ? 0.0f : this.warmup * DirectionalForceProjector.this.width, 0.05f);
            if (Mathf.chanceDelta(this.buildup / DirectionalForceProjector.this.shieldHealth * 0.1f)) {
                Fx.reactorsmoke.at(this.x + Mathf.range(4.0f), this.y + Mathf.range(4.0f));
            }
            this.warmup = Mathf.lerpDelta(this.warmup, this.efficiency, 0.1f);
            if (this.buildup > 0.0f) {
                // empty if block
            }
            if (this.broken && this.buildup <= 0.0f) {
                this.broken = false;
            }
            if (this.buildup >= DirectionalForceProjector.this.shieldHealth && !this.broken) {
                this.broken = true;
                this.buildup = DirectionalForceProjector.this.shieldHealth;
                DirectionalForceProjector.this.shieldBreakEffect.at(this.x, this.y, this.shieldRadius, this.team.color);
            }
            if (this.hit > 0.0f) {
                this.hit -= 0.2f * Time.delta;
            }
            this.deflectBullets();
        }

        public void deflectBullets() {
            if (this.shieldRadius > 0.0f && !this.broken) {
                paramEntity = this;
                paramEffect = DirectionalForceProjector.this.absorbEffect;
                p1.set(DirectionalForceProjector.this.length, this.shieldRadius).rotate(this.rotdeg());
                p2.set(DirectionalForceProjector.this.length, -this.shieldRadius).rotate(this.rotdeg());
                Tmp.r1.set(DirectionalForceProjector.p2.x, DirectionalForceProjector.p2.y, DirectionalForceProjector.p1.x - DirectionalForceProjector.p2.x, DirectionalForceProjector.p1.y - DirectionalForceProjector.p2.y).normalize().grow(DirectionalForceProjector.this.padSize);
                p1.add(this.x, this.y);
                p2.add(this.x, this.y);
                Groups.bullet.intersect(this.x + Tmp.r1.x, this.y + Tmp.r1.y, Tmp.r1.width, Tmp.r1.height, dirShieldConsumer);
            }
        }

        @Override
        public void draw() {
            super.draw();
            if (this.buildup > 0.0f) {
                Draw.alpha(this.buildup / DirectionalForceProjector.this.shieldHealth * 0.75f);
                Draw.z(31.0f);
                Draw.blend(Blending.additive);
                Draw.rect(DirectionalForceProjector.this.topRegion, this.x, this.y);
                Draw.blend();
                Draw.z(30.0f);
                Draw.reset();
            }
            this.drawShield();
        }

        public void drawShield() {
            if (!this.broken && this.shieldRadius > 0.0f) {
                float rot = this.rotdeg();
                p1.set(DirectionalForceProjector.this.length, this.shieldRadius).rotate(rot).add(this);
                p2.set(DirectionalForceProjector.this.length, -this.shieldRadius).rotate(rot).add(this);
                float size = 4.0f;
                Tmp.r1.set(DirectionalForceProjector.p2.x, DirectionalForceProjector.p2.y, DirectionalForceProjector.p1.x - DirectionalForceProjector.p2.x, DirectionalForceProjector.p1.y - DirectionalForceProjector.p2.y).normalize().grow(size);
                Draw.z(125.0f);
                Draw.color(this.team.color, Color.white, Mathf.clamp(this.hit));
                if (Vars.renderer.animateShields) {
                    Fill.rect(Tmp.r1);
                    Tmp.v1.set(DirectionalForceProjector.this.length - size / 2.0f, this.shieldRadius + size / 2.0f).rotate(rot).add(this);
                    Tmp.v2.set(DirectionalForceProjector.this.length - size / 2.0f, -(this.shieldRadius + size / 2.0f)).rotate(rot).add(this);
                    Lines.stroke(3.0f);
                    Lines.line(this.x, this.y, Tmp.v1.x, Tmp.v1.y);
                    Lines.line(this.x, this.y, Tmp.v2.x, Tmp.v2.y);
                    Draw.z(125.0f);
                    for (int i : Mathf.signs) {
                        Tmp.v1.set(DirectionalForceProjector.this.length - size / 2.0f, (this.shieldRadius + size / 2.0f) * (float)i).rotate(rot).add(this);
                        Tmp.v3.set(DirectionalForceProjector.this.length + size / 2.0f, (this.shieldRadius + size / 2.0f) * (float)i).rotate(rot).add(this);
                        Tmp.v2.set(DirectionalForceProjector.this.length, (this.shieldRadius + size) * (float)i).rotate(rot).add(this);
                        Fill.tri(Tmp.v1.x, Tmp.v1.y, Tmp.v2.x, Tmp.v2.y, Tmp.v3.x, Tmp.v3.y);
                    }
                } else {
                    Lines.stroke(1.5f);
                    Draw.alpha(0.09f + Mathf.clamp(0.08f * this.hit));
                    Fill.rect(Tmp.r1);
                    Draw.alpha(1.0f);
                    Lines.rect(Tmp.r1);
                    Draw.reset();
                }
                Draw.reset();
            }
        }
    }
}

