/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.filters;

import arc.scene.ui.layout.Table;
import mindustry.Vars;
import mindustry.gen.Icon;
import mindustry.logic.LAssembler;
import mindustry.logic.LExecutor;
import mindustry.maps.filters.FilterOption;
import mindustry.maps.filters.GenerateFilter;
import mindustry.world.Tiles;

public class LogicFilter
extends GenerateFilter {
    public static int maxInstructionsExecution = 6250000;
    public String code;
    public boolean loop;

    @Override
    public FilterOption[] options() {
        return new FilterOption[]{new FilterOption(){
            final String name;
            {
                this.name = "code";
            }

            @Override
            public void build(Table table) {
                table.button(b -> b.image(Icon.pencil).size(24.0f), () -> Vars.ui.logic.show(LogicFilter.this.code, null, true, code -> {
                    LogicFilter.this.code = code;
                })).pad(4.0f).margin(12.0f);
                table.add("@filter.option." + this.name);
            }
        }, new FilterOption.ToggleOption("loop", () -> this.loop, f -> {
            this.loop = f;
        })};
    }

    @Override
    public void apply(Tiles tiles, GenerateFilter.GenerateInput in) {
        LExecutor executor = new LExecutor();
        executor.privileged = true;
        try {
            executor.load(LAssembler.assemble(this.code, true));
        }
        catch (Throwable ignored) {
            return;
        }
        Vars.logicVars.update();
        for (int i = 1; i < maxInstructionsExecution && (this.loop || !(executor.counter.numval >= (double)executor.instructions.length) && !(executor.counter.numval < 0.0)); ++i) {
            executor.runOnce();
        }
    }

    @Override
    public char icon() {
        return '\uf7e4';
    }

    @Override
    public boolean isPost() {
        return true;
    }
}

