/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.math.geom.Rect;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.core.World;
import mindustry.gen.Groups;
import mindustry.gen.Hitboxc;
import mindustry.gen.Unit;
import mindustry.world.Tile;

public class DebugCollisionRenderer {
    static final float[] edges = new float[]{1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f};

    public static void draw() {
        Rect rect = Core.camera.bounds(new Rect());
        Draw.draw(120.0f, () -> {
            Draw.color(Color.green, 0.3f);
            Groups.draw.each(d -> {
                if (d instanceof Hitboxc) {
                    Hitboxc h = (Hitboxc)((Object)d);
                    if (rect.overlaps(Tmp.r1.setCentered(d.x(), d.y(), d.clipSize()))) {
                        Fill.square(d.x(), d.y(), h.hitSize() / 2.0f);
                    }
                }
            });
            Lines.stroke(0.4f, Color.magenta);
            int rx = Mathf.clamp((int)(Core.camera.width / 8.0f / 2.0f) + 1, 0, Vars.world.width() / 2);
            int ry = Mathf.clamp((int)(Core.camera.height / 8.0f / 2.0f) + 1, 0, Vars.world.height() / 2);
            for (int x = -rx; x <= rx; ++x) {
                for (int y = -ry; y <= ry; ++y) {
                    int[] avoid;
                    int wy;
                    int wx = World.toTile(Core.camera.position.x) + x;
                    Tile tile = Vars.world.tile(wx, wy = World.toTile(Core.camera.position.y) + y);
                    if (tile != null && tile.solid()) {
                        for (int i = 0; i < 4; ++i) {
                            Tile other = tile.nearby(i);
                            if (other != null && other.solid()) continue;
                            Lines.line((float)(wx * 8) + edges[i * 2] * 8.0f / 2.0f, (float)(wy * 8) + edges[i * 2 + 1] * 8.0f / 2.0f, (float)(wx * 8) + edges[(i + 1) % 4 * 2] * 8.0f / 2.0f, (float)(wy * 8) + edges[(i + 1) % 4 * 2 + 1] * 8.0f / 2.0f);
                        }
                    }
                    if (!Vars.debugDrawAvoidance || tile == null || (avoid = Vars.avoidance.getAvoidance()) == null || avoid[tile.array()] == 0) continue;
                    Draw.color(0.0f, 1.0f, 1.0f, 0.25f);
                    Fill.square(tile.worldx(), tile.worldy(), 4.0f);
                }
            }
            Groups.draw.each(d -> {
                if (d instanceof Unit) {
                    Unit u = (Unit)d;
                    if (rect.overlaps(Tmp.r1.setCentered(u.x, u.y, d.clipSize())) && !u.isFlying()) {
                        u.hitboxTile(Tmp.r1);
                        Lines.rect(Tmp.r1);
                    }
                }
            });
            Lines.stroke(0.5f);
            Draw.color(Color.red, 0.5f);
            Groups.draw.each(d -> {
                Unit u;
                if (d instanceof Unit && rect.overlaps(Tmp.r1.setCentered(u.x, u.y, (u = (Unit)d).clipSize()))) {
                    Lines.circle(u.x, u.y, u.hitSize * 0.6f);
                }
            });
            Draw.reset();
        });
        Draw.reset();
    }
}

