/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.bullet;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.util.Nullable;
import arc.util.Tmp;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Bullet;
import mindustry.graphics.Pal;

public class BasicBulletType
extends BulletType {
    public Color backColor = Pal.bulletYellowBack;
    public Color frontColor = Pal.bulletYellow;
    public Color mixColorFrom = new Color(1.0f, 1.0f, 1.0f, 0.0f);
    public Color mixColorTo = new Color(1.0f, 1.0f, 1.0f, 0.0f);
    public float width = 5.0f;
    public float height = 7.0f;
    public float shrinkX = 0.0f;
    public float shrinkY = 0.5f;
    public Interp shrinkInterp = Interp.linear;
    public float spin = 0.0f;
    public float rotationOffset = 0.0f;
    public String sprite;
    @Nullable
    public String backSprite;
    public TextureRegion backRegion;
    public TextureRegion frontRegion;

    public BasicBulletType(float speed, float damage, String bulletSprite) {
        super(speed, damage);
        this.sprite = bulletSprite;
        this.hitSoundPitchRange = 0.2f;
        this.hitSoundVolume = 0.4f;
    }

    public BasicBulletType(float speed, float damage) {
        this(speed, damage, "bullet");
    }

    public BasicBulletType() {
        this(1.0f, 1.0f, "bullet");
    }

    @Override
    public void load() {
        super.load();
        this.backRegion = Core.atlas.find(this.backSprite == null ? this.sprite + "-back" : this.backSprite);
        this.frontRegion = Core.atlas.find(this.sprite);
    }

    @Override
    public void draw(Bullet b) {
        super.draw(b);
        float shrink = this.shrinkInterp.apply(b.fout());
        float height = this.height * (1.0f - this.shrinkY + this.shrinkY * shrink);
        float width = this.width * (1.0f - this.shrinkX + this.shrinkX * shrink);
        float offset = -90.0f + (this.spin != 0.0f ? Mathf.randomSeed(b.id, 360.0f) + b.time * this.spin : 0.0f) + this.rotationOffset;
        Color mix = Tmp.c1.set(this.mixColorFrom).lerp(this.mixColorTo, b.fin());
        Draw.mixcol(mix, mix.a);
        if (this.backRegion.found()) {
            Draw.color(this.backColor);
            Draw.rect(this.backRegion, b.x, b.y, width, height, b.rotation() + offset);
        }
        Draw.color(this.frontColor);
        Draw.rect(this.frontRegion, b.x, b.y, width, height, b.rotation() + offset);
        Draw.reset();
    }
}

