/*
 * Decompiled with CFR 0.152.
 */
package arc.profiling;

import arc.util.Log;
import arc.util.Nullable;
import arc.util.Strings;

public interface GLErrorListener {
    public static final GLErrorListener loggingListener = error -> {
        String place = GLErrorListener.getCallName();
        if (place != null) {
            Log.err(new RuntimeException(Strings.format("[GLProfiler] Error @ from @", error, place)));
        } else {
            Log.err(new RuntimeException(Strings.format("[GLProfiler] Error @", error)));
        }
    };
    public static final GLErrorListener throwingListener = error -> {
        String place = GLErrorListener.getCallName();
        if (place != null) {
            throw new RuntimeException(Strings.format("[GLProfiler] Error @ from @", error, place));
        }
        throw new RuntimeException(Strings.format("[GLProfiler] Error @", error));
    };

    public void onError(String var1);

    @Nullable
    public static String getCallName() {
        String place = null;
        try {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            for (int i = 0; i < stack.length; ++i) {
                if (!"check".equals(stack[i].getMethodName())) continue;
                if (i + 1 < stack.length) {
                    StackTraceElement glMethod = stack[i + 1];
                    place = glMethod.getMethodName();
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return place;
    }
}

