/*
 * Decompiled with CFR 0.152.
 */
package arc.flabel.effects;

import arc.flabel.FEffect;
import arc.flabel.FGlyph;
import arc.flabel.FLabel;
import arc.math.Interp;
import arc.struct.IntSeq;

public class SickEffect
extends FEffect {
    private static final float defaultFrequency = 50.0f;
    private static final float defaultDistance = 0.125f;
    private static final float defaultIntensity = 1.0f;
    public float distance = 1.0f;
    public float intensity = 1.0f;
    private IntSeq indices = new IntSeq();

    @Override
    protected void onApply(FLabel label, FGlyph glyph, int localIndex, float delta) {
        float progressModifier = 1.0f / this.intensity * 1.0f;
        float progressOffset = (float)localIndex / 50.0f;
        float progress = this.calculateProgress(progressModifier, -progressOffset, false);
        if (progress < 0.01f && Math.random() > 0.25 && !this.indices.contains(localIndex)) {
            this.indices.add(localIndex);
        }
        if (progress > 0.95f) {
            this.indices.removeValue(localIndex);
        }
        if (!(this.indices.contains(localIndex) || this.indices.contains(localIndex - 1) || this.indices.contains(localIndex - 2) || this.indices.contains(localIndex + 2) || this.indices.contains(localIndex + 1))) {
            return;
        }
        float interpolation = 0.0f;
        float split = 0.5f;
        interpolation = progress < split ? Interp.pow2Out.apply(0.0f, 1.0f, progress / split) : Interp.pow2In.apply(1.0f, 0.0f, (progress - split) / (1.0f - split));
        float y = this.getLineHeight(label) * this.distance * interpolation * 0.125f;
        if (this.indices.contains(localIndex)) {
            y *= 2.15f;
        }
        if (this.indices.contains(localIndex - 1) || this.indices.contains(localIndex + 1)) {
            y *= 1.35f;
        }
        float fadeout = this.calculateFadeout();
        glyph.yoffset = (int)((float)glyph.yoffset - (y *= fadeout));
    }
}

