/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.blocks.production.HeatCrafter;
import mindustry.world.draw.DrawBlock;

public class DrawHeatRegion
extends DrawBlock {
    public Color color = new Color(1.0f, 0.22f, 0.22f, 0.8f);
    public float pulse = 0.3f;
    public float pulseScl = 10.0f;
    public float layer = 31.0f;
    public TextureRegion heat;
    public String suffix = "-glow";

    public DrawHeatRegion(float layer) {
        this.layer = layer;
    }

    public DrawHeatRegion(String suffix) {
        this.suffix = suffix;
    }

    public DrawHeatRegion() {
    }

    @Override
    public void draw(Building build) {
        Draw.z(31.0f);
        if (build instanceof HeatCrafter.HeatCrafterBuild) {
            HeatCrafter.HeatCrafterBuild hc = (HeatCrafter.HeatCrafterBuild)build;
            if (hc.heat > 0.0f) {
                float z = Draw.z();
                if (this.layer > 0.0f) {
                    Draw.z(this.layer);
                }
                Draw.blend(Blending.additive);
                Draw.color(this.color, Mathf.clamp(hc.heat / hc.heatRequirement()) * (this.color.a * (1.0f - this.pulse + Mathf.absin(this.pulseScl, this.pulse))));
                Draw.rect(this.heat, build.x, build.y);
                Draw.blend();
                Draw.color();
                Draw.z(z);
            }
        }
    }

    @Override
    public void load(Block block) {
        this.heat = Core.atlas.find(block.name + this.suffix);
    }
}

