/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.power;

import arc.Core;
import arc.func.Boolf;
import arc.func.Cons;
import arc.func.Cons2;
import arc.func.Func;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Intersector;
import arc.math.geom.Point2;
import arc.math.geom.QuadTree;
import arc.struct.IntSeq;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Structs;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.core.Renderer;
import mindustry.core.UI;
import mindustry.core.World;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.input.Placement;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.Edges;
import mindustry.world.Tile;
import mindustry.world.blocks.power.PowerBlock;
import mindustry.world.blocks.power.PowerGraph;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.modules.PowerModule;

public class PowerNode
extends PowerBlock {
    protected static BuildPlan otherReq;
    protected static int returnInt;
    protected static final ObjectSet<PowerGraph> graphs;
    protected static float maxRange;
    public TextureRegion laser;
    public TextureRegion laserEnd;
    public float laserRange = 6.0f;
    public int maxNodes = 3;
    public boolean autolink = true;
    public boolean drawRange = true;
    public boolean sameBlockConnection = false;
    public float laserScale = 0.25f;
    public float powerLayer = 70.0f;
    public Color laserColor1 = Color.white;
    public Color laserColor2 = Pal.powerLight;

    public PowerNode(String name) {
        super(name);
        this.configurable = true;
        this.consumesPower = false;
        this.outputsPower = false;
        this.canOverdrive = false;
        this.swapDiagonalPlacement = true;
        this.schematicPriority = -10;
        this.drawDisabled = false;
        this.envEnabled |= 2;
        this.destructible = true;
        this.update = false;
        this.config(Integer.class, (entity, value) -> {
            boolean valid;
            PowerModule power = entity.power;
            Building other = Vars.world.build((int)value);
            boolean contains = power.links.contains((int)value);
            boolean bl = valid = other != null && other.power != null;
            if (contains) {
                power.links.removeValue((int)value);
                if (valid) {
                    other.power.links.removeValue(entity.pos());
                }
                PowerGraph newgraph = new PowerGraph();
                newgraph.reflow((Building)entity);
                if (valid && other.power.graph != newgraph) {
                    PowerGraph og = new PowerGraph();
                    og.reflow(other);
                }
            } else if (this.linkValid((Building)entity, other) && valid && power.links.size < this.maxNodes) {
                power.links.addUnique(other.pos());
                if (other.team == entity.team) {
                    other.power.links.addUnique(entity.pos());
                }
                power.graph.addGraph(other.power.graph);
            }
        });
        this.config(Point2[].class, (tile, value) -> {
            IntSeq old = new IntSeq(tile.power.links);
            for (int i = 0; i < old.size; ++i) {
                ((Cons2)this.configurations.get(Integer.class)).get(tile, old.get(i));
            }
            for (Point2 p : value) {
                ((Cons2)this.configurations.get(Integer.class)).get(tile, Point2.pack(p.x + tile.tileX(), p.y + tile.tileY()));
            }
        });
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addBar("power", PowerNode.makePowerBalance());
        this.addBar("batteries", PowerNode.makeBatteryBalance());
        this.addBar("connections", entity -> new Bar(() -> Core.bundle.format("bar.powerlines", entity.power.links.size, this.maxNodes), () -> Pal.items, () -> (float)entity.power.links.size / (float)this.maxNodes));
    }

    public static Func<Building, Bar> makePowerBalance() {
        return entity -> new Bar(() -> Core.bundle.format("bar.powerbalance", (entity.power.graph.getPowerBalance() >= 0.0f ? "+" : "") + UI.formatAmount((long)(entity.power.graph.getPowerBalance() * 60.0f))), () -> Pal.powerBar, () -> Mathf.clamp(entity.power.graph.getLastPowerProduced() / entity.power.graph.getLastPowerNeeded()));
    }

    public static Func<Building, Bar> makeBatteryBalance() {
        return entity -> new Bar(() -> Core.bundle.format("bar.powerstored", UI.formatAmount((long)entity.power.graph.getLastPowerStored()), UI.formatAmount((long)entity.power.graph.getLastCapacity())), () -> Pal.powerBar, () -> Mathf.clamp(entity.power.graph.getLastPowerStored() / entity.power.graph.getLastCapacity()));
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.powerRange, this.laserRange, StatUnit.blocks);
        this.stats.add(Stat.powerConnections, this.maxNodes, StatUnit.none);
    }

    @Override
    public void init() {
        super.init();
        this.clipSize = Math.max(this.clipSize, this.laserRange * 8.0f);
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        Tile tile = Vars.world.tile(x, y);
        if (tile == null || !this.autolink) {
            return;
        }
        Lines.stroke(1.0f);
        Draw.color(Pal.placing);
        Drawf.circles((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.laserRange * 8.0f);
        this.getPotentialLinks(tile, Vars.player.team(), other -> {
            Draw.color(this.laserColor1, Renderer.laserOpacity * 0.5f);
            this.drawLaser((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, other.x, other.y, this.size, other.block.size);
            Drawf.square(other.x, other.y, (float)(other.block.size * 8) / 2.0f + 2.0f, Pal.place);
        });
        Draw.reset();
    }

    @Override
    public void changePlacementPath(Seq<Point2> points, int rotation) {
        Placement.calculateNodes(points, this, rotation, (point, other) -> this.overlaps(Vars.world.tile(point.x, point.y), Vars.world.tile(other.x, other.y)));
    }

    protected void setupColor(float satisfaction) {
        Draw.color(Tmp.c1.set(this.laserColor1).lerp(this.laserColor2, (1.0f - satisfaction) * 0.86f + Mathf.absin(3.0f, 0.1f)).a(Renderer.laserOpacity));
    }

    public void drawLaser(float x1, float y1, float x2, float y2, int size1, int size2) {
        float angle1 = Angles.angle(x1, y1, x2, y2);
        float vx = Mathf.cosDeg(angle1);
        float vy = Mathf.sinDeg(angle1);
        float len1 = (float)(size1 * 8) / 2.0f - 1.5f;
        float len2 = (float)(size2 * 8) / 2.0f - 1.5f;
        Drawf.laser(this.laser, this.laserEnd, x1 + vx * len1, y1 + vy * len1, x2 - vx * len2, y2 - vy * len2, this.laserScale);
    }

    protected boolean overlaps(float srcx, float srcy, Tile other, Block otherBlock, float range) {
        return Intersector.overlaps(Tmp.cr1.set(srcx, srcy, range), Tmp.r1.setCentered(other.worldx() + otherBlock.offset, other.worldy() + otherBlock.offset, otherBlock.size * 8, otherBlock.size * 8));
    }

    protected boolean overlaps(float srcx, float srcy, Tile other, float range) {
        return Intersector.overlaps(Tmp.cr1.set(srcx, srcy, range), other.getHitbox(Tmp.r1));
    }

    protected boolean overlaps(Building src, Building other, float range) {
        return this.overlaps(src.x, src.y, other.tile, range);
    }

    protected boolean overlaps(Tile src, Tile other, float range) {
        return this.overlaps(src.drawx(), src.drawy(), other, range);
    }

    public boolean overlaps(@Nullable Tile src, @Nullable Tile other) {
        if (src == null || other == null) {
            return true;
        }
        return Intersector.overlaps(Tmp.cr1.set(src.worldx() + this.offset, src.worldy() + this.offset, this.laserRange * 8.0f), Tmp.r1.setSize(this.size * 8).setCenter(other.worldx() + this.offset, other.worldy() + this.offset));
    }

    protected void getPotentialLinks(Tile tile, Team team, Cons<Building> others) {
        if (!this.autolink) {
            return;
        }
        Boolf<Building> valid = other -> {
            if (other == null) return false;
            if (other.tile == tile) return false;
            if (!other.block.connectedPower) return false;
            if (other.power == null) return false;
            if (!other.block.outputsPower && !other.block.consumesPower) {
                if (!(other.block instanceof PowerNode)) return false;
            }
            if (!this.overlaps((float)(tile.x * 8) + this.offset, (float)(tile.y * 8) + this.offset, other.tile, this.laserRange * 8.0f)) return false;
            if (other.team != team) return false;
            if (graphs.contains(other.power.graph)) return false;
            if (PowerNode.insulated(tile, other.tile)) return false;
            if (other instanceof PowerNodeBuild) {
                PowerNodeBuild obuild = (PowerNodeBuild)other;
                if (obuild.power.links.size >= ((PowerNode)obuild.block).maxNodes) return false;
            }
            if (Structs.contains(Edges.getEdges(this.size), p -> {
                Tile t = Vars.world.tile(tile.x + p.x, tile.y + p.y);
                return t != null && t.build == other;
            })) return false;
            return true;
        };
        tempBuilds.clear();
        graphs.clear();
        for (Point2 p : Edges.getEdges(this.size)) {
            Tile other2 = tile.nearby(p);
            if (other2 == null || other2.team() != team || other2.build == null || other2.build.power == null) continue;
            graphs.add(other2.build.power.graph);
        }
        if (tile.build != null && tile.build.power != null) {
            graphs.add(tile.build.power.graph);
        }
        float worldRange = this.laserRange * 8.0f;
        QuadTree<Building> tree = team.data().buildingTree;
        if (tree != null) {
            tree.intersect(tile.worldx() - worldRange, tile.worldy() - worldRange, worldRange * 2.0f, worldRange * 2.0f, build -> {
                if (valid.get((Building)build) && !tempBuilds.contains(build)) {
                    tempBuilds.add(build);
                }
            });
        }
        tempBuilds.sort((a, b) -> {
            int type = -Boolean.compare(a.block instanceof PowerNode, b.block instanceof PowerNode);
            if (type != 0) {
                return type;
            }
            return Float.compare(a.dst2(tile), b.dst2(tile));
        });
        returnInt = 0;
        tempBuilds.each(valid, t -> {
            if (returnInt++ < this.maxNodes) {
                graphs.add(t.power.graph);
                others.get((Building)t);
            }
        });
    }

    public static void getNodeLinks(Tile tile, Block block, Team team, Cons<Building> others) {
        Boolf<Building> valid = other -> {
            if (other == null) return false;
            if (other.tile == tile) return false;
            Block patt10404$temp = other.block;
            if (!(patt10404$temp instanceof PowerNode)) return false;
            PowerNode node = (PowerNode)patt10404$temp;
            if (!node.autolink) return false;
            if (other.power.links.size >= node.maxNodes) return false;
            if (!node.overlaps(other.x, other.y, tile, block, node.laserRange * 8.0f)) return false;
            if (other.team != team) return false;
            if (graphs.contains(other.power.graph)) return false;
            if (PowerNode.insulated(tile, other.tile)) return false;
            if (Structs.contains(Edges.getEdges(block.size), p -> {
                Tile t = Vars.world.tile(tile.x + p.x, tile.y + p.y);
                return t != null && t.build == other;
            })) return false;
            return true;
        };
        tempBuilds.clear();
        graphs.clear();
        for (Point2 p : Edges.getEdges(block.size)) {
            Tile other2 = tile.nearby(p);
            if (other2 == null || other2.team() != team || other2.build == null || other2.build.power == null || block.consumesPower && other2.block().consumesPower && !block.outputsPower && !other2.block().outputsPower) continue;
            graphs.add(other2.build.power.graph);
        }
        if (tile.build != null && tile.build.power != null) {
            graphs.add(tile.build.power.graph);
        }
        float rangeWorld = maxRange * 8.0f;
        QuadTree<Building> tree = team.data().buildingTree;
        if (tree != null) {
            tree.intersect(tile.worldx() - rangeWorld, tile.worldy() - rangeWorld, rangeWorld * 2.0f, rangeWorld * 2.0f, build -> {
                if (valid.get((Building)build) && !tempBuilds.contains(build)) {
                    tempBuilds.add(build);
                }
            });
        }
        tempBuilds.sort((a, b) -> {
            int type = -Boolean.compare(a.block instanceof PowerNode, b.block instanceof PowerNode);
            if (type != 0) {
                return type;
            }
            return Float.compare(a.dst2(tile), b.dst2(tile));
        });
        tempBuilds.each(valid, t -> {
            graphs.add(t.power.graph);
            others.get((Building)t);
        });
    }

    @Override
    public void drawPlanConfigTop(BuildPlan plan, Eachable<BuildPlan> list) {
        Point2[] point2Array = plan.config;
        if (point2Array instanceof Point2[]) {
            Point2[] ps = point2Array;
            this.setupColor(1.0f);
            for (Point2 point : ps) {
                int px = plan.x + point.x;
                int py = plan.y + point.y;
                otherReq = null;
                list.each(other -> {
                    if (other.block != null && px >= other.x - (other.block.size - 1) / 2 && py >= other.y - (other.block.size - 1) / 2 && px <= other.x + other.block.size / 2 && py <= other.y + other.block.size / 2 && other != plan && other.block.hasPower) {
                        otherReq = other;
                    }
                });
                if (otherReq == null || PowerNode.otherReq.block == null) continue;
                this.drawLaser(plan.drawx(), plan.drawy(), otherReq.drawx(), otherReq.drawy(), this.size, PowerNode.otherReq.block.size);
            }
            Draw.color();
        }
    }

    public boolean linkValid(Building tile, Building link) {
        return this.linkValid(tile, link, true);
    }

    public boolean linkValid(Building tile, Building link, boolean checkMaxNodes) {
        block6: {
            Block block;
            block5: {
                if (tile == link || link == null || !link.block.hasPower || !link.block.connectedPower || tile.team != link.team || this.sameBlockConnection && tile.block != link.block) {
                    return false;
                }
                if (this.overlaps(tile, link, this.laserRange * 8.0f)) break block5;
                Block block2 = link.block;
                if (!(block2 instanceof PowerNode)) break block6;
                PowerNode node = (PowerNode)block2;
                if (!this.overlaps(link, tile, node.laserRange * 8.0f)) break block6;
            }
            if (checkMaxNodes && (block = link.block) instanceof PowerNode) {
                PowerNode node = (PowerNode)block;
                return link.power.links.size < node.maxNodes || link.power.links.contains(tile.pos());
            }
            return true;
        }
        return false;
    }

    public static boolean insulated(Tile tile, Tile other) {
        return PowerNode.insulated(tile.x, tile.y, other.x, other.y);
    }

    public static boolean insulated(Building tile, Building other) {
        return PowerNode.insulated(tile.tileX(), tile.tileY(), other.tileX(), other.tileY());
    }

    public static boolean insulated(int x, int y, int x2, int y2) {
        return World.raycast(x, y, x2, y2, (wx, wy) -> {
            Building tile = Vars.world.build(wx, wy);
            return tile != null && tile.isInsulated();
        });
    }

    static {
        returnInt = 0;
        graphs = new ObjectSet();
    }

    public class PowerNodeBuild
    extends Building {
        @Override
        public void created() {
            if (PowerNode.this.autolink && PowerNode.this.laserRange > maxRange) {
                maxRange = PowerNode.this.laserRange;
            }
            super.created();
        }

        @Override
        public void placed() {
            if (Vars.net.client() || this.power.links.size > 0) {
                return;
            }
            PowerNode.this.getPotentialLinks(this.tile, this.team, other -> {
                if (!this.power.links.contains(other.pos())) {
                    this.configureAny(other.pos());
                }
            });
            super.placed();
        }

        @Override
        public void dropped() {
            this.power.links.clear();
            this.updatePowerGraph();
        }

        @Override
        public boolean onConfigureBuildTapped(Building other) {
            if (PowerNode.this.linkValid(this, other)) {
                this.configure(other.pos());
                return false;
            }
            if (this == other) {
                if (other.power.links.size == 0) {
                    Seq points = new Seq();
                    PowerNode.this.getPotentialLinks(this.tile, this.team, link -> {
                        if (!PowerNode.insulated(this, link) && points.size < PowerNode.this.maxNodes) {
                            points.add(new Point2(link.tileX() - this.tile.x, link.tileY() - this.tile.y));
                        }
                    });
                    this.configure(points.toArray(Point2.class));
                } else {
                    this.configure(new Point2[0]);
                }
                this.deselect();
                return false;
            }
            return true;
        }

        @Override
        public void drawSelect() {
            super.drawSelect();
            if (!PowerNode.this.drawRange) {
                return;
            }
            Lines.stroke(1.0f);
            Draw.color(Pal.accent);
            Drawf.circles(this.x, this.y, PowerNode.this.laserRange * 8.0f);
            Draw.reset();
        }

        @Override
        public void drawConfigure() {
            Drawf.circles(this.x, this.y, (float)(this.tile.block().size * 8) / 2.0f + 1.0f + Mathf.absin(Time.time, 4.0f, 1.0f));
            if (PowerNode.this.drawRange) {
                Drawf.circles(this.x, this.y, PowerNode.this.laserRange * 8.0f);
                int x = (int)((float)this.tile.x - PowerNode.this.laserRange - 2.0f);
                while ((float)x <= (float)this.tile.x + PowerNode.this.laserRange + 2.0f) {
                    int y = (int)((float)this.tile.y - PowerNode.this.laserRange - 2.0f);
                    while ((float)y <= (float)this.tile.y + PowerNode.this.laserRange + 2.0f) {
                        boolean linked;
                        Building link = Vars.world.build(x, y);
                        if (link != this && PowerNode.this.linkValid(this, link, false) && (linked = this.linked(link))) {
                            Drawf.square(link.x, link.y, (float)(link.block.size * 8) / 2.0f + 1.0f, Pal.place);
                        }
                        ++y;
                    }
                    ++x;
                }
                Draw.reset();
            } else {
                this.power.links.each(i -> {
                    Building link = Vars.world.build(i);
                    if (link != null && PowerNode.this.linkValid(this, link, false)) {
                        Drawf.square(link.x, link.y, (float)(link.block.size * 8) / 2.0f + 1.0f, Pal.place);
                    }
                });
            }
        }

        @Override
        public void draw() {
            super.draw();
            if (Mathf.zero(Renderer.laserOpacity) || this.isPayload() || this.team == Team.derelict) {
                return;
            }
            Draw.z(PowerNode.this.powerLayer);
            PowerNode.this.setupColor(this.power.graph.getSatisfaction());
            for (int i = 0; i < this.power.links.size; ++i) {
                Building link = Vars.world.build(this.power.links.get(i));
                if (!PowerNode.this.linkValid(this, link) || link.block instanceof PowerNode && link.id >= this.id) continue;
                PowerNode.this.drawLaser(this.x, this.y, link.x, link.y, PowerNode.this.size, link.block.size);
            }
            Draw.reset();
        }

        protected boolean linked(Building other) {
            return this.power.links.contains(other.pos());
        }

        public Point2[] config() {
            Point2[] out = new Point2[this.power.links.size];
            for (int i = 0; i < out.length; ++i) {
                out[i] = Point2.unpack(this.power.links.get(i)).sub(this.tile.x, this.tile.y);
            }
            return out;
        }
    }
}

