/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.func.Boolf;
import arc.func.Cons;
import arc.math.Mathf;
import arc.scene.style.Drawable;
import arc.scene.ui.Button;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.TextButton;
import arc.scene.ui.layout.Cell;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.game.Rules;
import mindustry.game.Schematic;
import mindustry.gen.Icon;
import mindustry.type.Item;
import mindustry.type.ItemSeq;
import mindustry.type.ItemStack;
import mindustry.type.Sector;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.dialogs.LoadoutDialog;
import mindustry.ui.dialogs.PlanetDialog;
import mindustry.ui.dialogs.SchematicsDialog;
import mindustry.world.blocks.storage.CoreBlock;

public class LaunchLoadoutDialog
extends BaseDialog {
    LoadoutDialog loadout = new LoadoutDialog();
    ItemSeq total = new ItemSeq();
    Schematic selected;
    boolean valid;
    int lastCapacity;

    public LaunchLoadoutDialog() {
        super("@configure");
    }

    public void show(CoreBlock core, Sector sector, Sector destination, Runnable confirm) {
        boolean rows;
        this.cont.clear();
        this.buttons.clear();
        this.buttons.defaults().size(160.0f, 64.0f);
        this.buttons.button("@back", Icon.left, this::hide);
        this.addCloseListener();
        ItemSeq sitems = sector.items();
        ItemSeq launch = Vars.universe.getLaunchResources();
        if (sector.planet.allowLaunchLoadout) {
            for (Item item : Vars.content.items()) {
                if (item.isOnPlanet(sector.planet)) continue;
                launch.set(item, 0);
            }
            Vars.universe.updateLaunchResources(launch);
        }
        Runnable update = () -> {
            int cap = this.lastCapacity = (int)(sector.planet.launchCapacityMultiplier * (float)this.selected.findCore().itemCapacity);
            ItemSeq schems = this.selected.requirements();
            ItemSeq resources = Vars.universe.getLaunchResources();
            resources.min(cap);
            int capacity = this.lastCapacity;
            if (!destination.allowLaunchLoadout()) {
                resources.clear();
                if (destination.preset != null) {
                    Rules rules = destination.preset.generator.map.rules();
                    for (ItemStack stack : rules.loadout) {
                        if (!stack.item.isOnPlanet(sector.planet)) continue;
                        resources.add(stack.item, stack.amount);
                    }
                }
            } else if (this.getMax()) {
                for (Item item : Vars.content.items()) {
                    resources.set(item, Mathf.clamp(sitems.get(item) - schems.get(item), 0, capacity));
                }
            }
            Vars.universe.updateLaunchResources(resources);
            this.total.clear();
            this.selected.requirements().each(this.total::add);
            Vars.universe.getLaunchResources().each(this.total::add);
            this.valid = sitems.has(this.total) || PlanetDialog.debugSelect;
        };
        Cons<Table> rebuild = table -> {
            table.clearChildren();
            int i = 0;
            ItemSeq schems = this.selected.requirements();
            ItemSeq launches = Vars.universe.getLaunchResources();
            for (ItemStack s : this.total) {
                int al;
                int as = schems.get(s.item);
                if (as + (al = launches.get(s.item)) == 0) continue;
                table.image(s.item.uiIcon).left().size(24.0f);
                String amountStr = al + as + (destination.allowLaunchLoadout() ? "[gray] (" + al + " + " + as + ")" : "");
                table.add(sitems.has(s.item, s.amount) ? amountStr : "[scarlet]" + Math.min(sitems.get(s.item), s.amount) + "[lightgray]/" + amountStr).padLeft(2.0f).left().padRight(4.0f);
                if (++i % 4 != 0) continue;
                table.row();
            }
        };
        Table items = new Table();
        Runnable rebuildItems = () -> rebuild.get(items);
        if (destination.allowLaunchLoadout()) {
            this.buttons.button("@resources.max", (Drawable)Icon.add, Styles.togglet, () -> {
                this.setMax(!this.getMax());
                update.run();
                rebuildItems.run();
            }).checked(b -> this.getMax());
            this.buttons.button("@resources", Icon.edit, () -> {
                ItemSeq stacks = Vars.universe.getLaunchResources();
                Seq<ItemStack> out = stacks.toSeq();
                ItemSeq realItems = sitems.copy();
                this.selected.requirements().each(realItems::remove);
                this.loadout.show(this.lastCapacity, realItems, out, i -> i.unlocked() && i.isOnPlanet(sector.planet), out::clear, () -> {}, () -> {
                    Vars.universe.updateLaunchResources(new ItemSeq(out));
                    update.run();
                    rebuildItems.run();
                });
            }).disabled(b -> this.getMax());
        }
        boolean bl = rows = Core.graphics.isPortrait() && Vars.mobile;
        if (rows) {
            this.buttons.row();
        }
        Cell<TextButton> cell = this.buttons.button("@launch.text", Icon.ok, () -> {
            Vars.universe.updateLoadout(core, this.selected);
            confirm.run();
            this.hide();
        }).disabled(b -> !this.valid);
        if (rows) {
            cell.colspan(2).size(324.0f, 64.0f);
        }
        int cols = Math.max((int)((float)Core.graphics.getWidth() / Scl.scl(230.0f)), 1);
        ButtonGroup group = new ButtonGroup();
        this.selected = Vars.universe.getLoadout(core);
        if (this.selected == null) {
            this.selected = Vars.schematics.getLoadouts().get((CoreBlock)Blocks.coreShard).first();
        }
        this.cont.add(Core.bundle.format("launch.from", sector.name())).row();
        if (destination.allowLaunchSchematics()) {
            this.cont.pane((Table t) -> {
                int[] i = new int[]{0};
                Cons<Schematic> handler = s -> {
                    if (s.tiles.contains((Schematic.Stile)((Object)((Boolf<Schematic.Stile>)tile -> !tile.block.supportsEnv(sector.planet.defaultEnv) || !tile.block.isOnPlanet(sector.planet))))) {
                        return;
                    }
                    t.button((Button b) -> b.add(new SchematicsDialog.SchematicImage((Schematic)s)), (Button.ButtonStyle)Styles.togglet, () -> {
                        this.selected = s;
                        update.run();
                        rebuildItems.run();
                    }).group(group).pad(4.0f).checked(s == this.selected).size(200.0f);
                    i[0] = i[0] + 1;
                    if (i[0] % cols == 0) {
                        t.row();
                    }
                };
                if (destination.allowLaunchSchematics() || Vars.schematics.getDefaultLoadout(core) == null) {
                    for (ObjectMap.Entry entry : Vars.schematics.getLoadouts()) {
                        if (((CoreBlock)entry.key).size > core.size) continue;
                        for (Schematic s2 : (Seq)entry.value) {
                            handler.get(s2);
                        }
                    }
                } else {
                    handler.get(Vars.schematics.getDefaultLoadout(core));
                }
            }).growX().scrollX(false);
            this.cont.row();
            this.cont.label(() -> Core.bundle.format("launch.capacity", this.lastCapacity)).row();
            this.cont.row();
        } else if (destination.preset != null && destination.preset.description != null) {
            this.cont.pane((Table p) -> p.add(destination.preset.description).grow().wrap().labelAlign(1)).pad(10.0f).grow().row();
        }
        this.cont.pane(items);
        this.cont.row();
        this.cont.add("@sector.missingresources").visible(() -> !this.valid);
        update.run();
        rebuildItems.run();
        this.show();
    }

    void setMax(boolean max) {
        Core.settings.put("maxresources", max);
    }

    boolean getMax() {
        return Core.settings.getBool("maxresources", true);
    }
}

