/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.Batch;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.event.ClickListener;
import arc.scene.event.HandCursorListener;
import arc.scene.ui.Dialog;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Reflect;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.gen.Tex;
import mindustry.logic.LogicFx;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.Block;

public class EffectsDialog
extends BaseDialog {
    static BoundsBatch bounds = new BoundsBatch();
    Iterable<LogicFx.EffectEntry> entries;
    @Nullable
    Cons<LogicFx.EffectEntry> listener;

    public EffectsDialog(Iterable<LogicFx.EffectEntry> entries) {
        super("Effects");
        this.entries = entries;
        this.addCloseButton();
        this.makeButtonOverlay();
        this.onResize(this::setup);
        this.shown(this::setup);
        this.setup();
    }

    public EffectsDialog() {
        this(LogicFx.entries());
    }

    public static EffectsDialog withAllEffects() {
        return new EffectsDialog(Seq.select(Fx.class.getFields(), f -> f.getType() == Effect.class).map(f -> new LogicFx.EffectEntry((Effect)Reflect.get(f)).name(f.getName())));
    }

    public Dialog show(Cons<LogicFx.EffectEntry> listener) {
        this.listener = listener;
        return super.show();
    }

    @Override
    public Dialog show() {
        this.listener = null;
        return super.show();
    }

    void setup() {
        float size = 280.0f;
        int cols = (int)Math.max(1.0f, (float)Core.graphics.getWidth() / Scl.scl(size + 12.0f));
        this.cont.clearChildren();
        this.cont.pane((Table t) -> {
            int i = 0;
            for (LogicFx.EffectEntry entry : this.entries) {
                float bounds = EffectsDialog.calculateSize(entry);
                if (bounds <= 0.0f) continue;
                ClickListener cl = new ClickListener();
                t.stack(new EffectCell(entry, cl), new Table(af -> af.add(entry.name).grow().labelAlign(12).style(Styles.outlineLabel).bottom().left())).size(size).with(a -> {
                    a.clicked(() -> {
                        if (this.listener != null) {
                            this.listener.get(entry);
                            this.hide();
                        }
                    });
                    a.addListener(cl);
                    a.addListener(new HandCursorListener(() -> this.listener != null, true));
                });
                if (++i % cols != 0) continue;
                t.row();
            }
        }).grow().scrollX(false);
    }

    static Object getData(Class<?> type) {
        if (type == Block.class) {
            return Blocks.router;
        }
        return null;
    }

    static float calculateSize(LogicFx.EffectEntry entry) {
        if (entry.bounds >= 0.0f) {
            return entry.bounds;
        }
        Effect effect = entry.effect;
        try {
            effect.init();
            Batch prev = Core.batch;
            bounds.reset();
            Core.batch = bounds;
            Object data = EffectsDialog.getData(entry.data);
            float lifetime = effect.lifetime;
            float rot = 1.0f;
            int steps = 60;
            int seeds = 4;
            for (int s = 0; s < seeds; ++s) {
                for (int i = 0; i <= steps; ++i) {
                    effect.render(1, Color.white, (float)i / (float)steps * lifetime, lifetime, rot, 0.0f, 0.0f, data);
                }
            }
            Core.batch = prev;
            entry.bounds = EffectsDialog.bounds.max * 2.0f;
            return entry.bounds;
        }
        catch (Exception e) {
            return -1.0f;
        }
    }

    static class BoundsBatch
    extends Batch {
        float max;

        BoundsBatch() {
        }

        void reset() {
            this.max = 0.0f;
        }

        void max(float ... xs) {
            for (float f : xs) {
                if (Float.isNaN(f)) continue;
                this.max = Math.max(this.max, Math.abs(f));
            }
        }

        @Override
        protected void draw(Texture texture, float[] spriteVertices, int offset, int count) {
            for (int i = offset; i < count; i += 6) {
                this.max(spriteVertices[i], spriteVertices[i + 1]);
            }
        }

        @Override
        protected void draw(TextureRegion region, float x, float y, float originX, float originY, float width, float height, float rotation) {
            float worldOriginX = x + originX;
            float worldOriginY = y + originY;
            float fx = -originX;
            float fy = -originY;
            float fx2 = width - originX;
            float fy2 = height - originY;
            float cos = Mathf.cosDeg(rotation);
            float sin = Mathf.sinDeg(rotation);
            float x1 = cos * fx - sin * fy + worldOriginX;
            float y1 = sin * fx + cos * fy + worldOriginY;
            float x2 = cos * fx - sin * fy2 + worldOriginX;
            float y2 = sin * fx + cos * fy2 + worldOriginY;
            float x3 = cos * fx2 - sin * fy2 + worldOriginX;
            float y3 = sin * fx2 + cos * fy2 + worldOriginY;
            this.max(x1, y1, x2, y2, x3, y3, x1 + (x3 - x2), y3 - (y2 - y1));
        }

        @Override
        protected void flush() {
        }
    }

    class EffectCell
    extends Element {
        LogicFx.EffectEntry effect;
        float size = -1.0f;
        int id = 1;
        float time = 0.0f;
        float lifetime;
        float rotation = 1.0f;
        Object data;
        ClickListener cl;

        public EffectCell(LogicFx.EffectEntry effect, ClickListener cl) {
            this.effect = effect;
            this.lifetime = effect.effect.lifetime;
            this.cl = cl;
            this.data = EffectsDialog.getData(effect.data);
        }

        @Override
        public void draw() {
            if (this.size < 0.0f) {
                this.size = EffectsDialog.calculateSize(this.effect) + 1.0f;
            }
            this.color.fromHsv(Time.globalTime * 2.0f % 360.0f, 1.0f, 1.0f);
            if (this.clipBegin(this.x, this.y, this.width, this.height)) {
                Draw.colorl(this.cl.isOver() && EffectsDialog.this.listener != null ? 0.4f : 0.5f);
                Draw.alpha(this.parentAlpha);
                Tex.alphaBg.draw(this.x, this.y, this.width, this.height);
                Draw.reset();
                Draw.flush();
                float scale = this.width / this.size;
                Tmp.m1.set(Draw.trans());
                Draw.trans().translate(this.x + this.width / 2.0f, this.y + this.height / 2.0f).scale(scale, scale);
                Draw.flush();
                this.lifetime = this.effect.effect.render(this.id, this.color, this.time, this.lifetime, this.rotation, 0.0f, 0.0f, this.data);
                Draw.flush();
                Draw.trans().set(Tmp.m1);
                this.clipEnd();
            }
            Lines.stroke(Scl.scl(3.0f), Color.black);
            Lines.rect(this.x, this.y, this.width, this.height);
            Draw.reset();
        }

        @Override
        public void act(float delta) {
            super.act(delta);
            this.time += Time.delta;
            if (this.time >= this.lifetime) {
                ++this.id;
            }
            this.time %= this.lifetime;
        }
    }
}

