/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.Gl;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.Shader;
import arc.math.geom.Point2;
import arc.struct.IntSet;
import arc.struct.Seq;
import arc.util.Disposable;
import arc.util.Structs;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.editor.EditorSpriteCache;
import mindustry.graphics.CacheLayer;
import mindustry.graphics.Shaders;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.StaticWall;

public class EditorRenderer
implements Disposable {
    private static final float packPad = 80.0f;
    private static final int chunkSize = 60;
    private static final Seq<Tile> tmpTiles = new Seq();
    private EditorSpriteCache[][] chunks;
    private IntSet recacheChunks = new IntSet();
    private int width;
    private int height;
    private float packWidth;
    private float packHeight;
    private Shader shader;

    public void resize(int width, int height) {
        this.dispose();
        this.recacheChunks.clear();
        this.chunks = new EditorSpriteCache[(int)Math.ceil((float)width / 60.0f)][(int)Math.ceil((float)height / 60.0f)];
        this.width = width;
        this.height = height;
        this.packWidth = (float)(width * 8) + 160.0f;
        this.packHeight = (float)(height * 8) + 160.0f;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                Tile tile = Vars.world.tile(x, y);
                if (!(tile.block() instanceof StaticWall)) continue;
                tile.data = 0;
            }
        }
        this.recache();
    }

    public void draw(float tx, float ty, float tw, float th) {
        boolean doUpdate;
        if (this.shader == null) {
            this.shader = new Shader("attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\nuniform mat4 u_projTrans;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\nvoid main(){\n   v_color = a_color;\n   v_color.a = v_color.a * (255.0/254.0);\n   v_texCoords = a_texCoord0;\n   gl_Position = u_projTrans * a_position;\n}\n", "varying lowp vec4 v_color;\nvarying vec2 v_texCoords;\nuniform sampler2D u_texture;\n\nvoid main(){\n  gl_FragColor = v_color * texture2D(u_texture, v_texCoords);\n}\n");
        }
        Draw.flush();
        boolean bl = doUpdate = Core.graphics.getFrameId() % 2L == 0L;
        if (doUpdate) {
            Vars.renderer.blocks.floor.checkChanges(!Vars.editor.showTerrain);
        }
        boolean prev = Vars.renderer.animateWater;
        Vars.renderer.animateWater = false;
        Tmp.m4.set(Draw.trans());
        Draw.trans().idt();
        Tmp.v3.set(Core.camera.position);
        Core.camera.position.set((float)Vars.world.width() / 2.0f * 8.0f, (float)Vars.world.height() / 2.0f * 8.0f);
        Core.camera.width = 999999.0f;
        Core.camera.height = 999999.0f;
        Core.camera.mat.set(Draw.proj()).mul(Tmp.m3.setToTranslation(tx, ty).scale(tw / (float)(this.width * 8), th / (float)(this.height * 8)).translate(4.0f, 4.0f));
        if (Vars.editor.showFloor) {
            Vars.renderer.blocks.floor.drawFloor();
        }
        Tmp.m2.set(Draw.proj());
        Gl.disable(3089);
        if (doUpdate) {
            Vars.renderer.blocks.processShadows(!Vars.editor.showBuildings, !Vars.editor.showTerrain);
        }
        Gl.enable(3089);
        Draw.proj(Core.camera.mat);
        Draw.shader(Shaders.darkness);
        Draw.rect(Draw.wrap((Texture)Vars.renderer.blocks.getShadowBuffer().getTexture()), (float)(Vars.world.width() * 8) / 2.0f - 4.0f, (float)(Vars.world.height() * 8) / 2.0f - 4.0f, (float)(Vars.world.width() * 8), (float)(-Vars.world.height() * 8));
        Draw.shader();
        Draw.proj(Tmp.m2);
        Vars.renderer.blocks.floor.beginDraw();
        if (Vars.editor.showTerrain) {
            Vars.renderer.blocks.floor.drawLayer(CacheLayer.walls);
        }
        Vars.renderer.animateWater = prev;
        if (this.chunks == null) {
            return;
        }
        if (doUpdate) {
            this.recacheChunks.each(i -> this.recacheChunk(Point2.x(i), Point2.y(i)));
            this.recacheChunks.clear();
        }
        if (Vars.editor.showBuildings) {
            this.shader.bind();
            this.shader.setUniformMatrix4("u_projTrans", Tmp.m1.set(Core.camera.mat).translate(-80.0f, -80.0f).scale(this.packWidth, this.packHeight));
            for (int x = 0; x < this.chunks.length; ++x) {
                for (int y = 0; y < this.chunks[0].length; ++y) {
                    EditorSpriteCache mesh = this.chunks[x][y];
                    if (mesh == null) continue;
                    mesh.render(this.shader);
                }
            }
        }
        Core.camera.position.set(Tmp.v3);
        Draw.trans(Tmp.m4);
    }

    void updateStatic(int x, int y) {
        Vars.renderer.blocks.floor.recacheTile(x, y);
        if (x > 0) {
            Vars.renderer.blocks.floor.recacheTile(x - 1, y);
        }
        if (y > 0) {
            Vars.renderer.blocks.floor.recacheTile(x, y - 1);
        }
        if (x < Vars.world.width() - 1) {
            Vars.renderer.blocks.floor.recacheTile(x + 1, y);
        }
        if (y < Vars.world.height() - 1) {
            Vars.renderer.blocks.floor.recacheTile(x, y + 1);
        }
    }

    void updateBlock(Tile tile) {
        this.updateBlock(tile.x, tile.y);
        Vars.renderer.blocks.updateShadowTile(tile);
    }

    void updateBlock(int x, int y) {
        this.recacheChunks.add(Point2.pack(x / 60, y / 60));
    }

    void recache() {
        Vars.renderer.blocks.floor.reload(!Vars.editor.showTerrain);
        Vars.renderer.blocks.reload();
        for (int x = 0; x < this.chunks.length; ++x) {
            for (int y = 0; y < this.chunks[0].length; ++y) {
                this.recacheChunk(x, y);
            }
        }
        if (!Vars.editor.showBuildings || !Vars.editor.showTerrain) {
            this.recacheShadows();
        }
    }

    void recacheTerrain() {
        Vars.renderer.blocks.floor.reload(!Vars.editor.showTerrain);
        Vars.renderer.blocks.reload();
        this.recacheShadows();
    }

    void recacheShadows() {
        Vars.renderer.blocks.updateShadows(!Vars.editor.showBuildings, !Vars.editor.showTerrain);
    }

    void recacheChunk(int cx, int cy) {
        if (this.chunks[cx][cy] != null) {
            this.chunks[cx][cy].dispose();
            this.chunks[cx][cy] = null;
        }
        EditorSpriteCache cache = new EditorSpriteCache(Vars.renderer.blocks.floor.getVertexBuffer(), 80.0f, 80.0f, this.packWidth, this.packHeight);
        TextureAtlas.AtlasRegion teamRegion = Core.atlas.find("block-border");
        tmpTiles.clear();
        for (int x = cx * 60; x < (cx + 1) * 60; ++x) {
            for (int y = cy * 60; y < (cy + 1) * 60; ++y) {
                Tile tile = Vars.world.tile(x, y);
                if (tile == null || tile.block() == Blocks.air || tile.block().cacheLayer != CacheLayer.normal || !tile.isCenter()) continue;
                tmpTiles.add(tile);
            }
        }
        tmpTiles.sort(Structs.comparingBool(b -> !b.block().synthetic()));
        for (Tile tile : tmpTiles) {
            short x = tile.x;
            short y = tile.y;
            Block block = tile.block();
            TextureRegion region = block.fullIcon;
            float width = (float)region.width * region.scl();
            float height = (float)region.height * region.scl();
            cache.draw(block.fullIcon, (float)(x * 8) + block.offset - width / 2.0f, (float)(y * 8) + block.offset - height / 2.0f, width / 2.0f, height / 2.0f, width, height, tile.build == null || !block.rotate || !block.rotateDrawEditor ? 0.0f : tile.build.rotdeg(), Color.whiteFloatBits);
            if (tile.build == null) continue;
            cache.draw(teamRegion, (float)(x * 8) + block.offset - width / 2.0f, (float)(y * 8) + block.offset - height / 2.0f, 0.0f, 0.0f, (float)teamRegion.width * teamRegion.scl(), (float)teamRegion.height * teamRegion.scl(), 0.0f, tile.build.team.color.toFloatBits());
        }
        tmpTiles.clear();
        if (!cache.isEmpty()) {
            cache.build(Vars.renderer.blocks.floor.getIndexData());
            this.chunks[cx][cy] = cache;
        }
    }

    @Override
    public void dispose() {
        if (this.chunks == null) {
            return;
        }
        for (int x = 0; x < this.chunks.length; ++x) {
            for (int y = 0; y < this.chunks[0].length; ++y) {
                if (this.chunks[x][y] == null) continue;
                this.chunks[x][y].dispose();
            }
        }
    }
}

