/*
 * Decompiled with CFR 0.152.
 */
package com.codedisaster.steamworks;

import com.codedisaster.steamworks.SteamException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.UUID;

class SteamSharedLibraryLoader {
    private static final PLATFORM OS;
    private static final boolean IS_64_BIT;

    SteamSharedLibraryLoader() {
    }

    private static String getPlatformLibName(String libName, boolean use64) {
        switch (OS) {
            case Windows: {
                return libName + (IS_64_BIT && use64 ? "64" : "") + ".dll";
            }
            case Linux: {
                return "lib" + libName + ".so";
            }
            case MacOS: {
                return "lib" + libName + ".dylib";
            }
        }
        throw new RuntimeException("Unknown host architecture");
    }

    static void loadLibrary(String ... libraryNames) throws SteamException {
        Throwable firstException = null;
        for (File file : SteamSharedLibraryLoader.extractLocations("steamworks4j_1.0-Anuken", "out")) {
            try {
                SteamSharedLibraryLoader.canWrite(file);
                SteamSharedLibraryLoader.loadAllLibraries(file, libraryNames);
                return;
            }
            catch (Throwable t) {
                if (firstException != null) {
                    firstException.addSuppressed(t);
                    continue;
                }
                firstException = t;
            }
        }
        try {
            for (String name : libraryNames) {
                System.load(new File(SteamSharedLibraryLoader.getPlatformLibName(name, true)).getCanonicalPath());
            }
            return;
        }
        catch (Throwable t) {
            if (firstException != null) {
                firstException.addSuppressed(t);
            } else {
                firstException = t;
            }
            throw new SteamException(firstException);
        }
    }

    private static void loadAllLibraries(File file, String ... libraryNames) throws Throwable {
        for (String lib : libraryNames) {
            String libFilename = SteamSharedLibraryLoader.getPlatformLibName(lib, true);
            File libFile = new File(file.getParentFile(), libFilename);
            SteamSharedLibraryLoader.extractLibrary(libFile, libFilename);
            System.load(libFile.getCanonicalPath());
        }
    }

    private static File[] extractLocations(String folderName, String fileName) {
        ArrayList<File> out = new ArrayList<File>();
        out.add(new File(System.getProperty("java.io.tmpdir") + "/" + folderName, fileName));
        try {
            File file = File.createTempFile(folderName, null);
            if (file.delete()) {
                out.add(new File(file, fileName));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        out.add(new File(System.getProperty("user.home") + "/." + folderName, fileName));
        out.add(new File(".tmp/" + folderName, fileName));
        return out.toArray(new File[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractLibrary(File destination, String fileName) throws IOException {
        block21: {
            InputStream input = SteamSharedLibraryLoader.class.getResourceAsStream("/" + fileName);
            if (input != null) {
                try (FileOutputStream output = new FileOutputStream(destination);){
                    byte[] buffer = new byte[4096];
                    while (true) {
                        int length;
                        if ((length = input.read(buffer)) == -1) {
                            break block21;
                        }
                        output.write(buffer, 0, length);
                    }
                }
                catch (IOException e) {
                    if (!destination.exists()) {
                        throw e;
                    }
                    break block21;
                }
                finally {
                    input.close();
                }
            }
            throw new IOException("Failed to read input stream for " + destination.getCanonicalPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canWrite(File file) {
        boolean bl;
        File folder = file.getParentFile();
        if (file.exists()) {
            if (!file.canWrite() || !SteamSharedLibraryLoader.canExecute(file)) {
                return false;
            }
        } else {
            if (!folder.exists() && !folder.mkdirs()) {
                return false;
            }
            if (!folder.isDirectory()) {
                return false;
            }
        }
        File testFile = new File(folder, UUID.randomUUID().toString());
        try {
            new FileOutputStream(testFile).close();
            bl = SteamSharedLibraryLoader.canExecute(testFile);
            testFile.delete();
        }
        catch (IOException e) {
            boolean bl2;
            try {
                bl2 = false;
                testFile.delete();
            }
            catch (Throwable throwable) {
                try {
                    testFile.delete();
                    throw throwable;
                }
                catch (Throwable t) {
                    return false;
                }
            }
            return bl2;
        }
        return bl;
    }

    private static boolean canExecute(File file) {
        try {
            if (file.canExecute()) {
                return true;
            }
            if (file.setExecutable(true)) {
                return file.canExecute();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    static {
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        if (osName.contains("Windows")) {
            OS = PLATFORM.Windows;
        } else if (osName.contains("Linux")) {
            OS = PLATFORM.Linux;
        } else if (osName.contains("Mac")) {
            OS = PLATFORM.MacOS;
        } else {
            throw new RuntimeException("Unknown host architecture: " + osName + ", " + osArch);
        }
        IS_64_BIT = osArch.equals("amd64") || osArch.equals("x86_64");
    }

    static enum PLATFORM {
        Windows,
        Linux,
        MacOS;

    }
}

