/*
 * Decompiled with CFR 0.152.
 */
package arc.profiling;

import arc.graphics.GL20;
import arc.math.FloatCounter;
import arc.profiling.GLProfiler;

public abstract class GLInterceptor
implements GL20 {
    public final FloatCounter vertexCount = new FloatCounter(0);
    public int calls;
    public int textureBindings;
    public int drawCalls;
    public int shaderSwitches;
    public int stateChanges;
    protected GLProfiler glProfiler;

    protected GLInterceptor(GLProfiler profiler) {
        this.glProfiler = profiler;
    }

    public static String resolveErrorNumber(int error) {
        switch (error) {
            case 1281: {
                return "GL_INVALID_VALUE";
            }
            case 1282: {
                return "GL_INVALID_OPERATION";
            }
            case 1286: {
                return "GL_INVALID_FRAMEBUFFER_OPERATION";
            }
            case 1280: {
                return "GL_INVALID_ENUM";
            }
            case 1285: {
                return "GL_OUT_OF_MEMORY";
            }
        }
        return "number " + error;
    }

    public void reset() {
        this.calls = 0;
        this.textureBindings = 0;
        this.drawCalls = 0;
        this.shaderSwitches = 0;
        this.stateChanges = 0;
        this.vertexCount.reset();
    }
}

