/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.g2d;

import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.Pixmaps;

public class PixmapRegion {
    public Pixmap pixmap;
    public int x;
    public int y;
    public int width;
    public int height;

    public PixmapRegion(Pixmap pixmap, int x, int y, int width, int height) {
        this.set(pixmap, x, y, width, height);
    }

    public PixmapRegion(Pixmap pixmap) {
        this.set(pixmap);
    }

    public int get(int x, int y) {
        return this.pixmap.get(this.x + x, this.y + y);
    }

    public int getRaw(int x, int y) {
        return this.pixmap.getRaw(this.x + x, this.y + y);
    }

    public int getA(int x, int y) {
        return this.pixmap.getA(this.x + x, this.y + y);
    }

    public int get(int x, int y, Color color) {
        int c = this.get(x, y);
        color.set(c);
        return c;
    }

    public PixmapRegion set(Pixmap pixmap) {
        return this.set(pixmap, 0, 0, pixmap.width, pixmap.height);
    }

    public PixmapRegion set(Pixmap pixmap, int x, int y, int width, int height) {
        this.pixmap = pixmap;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        return this;
    }

    public Pixmap crop() {
        return Pixmaps.crop(this.pixmap, this.x, this.y, this.width, this.height);
    }

    public Pixmap crop(int x, int y, int width, int height) {
        return Pixmaps.crop(this.pixmap, this.x + x, this.y + y, width, height);
    }
}

