/*
 * Decompiled with CFR 0.152.
 */
package rhino;

import java.util.HashSet;
import java.util.Set;
import rhino.ClassShutter;
import rhino.Context;
import rhino.Kit;
import rhino.ScriptRuntime;
import rhino.Scriptable;
import rhino.ScriptableObject;
import rhino.WrapFactory;

public class NativeJavaPackage
extends ScriptableObject {
    private final String packageName;
    private transient ClassLoader classLoader;
    private Set<String> negativeCache = null;

    public NativeJavaPackage(String packageName, ClassLoader classLoader) {
        this.packageName = packageName;
        this.classLoader = classLoader;
    }

    @Deprecated
    public NativeJavaPackage(boolean completelyPointless, String packageName, ClassLoader classLoader) {
        this(packageName, classLoader);
    }

    @Override
    public String getClassName() {
        return "JavaPackage";
    }

    @Override
    public boolean has(String id, Scriptable start) {
        return true;
    }

    @Override
    public boolean has(int index, Scriptable start) {
        return false;
    }

    @Override
    public void put(String id, Scriptable start, Object value) {
    }

    @Override
    public void put(int index, Scriptable start, Object value) {
        throw Context.reportRuntimeError0("msg.pkg.int");
    }

    @Override
    public Object get(String id, Scriptable start) {
        return this.getPkgProperty(id, start, true);
    }

    @Override
    public Object get(int index, Scriptable start) {
        return NOT_FOUND;
    }

    NativeJavaPackage forcePackage(String name, Scriptable scope) {
        Object cached = super.get(name, (Scriptable)this);
        if (cached != null && cached instanceof NativeJavaPackage) {
            return (NativeJavaPackage)cached;
        }
        String newPackage = this.packageName.length() == 0 ? name : this.packageName + "." + name;
        NativeJavaPackage pkg = new NativeJavaPackage(newPackage, this.classLoader);
        ScriptRuntime.setObjectProtoAndParent(pkg, scope);
        super.put(name, (Scriptable)this, (Object)pkg);
        return pkg;
    }

    synchronized Object getPkgProperty(String name, Scriptable start, boolean createPkg) {
        Class<?> cl;
        Object cached = super.get(name, start);
        if (cached != NOT_FOUND) {
            return cached;
        }
        if (this.negativeCache != null && this.negativeCache.contains(name)) {
            return null;
        }
        String className = this.packageName.length() == 0 ? name : this.packageName + '.' + name;
        Context cx = Context.getContext();
        ClassShutter shutter = cx.getClassShutter();
        Scriptable newValue = null;
        if ((shutter == null || shutter.visibleToScripts(className)) && (cl = this.classLoader != null ? Kit.classOrNull(this.classLoader, className) : Kit.classOrNull(className)) != null) {
            WrapFactory wrapFactory = cx.getWrapFactory();
            newValue = wrapFactory.wrapJavaClass(cx, NativeJavaPackage.getTopLevelScope(this), cl);
            newValue.setPrototype(this.getPrototype());
        }
        if (newValue == null) {
            if (createPkg) {
                NativeJavaPackage pkg = new NativeJavaPackage(className, this.classLoader);
                ScriptRuntime.setObjectProtoAndParent(pkg, this.getParentScope());
                newValue = pkg;
            } else {
                if (this.negativeCache == null) {
                    this.negativeCache = new HashSet<String>();
                }
                this.negativeCache.add(name);
            }
        }
        if (newValue != null) {
            super.put(name, start, newValue);
        }
        return newValue;
    }

    @Override
    public Object getDefaultValue(Class<?> ignored) {
        return this.toString();
    }

    public String toString() {
        return "[JavaPackage " + this.packageName + "]";
    }

    public boolean equals(Object obj) {
        if (obj instanceof NativeJavaPackage) {
            NativeJavaPackage njp = (NativeJavaPackage)obj;
            return this.packageName.equals(njp.packageName) && this.classLoader == njp.classLoader;
        }
        return false;
    }

    public int hashCode() {
        return this.packageName.hashCode() ^ (this.classLoader == null ? 0 : this.classLoader.hashCode());
    }
}

