/*
 * Decompiled with CFR 0.152.
 */
package mindustry.mod;

import arc.func.Cons;
import arc.func.Prov;
import arc.struct.ObjectFloatMap;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.struct.OrderedMap;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Reflect;
import arc.util.Strings;
import arc.util.serialization.Json;
import arc.util.serialization.JsonValue;
import arc.util.serialization.Jval;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Locale;
import mindustry.Vars;
import mindustry.core.ContentLoader;
import mindustry.ctype.Content;
import mindustry.ctype.ContentType;
import mindustry.ctype.MappableContent;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.part.DrawPart;
import mindustry.mod.ContentParser;
import mindustry.mod.NoPatch;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import mindustry.world.Block;
import mindustry.world.blocks.Attributes;
import mindustry.world.draw.DrawBlock;
import mindustry.world.meta.Attribute;

public class ContentPatcher {
    private static final Object root = new Object();
    private static final ObjectMap<String, ContentType> nameToType = new ObjectMap();
    private static ContentParser parser = ContentPatcher.createParser();
    private boolean applied;
    private ContentLoader contentLoader;
    private ObjectSet<Object> usedpatches = new ObjectSet();
    private Seq<Runnable> resetters = new Seq();
    private Seq<Runnable> afterCallbacks = new Seq();
    @Nullable
    private PatchSet currentlyApplying;
    public Seq<PatchSet> patches = new Seq();

    static ContentParser createParser() {
        ContentParser cont = new ContentParser(){

            @Override
            void warn(String string, Object ... format) {
                if (Vars.state.patcher != null) {
                    Vars.state.patcher.warn(string, format);
                }
            }
        };
        cont.allowClassResolution = false;
        return cont;
    }

    public void apply(Seq<String> patchArray) throws Exception {
        if (this.applied) {
            this.unapply();
            this.applied = false;
        }
        this.applied = true;
        this.contentLoader = Vars.content.copy();
        this.patches.clear();
        for (String patch : patchArray) {
            PatchSet set = new PatchSet(patch, new JsonValue("error"));
            this.patches.add(set);
            try {
                JsonValue value;
                set.json = value = (JsonValue)parser.getJson().fromJson(null, Jval.read(patch).toString(Jval.Jformat.plain));
                this.currentlyApplying = set;
                set.name = value.getString("name", "");
                value.remove("name");
                for (JsonValue child : value) {
                    this.assign(root, child.name, child, null, null, null);
                }
                this.currentlyApplying = null;
            }
            catch (Exception e) {
                set.error = true;
                set.warnings.add(Strings.getSimpleMessage(e));
                this.currentlyApplying = null;
                Log.err("Failed to apply patch: " + patch, e);
            }
        }
        this.afterCallbacks.each(Runnable::run);
    }

    public void unapply() {
        if (!this.applied) {
            return;
        }
        Vars.content = this.contentLoader;
        this.applied = false;
        this.resetters.reverse();
        for (Runnable reset : this.resetters) {
            try {
                reset.run();
            }
            catch (Throwable e) {
                Log.err("Failed to un-apply patch!", e);
            }
        }
        this.resetters.clear();
        this.afterCallbacks.each(Runnable::run);
        this.afterCallbacks.clear();
        this.usedpatches.clear();
    }

    void visit(Object object) {
        Content c;
        if (object instanceof Content && this.usedpatches.add(c = (Content)object)) {
            this.after(c::afterPatch);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void created(Object object, Object parent) {
        if (Vars.headless) {
            if (!(object instanceof Weapon)) return;
            Weapon weapon = (Weapon)object;
            weapon.init();
            return;
        }
        if (object instanceof DrawPart) {
            DrawPart part = (DrawPart)object;
            if (parent instanceof MappableContent) {
                MappableContent cont = (MappableContent)parent;
                part.load(cont.name);
                return;
            }
        }
        if (object instanceof DrawBlock) {
            DrawBlock draw = (DrawBlock)object;
            if (parent instanceof Block) {
                Block block = (Block)parent;
                draw.load(block);
                return;
            }
        }
        if (object instanceof Weapon) {
            Weapon weapon = (Weapon)object;
            weapon.load();
            weapon.init();
            return;
        }
        if (!(object instanceof Content)) return;
        Content cont = (Content)object;
        cont.load();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void assign(Object object, String field, Object value, @Nullable FieldData metadata, @Nullable Object parentObject, @Nullable String parentField) throws Exception {
        JsonValue jval;
        if (field == null) return;
        if (field.isEmpty()) {
            return;
        }
        if (field.indexOf(46) != -1) {
            String[] path = field.split("\\.");
            for (int i = 0; i < path.length - 1; ++i) {
                parentObject = object;
                parentField = path[i];
                Object[] result = this.resolve(object, path[i], metadata);
                if (result == null) {
                    this.warn("Failed to resolve @.@", object, path[i]);
                    return;
                }
                object = result[0];
                metadata = (FieldData)result[1];
                if (i >= path.length - 2) continue;
                this.visit(object);
            }
            field = path[path.length - 1];
        }
        this.visit(object);
        if (object == root) {
            if (!(value instanceof JsonValue) || !(jval = (JsonValue)value).isObject()) {
                this.warn("Content '@' cannot be assigned.", field);
                return;
            }
        } else {
            Class<?> actualType;
            if (object instanceof Seq || object.getClass().isArray()) {
                int length;
                int n;
                Seq s;
                if (field.equals("+")) {
                    boolean multiAdd;
                    JsonValue jval2;
                    FieldData meta = new FieldData(metadata.type.isArray() ? metadata.type.getComponentType() : metadata.elementType, null, null);
                    if (value instanceof JsonValue && (jval2 = (JsonValue)value).isArray()) {
                        meta = metadata;
                        multiAdd = true;
                    } else {
                        multiAdd = false;
                    }
                    if (object instanceof Seq) {
                        Seq s2 = (Seq)object;
                        this.modifiedField(parentObject, parentField, s2.copy());
                        this.assignValue(object, field, meta, () -> null, val -> {
                            if (multiAdd) {
                                s2.addAll((Seq)val);
                            } else {
                                s2.add(val);
                            }
                        }, value, false);
                        return;
                    }
                    this.modifiedField(parentObject, parentField, ContentPatcher.copyArray(object));
                    Object fobj = object;
                    Object fpo = parentObject;
                    String fpf = parentField;
                    this.assignValue(parentObject, parentField, meta, () -> null, val -> {
                        try {
                            Object copy;
                            int len = Array.getLength(fobj);
                            if (multiAdd) {
                                int otherLen = Array.getLength(val);
                                copy = Array.newInstance(fobj.getClass().getComponentType(), len + otherLen);
                                System.arraycopy(val, 0, copy, len, otherLen);
                                System.arraycopy(fobj, 0, copy, 0, len);
                            } else {
                                copy = Array.newInstance(fobj.getClass().getComponentType(), len + 1);
                                Array.set(copy, len, val);
                                System.arraycopy(fobj, 0, copy, 0, len);
                            }
                            this.assign(fpo, fpf, copy, null, null, null);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }, value, false);
                    return;
                }
                int i = Strings.parseInt(field);
                if (object instanceof Seq) {
                    s = (Seq)object;
                    n = s.size;
                } else {
                    n = length = Array.getLength(object);
                }
                if (i == Integer.MIN_VALUE) {
                    this.warn("Invalid number for array access: '@'", field);
                    return;
                }
                if (i < 0 || i >= length) {
                    this.warn("Number outside of array bounds: '" + field + "' (length is " + length + ")", new Object[0]);
                    return;
                }
                if (object instanceof Seq) {
                    s = (Seq)object;
                    Seq copy = s.copy();
                    this.reset(() -> s.set(copy));
                    this.assignValue(object, field, metadata, () -> s.get(i), val -> s.set(i, val), value, false);
                    return;
                }
                this.modifiedField(parentObject, parentField, ContentPatcher.copyArray(object));
                Object fobj = object;
                this.assignValue(object, field, metadata, () -> Array.get(fobj, i), val -> Array.set(fobj, i, val), value, false);
                return;
            }
            if (object instanceof ObjectSet) {
                ObjectSet set = (ObjectSet)object;
                if (field.equals("+")) {
                    boolean multiAdd;
                    JsonValue jval3;
                    this.modifiedField(parentObject, parentField, set.copy());
                    FieldData meta = new FieldData(metadata.elementType, null, null);
                    if (value instanceof JsonValue && (jval3 = (JsonValue)value).isArray()) {
                        meta = metadata;
                        multiAdd = true;
                    } else {
                        multiAdd = false;
                    }
                    this.assignValue(object, field, multiAdd ? meta : metadata, () -> null, val -> {
                        if (multiAdd) {
                            set.addAll((ObjectSet)val);
                        } else {
                            set.add(val);
                        }
                    }, value, false);
                    return;
                }
            }
            if (object instanceof ObjectMap) {
                JsonValue jval4;
                ObjectMap map = (ObjectMap)object;
                if (metadata == null) {
                    this.warn("ObjectMap cannot be parsed without metadata: @.@", parentObject, parentField);
                    return;
                }
                Object key = this.convertKeyType(field, metadata.keyType);
                if (key == null) {
                    this.warn("Null key: '@'", field);
                    return;
                }
                ObjectMap copy = map.copy();
                this.reset(() -> map.set(copy));
                if (value instanceof JsonValue && (jval4 = (JsonValue)value).isString() && jval4.asString().equals("-")) {
                    map.remove(key);
                    return;
                }
                this.assignValue(object, field, new FieldData(metadata.elementType, null, null), () -> map.get(key), val -> map.put(key, val), value, false);
                return;
            }
            if (object instanceof ObjectFloatMap) {
                JsonValue jval5;
                ObjectFloatMap map = (ObjectFloatMap)object;
                if (metadata == null) {
                    this.warn("ObjectFloatMap cannot be parsed without metadata: @.@", parentObject, parentField);
                    return;
                }
                Object key = this.convertKeyType(field, metadata.elementType);
                if (key == null) {
                    this.warn("Null key: '@'", field);
                    return;
                }
                ObjectFloatMap copy = map.copy();
                this.reset(() -> map.set(copy));
                if (value instanceof JsonValue && (jval5 = (JsonValue)value).isString() && jval5.asString().equals("-")) {
                    map.remove(key, 0.0f);
                    return;
                }
                this.assignValue(object, field, new FieldData(Float.TYPE, null, null), () -> Float.valueOf(map.get(key, 0.0f)), val -> map.put(key, ((Float)val).floatValue()), value, false);
                return;
            }
            if (object instanceof Attributes) {
                Attributes map = (Attributes)object;
                if (value instanceof JsonValue) {
                    JsonValue jval6 = (JsonValue)value;
                    Attribute key = Attribute.getOrNull(field);
                    if (key == null) {
                        this.warn("Unknown attribute: '@'", field);
                        return;
                    }
                    if (!jval6.isNumber()) {
                        this.warn("Attribute value must be a number: '@'", jval6);
                        return;
                    }
                    float prev = map.get(key);
                    this.reset(() -> map.set(key, prev));
                    map.set(key, jval6.asFloat());
                    return;
                }
            }
            if ((actualType = object.getClass()).isAnonymousClass()) {
                actualType = actualType.getSuperclass();
            }
            OrderedMap<String, Json.FieldMetadata> fields = parser.getJson().getFields(actualType);
            Json.FieldMetadata fdata = (Json.FieldMetadata)fields.get(field);
            Object fobj = object;
            if (fdata != null) {
                if (this.checkField(fdata.field)) {
                    return;
                }
                this.assignValue(object, field, new FieldData(fdata), () -> Reflect.get(fobj, fdata.field), fv -> {
                    if (!(fv != null || fdata.field.isAnnotationPresent(Nullable.class) || Vars.headless && ContentParser.implicitNullable.contains(fdata.field.getType()))) {
                        this.warn("Field '@' cannot be null.", fdata.field);
                        return;
                    }
                    Reflect.set(fobj, fdata.field, fv);
                }, value, true);
                return;
            }
            if (value instanceof JsonValue) {
                JsonValue jsv = (JsonValue)value;
                if (object instanceof Block) {
                    Block bl = (Block)object;
                    if (jsv.isObject() && field.equals("consumes")) {
                        this.modifiedField(bl, "consumeBuilder", ((Seq)Reflect.get(Block.class, bl, "consumeBuilder")).copy());
                        this.modifiedField(bl, "consumers", Reflect.get(Block.class, bl, "consumers"));
                        boolean hadItems = bl.hasItems;
                        boolean hadLiquids = bl.hasLiquids;
                        boolean hadPower = bl.hasPower;
                        boolean acceptedItems = bl.acceptsItems;
                        this.reset(() -> {
                            bl.reinitializeConsumers();
                            bl.hasItems = hadItems;
                            bl.hasLiquids = hadLiquids;
                            bl.hasPower = hadPower;
                            bl.acceptsItems = acceptedItems;
                        });
                        try {
                            parser.readBlockConsumers(bl, jsv);
                            bl.reinitializeConsumers();
                            return;
                        }
                        catch (Throwable e) {
                            Log.err(e);
                            this.warn("Failed to read consumers for '@': @", bl, Strings.getSimpleMessage(e));
                            return;
                        }
                    }
                }
            }
            if (value instanceof JsonValue) {
                JsonValue jsv = (JsonValue)value;
                if (object instanceof UnitType && field.equals("type")) {
                    Json.FieldMetadata fmeta = (Json.FieldMetadata)fields.get("constructor");
                    this.assignValue(object, "constructor", new FieldData(fmeta), () -> Reflect.get(fobj, fmeta.field), val -> Reflect.set(fobj, fmeta.field, val), parser.unitType(jsv), true);
                    return;
                }
            }
            this.warn("Unknown field '@' for class '@'", field, actualType.getSimpleName());
            return;
        }
        JsonValue.JsonIterator jsonIterator = jval.iterator();
        while (jsonIterator.hasNext()) {
            ObjectMap map;
            Object object2;
            JsonValue child = (JsonValue)jsonIterator.next();
            Object[] otherResolve = this.resolve(object, jval.name, null);
            if (otherResolve != null && (object2 = otherResolve[0]) instanceof ObjectMap && (map = (ObjectMap)object2).containsKey(child.name)) {
                this.assign(otherResolve[0], child.name, child, (FieldData)otherResolve[1], object, field);
                continue;
            }
            Log.warn("Content not found: @.@", field, child.name);
        }
    }

    void assignValue(Object object, String field, FieldData metadata, Prov getter, Cons setter, Object value, boolean modify) throws Exception {
        block10: {
            Object prevValue = getter.get();
            try {
                if (value instanceof JsonValue) {
                    JsonValue jsv = (JsonValue)value;
                    if (prevValue == null || !jsv.isObject() || jsv.has("type") && metadata.type != MappableContent.class || metadata != null && metadata.type == Attributes.class) {
                        if (UnlockableContent.class.isAssignableFrom(metadata.type) && jsv.isObject()) {
                            this.warn("New content must not be instantiated: @", jsv);
                            return;
                        }
                        if (modify) {
                            this.modifiedField(object, field, getter.get());
                        }
                        ContentPatcher.parser.listeners.add((type, jsonData, result) -> this.created(result, object));
                        try {
                            setter.get(parser.getJson().readValue(metadata.type, metadata.elementType, jsv));
                        }
                        catch (Throwable e) {
                            this.warn("Failed to read value @.@ = @: (type = @ elementType = @)\n@", object, field, value, metadata.type, metadata.elementType, Strings.getSimpleMessages(e));
                        }
                        ContentPatcher.parser.listeners.pop();
                        break block10;
                    }
                    OrderedMap<String, Json.FieldMetadata> childFields = parser.getJson().getFields(prevValue.getClass().isAnonymousClass() ? prevValue.getClass().getSuperclass() : prevValue.getClass());
                    for (JsonValue child : jsv) {
                        if (child.name == null) continue;
                        this.assign(prevValue, child.name, child, (FieldData)(metadata != null && (metadata.type == ObjectMap.class || metadata.type == ObjectFloatMap.class) ? metadata : (metadata != null && metadata.type == Seq.class ? new FieldData(metadata.elementType, null, null) : (metadata != null && metadata.type.isArray() ? new FieldData(metadata.type.getComponentType(), null, null) : (!childFields.containsKey(child.name) ? null : new FieldData((Json.FieldMetadata)childFields.get(child.name)))))), object, field);
                    }
                    break block10;
                }
                if (modify) {
                    this.modifiedField(object, field, prevValue);
                }
                setter.get(value);
            }
            catch (Throwable e) {
                this.warn("Failed to assign @.@ = @: @", object, field, value, Strings.getStackTrace(e));
            }
        }
    }

    Object[] resolve(Object object, String field, @Nullable FieldData metadata) throws Exception {
        OrderedMap<String, Json.FieldMetadata> fields;
        Json.FieldMetadata fdata;
        if (object == null) {
            return null;
        }
        if (object == root) {
            ContentType ctype = nameToType.get(field);
            if (ctype == null) {
                this.warn("Invalid content type: " + field, new Object[0]);
                return null;
            }
            return new Object[]{Vars.content.getNamesBy(ctype), new FieldData(ObjectMap.class, MappableContent.class, String.class)};
        }
        if (object instanceof Seq || object.getClass().isArray()) {
            Object object2;
            int length;
            int n;
            Seq s;
            int i = Strings.parseInt(field);
            if (object instanceof Seq) {
                s = (Seq)object;
                n = s.size;
            } else {
                n = length = Array.getLength(object);
            }
            if (i == Integer.MIN_VALUE) {
                this.warn("Invalid number for array access: '@'", field);
                return null;
            }
            if (i < 0 || i >= length) {
                this.warn("Number outside of array bounds: '" + field + "' (length is " + length + ")", new Object[0]);
                return null;
            }
            Object[] objectArray = new Object[2];
            if (object instanceof Seq) {
                s = (Seq)object;
                object2 = s.get(i);
            } else {
                object2 = Array.get(object, i);
            }
            objectArray[0] = object2;
            objectArray[1] = null;
            return objectArray;
        }
        if (object instanceof ObjectMap) {
            ObjectMap map = (ObjectMap)object;
            Object key = this.convertKeyType(field, metadata.keyType);
            if (key == null) {
                this.warn("Null key: '@'", field);
                return null;
            }
            Object mapValue = map.get(key);
            if (mapValue == null) {
                this.warn("No key found: '@'", field);
                return null;
            }
            return new Object[]{mapValue, null};
        }
        Class<?> actualType = object.getClass();
        if (actualType.isAnonymousClass()) {
            actualType = actualType.getSuperclass();
        }
        if ((fdata = (Json.FieldMetadata)(fields = parser.getJson().getFields(actualType)).get(field)) != null) {
            if (this.checkField(fdata.field)) {
                return null;
            }
            return new Object[]{fdata.field.get(object), new FieldData(fdata)};
        }
        this.warn("Unknown field: '@' for '@'", field, actualType.getName());
        return null;
    }

    boolean checkField(Field field) {
        if (field.isAnnotationPresent(NoPatch.class) || field.getDeclaringClass().isAnnotationPresent(NoPatch.class)) {
            this.warn("Field '@' cannot be edited.", field);
            return true;
        }
        return false;
    }

    void modifiedField(Object target, String field, Object value) {
        if (!this.applied || target == null) {
            return;
        }
        OrderedMap<String, Json.FieldMetadata> fields = parser.getJson().getFields(target.getClass());
        Json.FieldMetadata meta = (Json.FieldMetadata)fields.get(field);
        if (meta != null) {
            PatchRecord record = new PatchRecord(target, meta.field, value);
            if (this.usedpatches.add(record)) {
                this.resetters.add(() -> {
                    try {
                        record.field.set(record.target, record.value);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        } else {
            this.warn("Missing field " + field + " for object " + target, new Object[0]);
        }
    }

    void reset(Runnable run) {
        this.resetters.add(run);
    }

    Object convertKeyType(String string, Class<?> type) {
        return parser.getJson().fromJson(type, string);
    }

    void warn(String error, Object ... fmt) {
        String formatted = Strings.format(error, fmt);
        if (this.currentlyApplying != null) {
            this.currentlyApplying.warnings.add(formatted);
        }
        Log.warn("[ContentPatcher] " + formatted, new Object[0]);
    }

    void after(Runnable run) {
        this.afterCallbacks.add(run);
    }

    static Object copyArray(Object object) {
        if (object instanceof int[]) {
            int[] i = (int[])object;
            return i.clone();
        }
        if (object instanceof long[]) {
            long[] i = (long[])object;
            return i.clone();
        }
        if (object instanceof short[]) {
            short[] i = (short[])object;
            return i.clone();
        }
        if (object instanceof byte[]) {
            byte[] i = (byte[])object;
            return i.clone();
        }
        if (object instanceof boolean[]) {
            boolean[] i = (boolean[])object;
            return i.clone();
        }
        if (object instanceof char[]) {
            char[] i = (char[])object;
            return i.clone();
        }
        if (object instanceof float[]) {
            float[] i = (float[])object;
            return i.clone();
        }
        if (object instanceof double[]) {
            double[] i = (double[])object;
            return i.clone();
        }
        return ((Object[])object).clone();
    }

    static {
        for (ContentType type : ContentType.all) {
            if (type.name().indexOf(95) != -1) continue;
            nameToType.put(type.toString().toLowerCase(Locale.ROOT), type);
        }
    }

    public static class PatchSet {
        public String patch;
        public JsonValue json;
        public String name = "";
        public boolean error;
        public Seq<String> warnings = new Seq();

        public PatchSet(String patch, JsonValue json) {
            this.patch = patch;
            this.json = json;
        }
    }

    private static class FieldData {
        Class type;
        Class elementType;
        Class keyType;

        public FieldData(Class type, Class elementType, Class keyType) {
            this.type = type;
            this.elementType = elementType;
            this.keyType = keyType;
        }

        public FieldData(Json.FieldMetadata data) {
            this(data.field.getType(), data.elementType, data.keyType);
        }

        public String toString() {
            return "FieldData{type=" + this.type + ", elementType=" + this.elementType + ", keyType=" + this.keyType + '}';
        }
    }

    private static class PatchRecord {
        Object target;
        Field field;
        Object value;

        PatchRecord(Object target, Field field, Object value) {
            this.target = target;
            this.field = field;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PatchRecord that = (PatchRecord)o;
            return this.target.equals(that.target) && this.field.equals(that.field);
        }

        public int hashCode() {
            int result = this.target.hashCode();
            result = 31 * result + this.field.hashCode();
            return result;
        }
    }
}

