/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.filters;

import arc.Core;
import arc.func.Boolc;
import arc.func.Boolf;
import arc.func.Boolp;
import arc.func.Cons;
import arc.func.Floatc;
import arc.func.Floatp;
import arc.func.Prov;
import arc.input.KeyCode;
import arc.scene.Element;
import arc.scene.event.Touchable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Button;
import arc.scene.ui.CheckBox;
import arc.scene.ui.Label;
import arc.scene.ui.Slider;
import arc.scene.ui.layout.Table;
import arc.util.Strings;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.gen.Icon;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.Block;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.OverlayFloor;

public abstract class FilterOption {
    public static final Boolf<Block> floorsOnly = b -> b instanceof Floor && !(b instanceof OverlayFloor) && !Vars.headless && Core.atlas.isFound(b.fullIcon);
    public static final Boolf<Block> wallsOnly = b -> !b.synthetic() && !(b instanceof Floor) && !Vars.headless && Core.atlas.isFound(b.fullIcon) && b.inEditor;
    public static final Boolf<Block> floorsOptional = b -> b == Blocks.air || b instanceof Floor && !(b instanceof OverlayFloor) && !Vars.headless && Core.atlas.isFound(b.fullIcon);
    public static final Boolf<Block> wallsOptional = b -> (b == Blocks.air || !b.synthetic() && !(b instanceof Floor) && !Vars.headless && Core.atlas.isFound(b.fullIcon)) && b.inEditor;
    public static final Boolf<Block> wallsOresOptional = b -> b == Blocks.air || (!b.synthetic() && !(b instanceof Floor) || b instanceof OverlayFloor) && !Vars.headless && Core.atlas.isFound(b.fullIcon) && b.inEditor;
    public static final Boolf<Block> oresOnly = b -> b instanceof OverlayFloor && !Vars.headless && Core.atlas.isFound(b.fullIcon);
    public static final Boolf<Block> oresFloorsOptional = b -> b instanceof Floor && !Vars.headless && Core.atlas.isFound(b.fullIcon);
    public static final Boolf<Block> anyOptional = b -> (floorsOnly.get((Block)b) || wallsOnly.get((Block)b) || oresOnly.get((Block)b) || b == Blocks.air) && b.inEditor;
    public Runnable changed = () -> {};

    public abstract void build(Table var1);

    static class ToggleOption
    extends FilterOption {
        final String name;
        final Boolp getter;
        final Boolc setter;

        ToggleOption(String name, Boolp getter, Boolc setter) {
            this.name = name;
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public void build(Table table) {
            table.row();
            CheckBox check = table.check("@filter.option." + this.name, this.setter).growX().padBottom(5.0f).padTop(5.0f).center().get();
            check.setChecked(this.getter.get());
            check.changed(this.changed);
        }
    }

    static class BlockOption
    extends FilterOption {
        final String name;
        final Prov<Block> supplier;
        final Cons<Block> consumer;
        final Boolf<Block> filter;

        BlockOption(String name, Prov<Block> supplier, Cons<Block> consumer, Boolf<Block> filter) {
            this.name = name;
            this.supplier = supplier;
            this.consumer = consumer;
            this.filter = filter;
        }

        @Override
        public void build(Table table) {
            Button button = table.button(b -> b.image(this.supplier.get().uiIcon).update(i -> ((TextureRegionDrawable)i.getDrawable()).setRegion(this.supplier.get() == Blocks.air ? Icon.none.getRegion() : this.supplier.get().uiIcon)).size(24.0f), () -> {
                BaseDialog dialog = new BaseDialog("@filter.option." + this.name);
                dialog.cont.pane(t -> {
                    int i = 0;
                    for (Block block : Vars.content.blocks()) {
                        if (!this.filter.get(block)) continue;
                        t.image(block == Blocks.air ? Icon.none.getRegion() : block.uiIcon).size(32.0f).pad(3.0f).tooltip(block == Blocks.air ? "@none" : block.localizedName).get().clicked(() -> {
                            this.consumer.get(block);
                            dialog.hide();
                            this.changed.run();
                        });
                        if (++i % 10 != 0) continue;
                        t.row();
                    }
                    dialog.setFillParent(i > 100);
                }).scrollX(false);
                dialog.addCloseButton();
                dialog.show();
            }).pad(4.0f).margin(12.0f).get();
            button.clicked(KeyCode.mouseMiddle, () -> {
                Core.app.setClipboardText(this.supplier.get().name);
                Vars.ui.showInfoFade("@copied");
            });
            button.clicked(KeyCode.mouseRight, () -> {
                if (Vars.content.block(Core.app.getClipboardText()) != null && this.filter.get(Vars.content.block(Core.app.getClipboardText()))) {
                    this.consumer.get(Vars.content.block(Core.app.getClipboardText()));
                    this.changed.run();
                }
            });
            table.add("@filter.option." + this.name);
        }
    }

    static class SliderOption
    extends FilterOption {
        final String name;
        final Floatp getter;
        final Floatc setter;
        final float min;
        final float max;
        final float step;
        boolean display = true;

        SliderOption(String name, Floatp getter, Floatc setter, float min, float max) {
            this(name, getter, setter, min, max, (max - min) / 200.0f);
        }

        SliderOption(String name, Floatp getter, Floatc setter, float min, float max, float step) {
            this.name = name;
            this.getter = getter;
            this.setter = setter;
            this.min = min;
            this.max = max;
            this.step = step;
        }

        public SliderOption display() {
            this.display = true;
            return this;
        }

        @Override
        public void build(Table table) {
            Element base;
            if (!this.display) {
                Label l = new Label("@filter.option." + this.name);
                l.setWrap(true);
                l.setStyle(Styles.outlineLabel);
                base = l;
            } else {
                Table t;
                base = t = new Table().marginLeft(11.0f).marginRight(11.0f);
                t.add("@filter.option." + this.name).growX().wrap().style(Styles.outlineLabel);
                t.label(() -> Strings.autoFixed(this.getter.get(), 2)).style(Styles.outlineLabel).right().labelAlign(16).padLeft(6.0f);
            }
            base.touchable = Touchable.disabled;
            Slider slider = new Slider(this.min, this.max, this.step, false);
            slider.moved(this.setter);
            slider.setValue(this.getter.get());
            if (Vars.updateEditorOnChange) {
                slider.changed(this.changed);
            } else {
                slider.released(this.changed);
            }
            table.stack(slider, base).colspan(2).pad(3.0f).growX().row();
        }
    }
}

