/*
 * Decompiled with CFR 0.152.
 */
package mindustry.content;

import arc.Events;
import arc.graphics.Color;
import arc.math.Mathf;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.graphics.Pal;
import mindustry.type.StatusEffect;

public class StatusEffects {
    public static StatusEffect none;
    public static StatusEffect burning;
    public static StatusEffect freezing;
    public static StatusEffect unmoving;
    public static StatusEffect slow;
    public static StatusEffect fast;
    public static StatusEffect wet;
    public static StatusEffect muddy;
    public static StatusEffect melting;
    public static StatusEffect sapped;
    public static StatusEffect tarred;
    public static StatusEffect overdrive;
    public static StatusEffect overclock;
    public static StatusEffect shielded;
    public static StatusEffect shocked;
    public static StatusEffect blasted;
    public static StatusEffect corroded;
    public static StatusEffect boss;
    public static StatusEffect sporeSlowed;
    public static StatusEffect disarmed;
    public static StatusEffect electrified;
    public static StatusEffect invincible;
    public static StatusEffect dynamic;

    public static void load() {
        none = new StatusEffect("none");
        burning = new StatusEffect("burning"){
            {
                this.color = Color.valueOf("ffc455");
                this.damage = 0.167f;
                this.effect = Fx.burning;
                this.transitionDamage = 8.0f;
                this.init(() -> {
                    this.opposite(wet, freezing);
                    this.affinity(tarred, (unit, result, time) -> {
                        unit.damagePierce(this.transitionDamage);
                        Fx.burning.at(unit.x + Mathf.range(unit.bounds() / 2.0f), unit.y + Mathf.range(unit.bounds() / 2.0f));
                        result.set(burning, Math.min(time + result.time, 300.0f));
                    });
                });
            }
        };
        freezing = new StatusEffect("freezing"){
            {
                this.color = Color.valueOf("6ecdec");
                this.speedMultiplier = 0.6f;
                this.healthMultiplier = 0.8f;
                this.effect = Fx.freezing;
                this.transitionDamage = 18.0f;
                this.init(() -> {
                    this.opposite(melting, burning);
                    this.affinity(blasted, (unit, result, time) -> {
                        unit.damagePierce(this.transitionDamage);
                        if (unit.team == Vars.state.rules.waveTeam) {
                            Events.fire(EventType.Trigger.blastFreeze);
                        }
                    });
                });
            }
        };
        unmoving = new StatusEffect("unmoving"){
            {
                this.color = Pal.gray;
                this.speedMultiplier = 0.0f;
            }
        };
        slow = new StatusEffect("slow"){
            {
                this.color = Pal.lightishGray;
                this.speedMultiplier = 0.4f;
                this.init(() -> this.opposite(fast));
            }
        };
        fast = new StatusEffect("fast"){
            {
                this.color = Pal.boostTo;
                this.speedMultiplier = 1.6f;
                this.init(() -> this.opposite(slow));
            }
        };
        wet = new StatusEffect("wet"){
            {
                this.color = Color.royal;
                this.speedMultiplier = 0.94f;
                this.effect = Fx.wet;
                this.effectChance = 0.09f;
                this.transitionDamage = 14.0f;
                this.init(() -> {
                    this.affinity(shocked, (unit, result, time) -> {
                        unit.damage(this.transitionDamage);
                        if (unit.team == Vars.state.rules.waveTeam) {
                            Events.fire(EventType.Trigger.shock);
                        }
                    });
                    this.opposite(burning, melting);
                });
            }
        };
        muddy = new StatusEffect("muddy"){
            {
                this.color = Color.valueOf("46382a");
                this.speedMultiplier = 0.94f;
                this.effect = Fx.muddy;
                this.effectChance = 0.09f;
                this.show = false;
            }
        };
        melting = new StatusEffect("melting"){
            {
                this.color = Color.valueOf("ffa166");
                this.speedMultiplier = 0.8f;
                this.healthMultiplier = 0.8f;
                this.damage = 0.3f;
                this.effect = Fx.melting;
                this.init(() -> {
                    this.opposite(wet, freezing);
                    this.affinity(tarred, (unit, result, time) -> {
                        unit.damagePierce(8.0f);
                        Fx.burning.at(unit.x + Mathf.range(unit.bounds() / 2.0f), unit.y + Mathf.range(unit.bounds() / 2.0f));
                        result.set(melting, Math.min(time + result.time, 200.0f));
                    });
                });
            }
        };
        sapped = new StatusEffect("sapped"){
            {
                this.color = Pal.sap;
                this.speedMultiplier = 0.7f;
                this.healthMultiplier = 0.8f;
                this.effect = Fx.sapped;
                this.effectChance = 0.1f;
            }
        };
        electrified = new StatusEffect("electrified"){
            {
                this.color = Pal.heal;
                this.speedMultiplier = 0.7f;
                this.reloadMultiplier = 0.6f;
                this.effect = Fx.electrified;
                this.effectChance = 0.1f;
            }
        };
        sporeSlowed = new StatusEffect("spore-slowed"){
            {
                this.color = Pal.spore;
                this.speedMultiplier = 0.8f;
                this.effect = Fx.sapped;
                this.effectChance = 0.04f;
            }
        };
        tarred = new StatusEffect("tarred"){
            {
                this.color = Color.valueOf("313131");
                this.speedMultiplier = 0.6f;
                this.effect = Fx.oily;
                this.init(() -> {
                    this.affinity(melting, (unit, result, time) -> result.set(melting, result.time + time));
                    this.affinity(burning, (unit, result, time) -> result.set(burning, result.time + time));
                });
            }
        };
        overdrive = new StatusEffect("overdrive"){
            {
                this.color = Pal.accent;
                this.healthMultiplier = 0.95f;
                this.speedMultiplier = 1.15f;
                this.damageMultiplier = 1.4f;
                this.damage = -0.01f;
                this.effect = Fx.overdriven;
                this.permanent = true;
            }
        };
        overclock = new StatusEffect("overclock"){
            {
                this.color = Pal.accent;
                this.speedMultiplier = 1.15f;
                this.damageMultiplier = 1.15f;
                this.reloadMultiplier = 1.25f;
                this.effectChance = 0.07f;
                this.effect = Fx.overclocked;
            }
        };
        shielded = new StatusEffect("shielded"){
            {
                this.color = Pal.accent;
                this.healthMultiplier = 3.0f;
            }
        };
        boss = new StatusEffect("boss"){
            {
                this.color = Team.crux.color;
                this.permanent = true;
                this.damageMultiplier = 1.3f;
                this.healthMultiplier = 1.5f;
            }
        };
        shocked = new StatusEffect("shocked"){
            {
                this.color = Pal.lancerLaser;
                this.reactive = true;
            }
        };
        blasted = new StatusEffect("blasted"){
            {
                this.color = Color.valueOf("ff795e");
                this.reactive = true;
            }
        };
        corroded = new StatusEffect("corroded"){
            {
                this.color = Color.valueOf("e4ffd6");
                this.intervalDamage = 25.0f;
                this.intervalDamageTime = 30.0f;
                this.effectChance = 0.1f;
                this.effect = Fx.corrosionVapor;
            }
        };
        disarmed = new StatusEffect("disarmed"){
            {
                this.color = Color.valueOf("e9ead3");
                this.disarm = true;
            }
        };
        invincible = new StatusEffect("invincible"){
            {
                this.healthMultiplier = Float.POSITIVE_INFINITY;
            }
        };
        dynamic = new StatusEffect("dynamic"){
            {
                this.show = false;
                this.dynamic = true;
                this.permanent = true;
            }
        };
    }
}

