/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.gl;

import arc.files.Fi;
import arc.graphics.Cubemap;
import arc.graphics.CubemapData;
import arc.graphics.Gl;
import arc.graphics.Pixmap;
import arc.graphics.TextureData;
import arc.graphics.gl.PixmapTextureData;
import arc.util.ArcRuntimeException;

public class FacedCubemapData
implements CubemapData {
    protected final TextureData[] data = new TextureData[6];

    public FacedCubemapData() {
        this((Pixmap)null, null, null, null, null, null);
    }

    public FacedCubemapData(Fi positiveX, Fi negativeX, Fi positiveY, Fi negativeY, Fi positiveZ, Fi negativeZ) {
        this(TextureData.load(positiveX, false), TextureData.load(negativeX, false), TextureData.load(positiveY, false), TextureData.load(negativeY, false), TextureData.load(positiveZ, false), TextureData.load(negativeZ, false));
    }

    public FacedCubemapData(Fi positiveX, Fi negativeX, Fi positiveY, Fi negativeY, Fi positiveZ, Fi negativeZ, boolean useMipMaps) {
        this(TextureData.load(positiveX, useMipMaps), TextureData.load(negativeX, useMipMaps), TextureData.load(positiveY, useMipMaps), TextureData.load(negativeY, useMipMaps), TextureData.load(positiveZ, useMipMaps), TextureData.load(negativeZ, useMipMaps));
    }

    public FacedCubemapData(Pixmap positiveX, Pixmap negativeX, Pixmap positiveY, Pixmap negativeY, Pixmap positiveZ, Pixmap negativeZ) {
        this(positiveX, negativeX, positiveY, negativeY, positiveZ, negativeZ, false);
    }

    public FacedCubemapData(Pixmap positiveX, Pixmap negativeX, Pixmap positiveY, Pixmap negativeY, Pixmap positiveZ, Pixmap negativeZ, boolean useMipMaps) {
        this(positiveX == null ? null : new PixmapTextureData(positiveX, useMipMaps, false), negativeX == null ? null : new PixmapTextureData(negativeX, useMipMaps, false), positiveY == null ? null : new PixmapTextureData(positiveY, useMipMaps, false), negativeY == null ? null : new PixmapTextureData(negativeY, useMipMaps, false), positiveZ == null ? null : new PixmapTextureData(positiveZ, useMipMaps, false), negativeZ == null ? null : new PixmapTextureData(negativeZ, useMipMaps, false));
    }

    public FacedCubemapData(int width, int height, int depth, Pixmap.Format format) {
        this(new PixmapTextureData(new Pixmap(depth, height), false, true), new PixmapTextureData(new Pixmap(depth, height), false, true), new PixmapTextureData(new Pixmap(width, depth), false, true), new PixmapTextureData(new Pixmap(width, depth), false, true), new PixmapTextureData(new Pixmap(width, height), false, true), new PixmapTextureData(new Pixmap(width, height), false, true));
    }

    public FacedCubemapData(TextureData positiveX, TextureData negativeX, TextureData positiveY, TextureData negativeY, TextureData positiveZ, TextureData negativeZ) {
        this.data[0] = positiveX;
        this.data[1] = negativeX;
        this.data[2] = positiveY;
        this.data[3] = negativeY;
        this.data[4] = positiveZ;
        this.data[5] = negativeZ;
    }

    public void load(Cubemap.CubemapSide side, Fi file) {
        this.data[side.index] = TextureData.load(file, false);
    }

    public void load(Cubemap.CubemapSide side, Pixmap pixmap) {
        this.data[side.index] = pixmap == null ? null : new PixmapTextureData(pixmap, false, false);
    }

    public boolean isComplete() {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] != null) continue;
            return false;
        }
        return true;
    }

    public TextureData getTextureData(Cubemap.CubemapSide side) {
        return this.data[side.index];
    }

    @Override
    public int getWidth() {
        int tmp;
        int width = 0;
        if (this.data[Cubemap.CubemapSide.positiveZ.index] != null && (tmp = this.data[Cubemap.CubemapSide.positiveZ.index].getWidth()) > width) {
            width = tmp;
        }
        if (this.data[Cubemap.CubemapSide.negativeZ.index] != null && (tmp = this.data[Cubemap.CubemapSide.negativeZ.index].getWidth()) > width) {
            width = tmp;
        }
        if (this.data[Cubemap.CubemapSide.positiveY.index] != null && (tmp = this.data[Cubemap.CubemapSide.positiveY.index].getWidth()) > width) {
            width = tmp;
        }
        if (this.data[Cubemap.CubemapSide.negativeY.index] != null && (tmp = this.data[Cubemap.CubemapSide.negativeY.index].getWidth()) > width) {
            width = tmp;
        }
        return width;
    }

    @Override
    public int getHeight() {
        int tmp;
        int height = 0;
        if (this.data[Cubemap.CubemapSide.positiveZ.index] != null && (tmp = this.data[Cubemap.CubemapSide.positiveZ.index].getHeight()) > height) {
            height = tmp;
        }
        if (this.data[Cubemap.CubemapSide.negativeZ.index] != null && (tmp = this.data[Cubemap.CubemapSide.negativeZ.index].getHeight()) > height) {
            height = tmp;
        }
        if (this.data[Cubemap.CubemapSide.positiveX.index] != null && (tmp = this.data[Cubemap.CubemapSide.positiveX.index].getHeight()) > height) {
            height = tmp;
        }
        if (this.data[Cubemap.CubemapSide.negativeX.index] != null && (tmp = this.data[Cubemap.CubemapSide.negativeX.index].getHeight()) > height) {
            height = tmp;
        }
        return height;
    }

    @Override
    public boolean isPrepared() {
        return false;
    }

    @Override
    public void prepare() {
        if (!this.isComplete()) {
            throw new ArcRuntimeException("You need to complete your cubemap data before using it");
        }
        for (TextureData datum : this.data) {
            if (datum.isPrepared()) continue;
            datum.prepare();
        }
    }

    @Override
    public void consumeCubemapData() {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i].isCustom()) {
                this.data[i].consumeCustomData(34069 + i);
                continue;
            }
            Pixmap pixmap = this.data[i].consumePixmap();
            boolean disposePixmap = this.data[i].disposePixmap();
            Gl.pixelStorei(3317, 1);
            Gl.texImage2D(34069 + i, 0, pixmap.getGLInternalFormat(), pixmap.width, pixmap.height, 0, pixmap.getGLFormat(), pixmap.getGLType(), pixmap.pixels);
            if (!disposePixmap) continue;
            pixmap.dispose();
        }
    }
}

