/*
 * Decompiled with CFR 0.152.
 */
package arc.backend.sdl;

import arc.Core;
import arc.Input;
import arc.backend.sdl.SdlScanmap;
import arc.input.InputEventQueue;
import arc.input.KeyCode;
import arc.scene.ui.TextField;
import arc.struct.Seq;
import arc.util.Strings;

public class SdlInput
extends Input {
    private final InputEventQueue queue = new InputEventQueue();
    private int mouseX;
    private int mouseY;
    private int deltaX;
    private int deltaY;
    private int mousePressed;
    private byte[] strcpy = new byte[32];
    private Seq<EditEvent> stringEditEvents = new Seq();

    void handleInput(final int[] input) {
        int type = input[0];
        if (type == 5) {
            boolean down = input[1] == 1;
            int keycode = input[4];
            KeyCode key = SdlScanmap.getCode(keycode);
            if (input[3] == 0) {
                if (down) {
                    this.queue.keyDown(key);
                } else {
                    this.queue.keyUp(key);
                }
            }
            if (down) {
                if (key == KeyCode.backspace) {
                    this.queue.keyTyped('\b');
                }
                if (key == KeyCode.tab) {
                    this.queue.keyTyped('\t');
                }
                if (key == KeyCode.enter) {
                    this.queue.keyTyped('\r');
                }
                if (key == KeyCode.forwardDel || key == KeyCode.del) {
                    this.queue.keyTyped('\u007f');
                }
            }
        } else if (type == 3) {
            KeyCode key;
            boolean down = input[1] == 1;
            int keycode = input[4];
            int x = input[2];
            int y = Core.graphics.getHeight() - input[3];
            KeyCode keyCode = keycode == 1 ? KeyCode.mouseLeft : (keycode == 3 ? KeyCode.mouseRight : (keycode == 2 ? KeyCode.mouseMiddle : (keycode == 4 ? KeyCode.mouseBack : (key = keycode == 5 ? KeyCode.mouseForward : null))));
            if (key != null) {
                if (down) {
                    ++this.mousePressed;
                    this.queue.touchDown(x, y, 0, key);
                } else {
                    this.mousePressed = Math.max(0, this.mousePressed - 1);
                    this.queue.touchUp(x, y, 0, key);
                }
            }
        } else if (type == 2) {
            int x = input[1];
            int y = Core.graphics.getHeight() - input[2];
            this.deltaX = x - this.mouseX;
            this.deltaY = y - this.mouseY;
            this.mouseX = x;
            this.mouseY = y;
            if (this.mousePressed > 0) {
                this.queue.touchDragged(this.mouseX, this.mouseY, 0);
            } else {
                this.queue.mouseMoved(this.mouseX, this.mouseY);
            }
        } else if (type == 4) {
            int sx = input[1];
            int sy = input[2];
            this.queue.scrolled(-sx, -sy);
        } else if (type == 6) {
            int i;
            int length = 0;
            for (i = 0; i < 32; ++i) {
                char c = (char)input[i + 1];
                if (c != '\u0000') continue;
                length = i;
                break;
            }
            for (i = 0; i < length; ++i) {
                this.strcpy[i] = (byte)input[i + 1];
            }
            String s = new String(this.strcpy, 0, length, Strings.utf8);
            for (int i2 = 0; i2 < s.length(); ++i2) {
                this.queue.keyTyped(s.charAt(i2));
            }
        } else if (type == 8) {
            int i;
            int length = 0;
            for (i = 0; i < 32; ++i) {
                char c = (char)input[i + 3];
                if (c != '\u0000') continue;
                length = i;
                break;
            }
            for (i = 0; i < length; ++i) {
                this.strcpy[i] = (byte)input[i + 3];
            }
            final String str = new String(this.strcpy, 0, length, Strings.utf8);
            this.stringEditEvents.add(new EditEvent(){
                {
                    this.start = input[1];
                    this.length = input[2];
                    this.text = str;
                }
            });
        }
    }

    void handleFieldCandidate(EditEvent e) {
        String text = e.text;
        if (Core.scene != null && Core.scene.getKeyboardFocus() instanceof TextField) {
            class ImeData {
                String lastSetText;
                String realText;
                int cursor;

                ImeData() {
                }
            }
            ImeData data;
            final TextField field = (TextField)Core.scene.getKeyboardFocus();
            if (field.imeData instanceof ImeData) {
                data = (ImeData)field.imeData;
                if (data.lastSetText != field.getText()) {
                    field.imeData = null;
                } else if (text.length() == 0) {
                    field.imeData = null;
                    field.setText(data.realText);
                    field.clearSelection();
                    field.setCursorPosition(data.cursor);
                }
            }
            if (text.length() == 0) {
                return;
            }
            if (field.imeData == null) {
                field.imeData = new ImeData(){
                    {
                        this.cursor = field.getCursorPosition();
                        this.realText = field.getText();
                    }
                };
            }
            data = (ImeData)field.imeData;
            String targetText = data.realText;
            int insertPos = data.cursor;
            field.setText(targetText.substring(0, Math.min(insertPos, targetText.length())) + text + targetText.substring(Math.min(insertPos, targetText.length())));
            field.setSelection(insertPos, insertPos + text.length());
            data.lastSetText = field.getText();
        }
    }

    void update() {
        this.queue.setProcessor(this.inputMultiplexer);
        this.queue.drain();
        for (EditEvent e : this.stringEditEvents) {
            this.handleFieldCandidate(e);
        }
        this.stringEditEvents.clear();
    }

    void postUpdate() {
        this.keyboard.postUpdate();
        this.deltaY = 0;
        this.deltaX = 0;
    }

    @Override
    public int mouseX() {
        return this.mouseX;
    }

    @Override
    public int mouseX(int pointer) {
        return pointer == 0 ? this.mouseX : 0;
    }

    @Override
    public int deltaX() {
        return this.deltaX;
    }

    @Override
    public int deltaX(int pointer) {
        return pointer == 0 ? this.deltaX : 0;
    }

    @Override
    public int mouseY() {
        return this.mouseY;
    }

    @Override
    public int mouseY(int pointer) {
        return pointer == 0 ? this.mouseY : 0;
    }

    @Override
    public int deltaY() {
        return this.deltaY;
    }

    @Override
    public int deltaY(int pointer) {
        return pointer == 0 ? this.deltaY : 0;
    }

    @Override
    public boolean isTouched() {
        return this.keyDown(KeyCode.mouseLeft) || this.keyDown(KeyCode.mouseRight);
    }

    @Override
    public boolean justTouched() {
        return this.keyTap(KeyCode.mouseLeft) || this.keyTap(KeyCode.mouseRight);
    }

    @Override
    public boolean isTouched(int pointer) {
        return false;
    }

    @Override
    public long getCurrentEventTime() {
        return this.queue.getCurrentEventTime();
    }

    class EditEvent {
        int start;
        int length;
        String text;

        EditEvent() {
        }
    }
}

