/*
 * Decompiled with CFR 0.152.
 */
package rhino.ast;

import java.util.SortedSet;
import java.util.TreeSet;
import rhino.Node;
import rhino.ast.AstNode;
import rhino.ast.Comment;
import rhino.ast.NodeVisitor;
import rhino.ast.ScriptNode;

public class AstRoot
extends ScriptNode {
    private SortedSet<Comment> comments;

    public AstRoot() {
        this.type = 137;
    }

    public AstRoot(int pos) {
        super(pos);
        this.type = 137;
    }

    public SortedSet<Comment> getComments() {
        return this.comments;
    }

    public void setComments(SortedSet<Comment> comments) {
        if (comments == null) {
            this.comments = null;
        } else {
            if (this.comments != null) {
                this.comments.clear();
            }
            for (Comment c : comments) {
                this.addComment(c);
            }
        }
    }

    public void addComment(Comment comment) {
        this.assertNotNull(comment);
        if (this.comments == null) {
            this.comments = new TreeSet<Comment>((n1, n2) -> n1.position - n2.position);
        }
        this.comments.add(comment);
        comment.setParent(this);
    }

    public void visitComments(NodeVisitor visitor) {
        if (this.comments != null) {
            for (Comment c : this.comments) {
                visitor.visit(c);
            }
        }
    }

    public void visitAll(NodeVisitor visitor) {
        this.visit(visitor);
        this.visitComments(visitor);
    }

    @Override
    public String toSource(int depth) {
        StringBuilder sb = new StringBuilder();
        for (Node node : this) {
            sb.append(((AstNode)node).toSource(depth));
            if (node.getType() != 162) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public String debugPrint() {
        AstNode.DebugPrintVisitor dpv = new AstNode.DebugPrintVisitor(new StringBuilder(1000));
        this.visitAll(dpv);
        return dpv.toString();
    }

    public void checkParentLinks() {
        this.visit(node -> {
            int type = node.getType();
            if (type == 137) {
                return true;
            }
            if (node.getParent() == null) {
                throw new IllegalStateException("No parent for node: " + node + "\n" + node.toSource(0));
            }
            return true;
        });
    }
}

