/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.consumers;

import arc.func.Boolf;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.type.Liquid;
import mindustry.ui.MultiReqImage;
import mindustry.ui.ReqImage;
import mindustry.world.Block;
import mindustry.world.consumers.ConsumeLiquidBase;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatValues;
import mindustry.world.meta.Stats;

public class ConsumeLiquidFilter
extends ConsumeLiquidBase {
    public Boolf<Liquid> filter = l -> false;

    public ConsumeLiquidFilter(Boolf<Liquid> liquid, float amount) {
        super(amount);
        this.filter = liquid;
    }

    public ConsumeLiquidFilter() {
    }

    @Override
    public void apply(Block block) {
        block.hasLiquids = true;
        Vars.content.liquids().each(this.filter, item -> {
            block.liquidFilter[item.id] = true;
        });
    }

    @Override
    public void build(Building build, Table table) {
        Seq<Liquid> list = Vars.content.liquids().select(l -> !l.isHidden() && this.filter.get((Liquid)l));
        MultiReqImage image = new MultiReqImage();
        list.each(liquid -> image.add(new ReqImage(liquid.uiIcon, () -> this.getConsumed(build) == liquid)));
        table.add(image).size(32.0f);
    }

    @Override
    public void update(Building build) {
        Liquid liq = this.getConsumed(build);
        if (liq != null) {
            build.liquids.remove(liq, this.amount * build.edelta() * this.multiplier.get(build));
        }
    }

    @Override
    public float efficiency(Building build) {
        Liquid liq = this.getConsumed(build);
        float ed = build.edelta();
        if (ed <= 1.0E-8f) {
            return 0.0f;
        }
        return liq != null ? Math.min(build.liquids.get(liq) / (this.amount * ed * this.multiplier.get(build)), 1.0f) : 0.0f;
    }

    @Override
    public float efficiencyMultiplier(Building build) {
        Liquid liq = this.getConsumed(build);
        return liq == null ? 0.0f : this.liquidEfficiencyMultiplier(liq);
    }

    @Nullable
    public Liquid getConsumed(Building build) {
        if (this.filter.get(build.liquids.current()) && build.liquids.currentAmount() > 0.0f) {
            return build.liquids.current();
        }
        Seq<Liquid> liqs = Vars.content.liquids();
        for (int i = 0; i < liqs.size; ++i) {
            Liquid liq = liqs.get(i);
            if (!this.filter.get(liq) || !(build.liquids.get(liq) > 0.0f)) continue;
            return liq;
        }
        return null;
    }

    @Override
    public void display(Stats stats) {
        stats.add(this.booster ? Stat.booster : Stat.input, StatValues.liquids(this.filter, this.amount * 60.0f, true));
    }

    @Override
    public boolean consumes(Liquid liquid) {
        return this.filter.get(liquid);
    }

    public float liquidEfficiencyMultiplier(Liquid liquid) {
        return 1.0f;
    }
}

