/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.planet;

import arc.graphics.Color;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Vec2;
import arc.math.geom.Vec3;
import arc.util.Tmp;
import arc.util.noise.Ridged;
import arc.util.noise.Simplex;
import mindustry.Vars;
import mindustry.ai.Astar;
import mindustry.content.Blocks;
import mindustry.content.Loadouts;
import mindustry.game.Schematics;
import mindustry.maps.generators.PlanetGenerator;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.TileGen;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.SteamVent;
import mindustry.world.blocks.environment.TallBlock;
import mindustry.world.meta.Attribute;

public class ErekirPlanetGenerator
extends PlanetGenerator {
    public float heightScl = 0.9f;
    public float octaves = 8.0f;
    public float persistence = 0.7f;
    public float heightPow = 3.0f;
    public float heightMult = 1.6f;
    public static float arkThresh = 0.28f;
    public static float arkScl = 0.83f;
    public static int arkSeed = 7;
    public static int arkOct = 2;
    public static float liqThresh = 0.64f;
    public static float liqScl = 87.0f;
    public static float redThresh = 3.1f;
    public static float noArkThresh = 0.3f;
    public static int crystalSeed = 8;
    public static int crystalOct = 2;
    public static float crystalScl = 0.9f;
    public static float crystalMag = 0.3f;
    public static float airThresh = 0.13f;
    public static float airScl = 14.0f;
    Block[] terrain = new Block[]{Blocks.regolith, Blocks.regolith, Blocks.regolith, Blocks.regolith, Blocks.yellowStone, Blocks.rhyolite, Blocks.rhyolite, Blocks.carbonStone};

    public ErekirPlanetGenerator() {
        this.baseSeed = 2;
        this.defaultLoadout = Loadouts.basicBastion;
    }

    @Override
    public float getHeight(Vec3 position) {
        return Mathf.pow(this.rawHeight(position), this.heightPow) * this.heightMult;
    }

    @Override
    public void getColor(Vec3 position, Color out) {
        Block block = this.getBlock(position);
        if (block == Blocks.crystallineStone) {
            block = Blocks.crystalFloor;
        }
        out.set(block.mapColor).a(1.0f - block.albedo);
    }

    @Override
    public float getSizeScl() {
        return 2568.0f;
    }

    float rawHeight(Vec3 position) {
        return Simplex.noise3d(this.seed, this.octaves, this.persistence, 1.0f / this.heightScl, 10.0f + position.x, 10.0f + position.y, 10.0f + position.z);
    }

    float rawTemp(Vec3 position) {
        return position.dst(0.0f, 0.0f, 1.0f) * 2.2f - Simplex.noise3d(this.seed, 8.0, 0.54f, 1.4f, 10.0f + position.x, 10.0f + position.y, 10.0f + position.z) * 2.9f;
    }

    Block getBlock(Vec3 position) {
        float px = position.x;
        float py = position.y;
        float pz = position.z;
        float ice = this.rawTemp(position);
        float height = this.rawHeight(position);
        height *= 1.2f;
        height = Mathf.clamp(height);
        Block result = this.terrain[Mathf.clamp((int)(height * (float)this.terrain.length), 0, this.terrain.length - 1)];
        if ((double)ice < 0.3 + (double)(Math.abs(Ridged.noise3d(this.seed + crystalSeed, px + 4.0f, py + 8.0f, pz + 1.0f, crystalOct, crystalScl)) * crystalMag)) {
            return Blocks.crystallineStone;
        }
        if ((double)ice < 0.6 && (result == Blocks.rhyolite || result == Blocks.yellowStone || result == Blocks.regolith)) {
            return Blocks.carbonStone;
        }
        if (ice < redThresh - noArkThresh && Ridged.noise3d(this.seed + arkSeed, px + 2.0f, py + 8.0f, pz + 1.0f, arkOct, arkScl) > arkThresh) {
            result = Blocks.beryllicStone;
        }
        if (ice > redThresh) {
            result = Blocks.redStone;
        } else if (ice > redThresh - 0.4f) {
            result = Blocks.regolith;
        }
        return result;
    }

    @Override
    public void genTile(Vec3 position, TileGen tile) {
        tile.floor = this.getBlock(position);
        if (tile.floor == Blocks.rhyolite && this.rand.chance(0.01)) {
            tile.floor = Blocks.rhyoliteCrater;
        }
        tile.block = tile.floor.asFloor().wall;
        if (Ridged.noise3d(this.seed + 1, position.x, position.y, position.z, 2, airScl) > airThresh) {
            tile.block = Blocks.air;
        }
        if ((double)Ridged.noise3d(this.seed + 2, position.x, position.y + 4.0f, position.z, 3, 6.0f) > 0.6) {
            tile.floor = Blocks.carbonStone;
        }
    }

    @Override
    protected void generate() {
        float temp = this.rawTemp(this.sector.tile.v);
        if ((double)temp > 0.7) {
            this.pass((x, y) -> {
                if (this.floor != Blocks.redIce) {
                    float noise = this.noise(x + 782, y, 7.0, (double)0.8f, 280.0, 1.0);
                    if (noise > 0.62f) {
                        this.floor = noise > 0.635f ? Blocks.slag : Blocks.yellowStone;
                        this.ore = Blocks.air;
                    }
                    if (noise > 0.55f && this.floor == Blocks.beryllicStone) {
                        this.floor = Blocks.yellowStone;
                    }
                }
            });
        }
        this.cells(4);
        this.pass((x, y) -> {
            if (this.floor == Blocks.regolith && this.noise(x, y, 3.0, (double)0.4f, 13.0, 1.0) > 0.59f) {
                this.block = Blocks.regolithWall;
            }
        });
        float length = (float)this.width / 2.6f;
        Vec2 trns = Tmp.v1.trns(this.rand.random(360.0f), length);
        int spawnX = (int)(trns.x + (float)this.width / 2.0f);
        int spawnY = (int)(trns.y + (float)this.height / 2.0f);
        int endX = (int)(-trns.x + (float)this.width / 2.0f);
        int endY = (int)(-trns.y + (float)this.height / 2.0f);
        float maxd = Mathf.dst((float)this.width / 2.0f, (float)this.height / 2.0f);
        this.erase(spawnX, spawnY, 15);
        this.brush(this.pathfind(spawnX, spawnY, endX, endY, tile -> (tile.solid() ? 300.0f : 0.0f) + maxd - tile.dst((float)this.width / 2.0f, (float)this.height / 2.0f) / 10.0f, Astar.manhattan), 9);
        this.erase(endX, endY, 15);
        this.pass((x, y) -> {
            if (this.floor != Blocks.beryllicStone) {
                return;
            }
            if (Math.abs(this.noise(x, (float)y + 500.0f, 5.0, (double)0.6f, 40.0, 1.0) - 0.5f) < 0.09f) {
                this.floor = Blocks.arkyicStone;
            }
            if (this.nearWall(x, y)) {
                return;
            }
            float noise = this.noise(x + 300, (float)y - (float)x * 1.6f + 100.0f, 4.0, (double)0.8f, (double)liqScl, 1.0);
            if (noise > liqThresh) {
                this.floor = Blocks.arkyciteFloor;
            }
        });
        this.median(2, 0.6, Blocks.arkyciteFloor);
        this.blend(Blocks.arkyciteFloor, Blocks.arkyicStone, 4.0f);
        this.blend(Blocks.slag, Blocks.yellowStonePlates, 4.0f);
        this.distort(10.0f, 12.0f);
        this.distort(5.0f, 7.0f);
        this.median(2, 0.6, Blocks.arkyciteFloor);
        this.median(3, 0.6, Blocks.slag);
        this.pass((x, y) -> {
            if (this.noise(x, y + 600 + x, 5.0, (double)0.86f, 60.0, 1.0) < 0.41f && this.floor == Blocks.rhyolite) {
                this.floor = Blocks.roughRhyolite;
            }
            if (this.floor == Blocks.slag && Mathf.within(x, y, spawnX, spawnY, 30.0f + this.noise(x, y, 2.0, (double)0.8f, 9.0, 15.0))) {
                this.floor = Blocks.yellowStonePlates;
            }
            if ((this.floor == Blocks.arkyciteFloor || this.floor == Blocks.arkyicStone) && this.block.isStatic()) {
                this.block = Blocks.arkyicWall;
            }
            float max = 0.0f;
            for (Point2 p : Geometry.d8) {
                max = Math.max(max, Vars.world.getDarkness(x + p.x, y + p.y));
            }
            if (max > 0.0f) {
                this.block = this.floor.asFloor().wall;
                if (this.block == Blocks.air) {
                    this.block = Blocks.yellowStoneWall;
                }
            }
            if (this.floor == Blocks.yellowStonePlates && this.noise(x + 78 + y, y, 3.0, (double)0.8f, 6.0, 1.0) > 0.44f) {
                this.floor = Blocks.yellowStone;
            }
            if (this.floor == Blocks.redStone && this.noise(x + 78 - y, y, 4.0, (double)0.73f, 19.0, 1.0) > 0.63f) {
                this.floor = Blocks.denseRedStone;
            }
        });
        this.inverseFloodFill(this.tiles.getn(spawnX, spawnY));
        this.blend(Blocks.redStoneWall, Blocks.denseRedStone, 4.0f);
        this.erase(endX, endY, 6);
        this.tiles.getn(endX, endY).setOverlay(Blocks.spawn);
        this.pass((x, y) -> {
            if (this.block != Blocks.air) {
                if (this.nearAir(x, y)) {
                    if (this.block == Blocks.carbonWall && this.noise(x + 78, y, 4.0, (double)0.7f, 33.0, 1.0) > 0.52f) {
                        this.block = Blocks.graphiticWall;
                    } else if (this.block != Blocks.carbonWall && this.noise(x + 782, y, 4.0, (double)0.8f, 38.0, 1.0) > 0.665f) {
                        this.ore = Blocks.wallOreBeryllium;
                    }
                }
            } else if (!this.nearWall(x, y)) {
                if (this.noise(x + 150, y + x * 2 + 100, 4.0, (double)0.8f, 55.0, 1.0) > 0.76f) {
                    this.ore = Blocks.oreTungsten;
                }
                if (this.noise(x + 999, y + 600 - x, 4.0, (double)0.63f, 45.0, 1.0) < 0.27f && this.floor == Blocks.crystallineStone) {
                    this.ore = Blocks.oreCrystalThorium;
                }
            }
            if (this.noise(x + 999, y + 600 - x, 5.0, (double)0.8f, 45.0, 1.0) < 0.44f && this.floor == Blocks.crystallineStone) {
                this.floor = Blocks.crystalFloor;
            }
            if (this.block == Blocks.air && (this.floor == Blocks.crystallineStone || this.floor == Blocks.crystalFloor) && this.rand.chance(0.09) && this.nearWall(x, y) && !this.near(x, y, 4, Blocks.crystalCluster) && !this.near(x, y, 4, Blocks.vibrantCrystalCluster)) {
                this.block = this.floor == Blocks.crystalFloor ? Blocks.vibrantCrystalCluster : Blocks.crystalCluster;
                this.ore = Blocks.air;
            }
            if (this.block == Blocks.arkyicWall && this.rand.chance(0.23) && this.nearAir(x, y) && !this.near(x, y, 3, Blocks.crystalOrbs)) {
                this.block = Blocks.crystalOrbs;
                this.ore = Blocks.air;
            }
            if (this.block == Blocks.regolithWall && this.rand.chance(0.3) && this.nearAir(x, y) && !this.near(x, y, 3, Blocks.crystalBlocks)) {
                this.block = Blocks.crystalBlocks;
                this.ore = Blocks.air;
            }
        });
        this.pass((x, y) -> {
            if (this.ore.asFloor().wallOre || this.block.itemDrop != null || this.block == Blocks.air && this.ore != Blocks.air) {
                this.removeWall(x, y, 3, b -> b instanceof TallBlock);
            }
        });
        this.trimDark();
        int minVents = this.rand.random(6, 9);
        int ventCount = 0;
        block0: for (Tile tile2 : this.tiles) {
            int y2;
            Floor floor = tile2.floor();
            if (floor != Blocks.rhyolite && floor != Blocks.roughRhyolite || !this.rand.chance(0.002)) continue;
            int radius = 2;
            for (int x2 = -radius; x2 <= radius; ++x2) {
                for (y2 = -radius; y2 <= radius; ++y2) {
                    Tile other = this.tiles.get(x2 + tile2.x, y2 + tile2.y);
                    if (other == null || other.floor() != Blocks.rhyolite && other.floor() != Blocks.roughRhyolite || other.block().solid) continue block0;
                }
            }
            ++ventCount;
            Point2[] x2 = SteamVent.offsets;
            y2 = x2.length;
            for (int other = 0; other < y2; ++other) {
                Point2 pos = x2[other];
                Tile other2 = this.tiles.get(pos.x + tile2.x + 1, pos.y + tile2.y + 1);
                other2.setFloor(Blocks.rhyoliteVent.asFloor());
            }
        }
        int iterations = 0;
        int maxIterations = 5;
        while (ventCount < minVents && iterations++ < maxIterations) {
            block5: for (Tile tile3 : this.tiles) {
                if (!this.rand.chance(1.8E-4 * (double)(1 + iterations)) || Mathf.within(tile3.x, tile3.y, spawnX, spawnY, 5.0f) || tile3.floor() == Blocks.crystallineStone || tile3.floor() == Blocks.crystalFloor) continue;
                int radius = 1;
                for (int x3 = -radius; x3 <= radius; ++x3) {
                    for (int y3 = -radius; y3 <= radius; ++y3) {
                        Tile other = this.tiles.get(x3 + tile3.x, y3 + tile3.y);
                        if (other == null || other.block().solid || other.floor().attributes.get(Attribute.steam) != 0.0f || other.floor() == Blocks.slag || other.floor() == Blocks.arkyciteFloor) continue block5;
                    }
                }
                Block floor = Blocks.rhyolite;
                Block secondFloor = Blocks.rhyoliteCrater;
                Block vent = Blocks.rhyoliteVent;
                int xDir = 1;
                if (tile3.floor() == Blocks.beryllicStone || tile3.floor() == Blocks.arkyicStone) {
                    floor = secondFloor = Blocks.arkyicStone;
                    vent = Blocks.arkyicVent;
                } else if (tile3.floor() == Blocks.yellowStone || tile3.floor() == Blocks.yellowStonePlates || tile3.floor() == Blocks.regolith) {
                    floor = Blocks.yellowStone;
                    secondFloor = Blocks.yellowStonePlates;
                    vent = Blocks.yellowStoneVent;
                } else if (tile3.floor() == Blocks.redStone || tile3.floor() == Blocks.denseRedStone) {
                    floor = Blocks.denseRedStone;
                    secondFloor = Blocks.redStone;
                    vent = Blocks.redStoneVent;
                    xDir = -1;
                } else if (tile3.floor() == Blocks.carbonStone) {
                    floor = secondFloor = Blocks.carbonStone;
                    vent = Blocks.carbonVent;
                }
                ++ventCount;
                for (Point2 pos : SteamVent.offsets) {
                    Tile other = this.tiles.get(pos.x + tile3.x + 1, pos.y + tile3.y + 1);
                    other.setFloor(vent.asFloor());
                }
                int crad = this.rand.random(6, 14);
                int crad2 = crad * crad;
                for (int cx = -crad; cx <= crad; ++cx) {
                    for (int cy = -crad; cy <= crad; ++cy) {
                        Tile dest;
                        float rcy = (float)cy + (float)cx * 0.9f;
                        int rx = cx + tile3.x;
                        int ry = cy + tile3.y;
                        if (!((float)(cx * cx) + rcy * rcy <= (float)crad2 - this.noise(rx, (float)ry + (float)rx * 2.0f * (float)xDir, 2.0, (double)0.7f, 8.0, (double)((float)crad2 * 1.1f))) || (dest = this.tiles.get(rx, ry)) == null || dest.floor().attributes.get(Attribute.steam) != 0.0f || dest.floor() == Blocks.roughRhyolite || dest.floor() == Blocks.arkyciteFloor || dest.floor() == Blocks.slag) continue;
                        dest.setFloor(this.rand.chance(0.08) ? secondFloor.asFloor() : floor.asFloor());
                        if (!dest.block().isStatic()) continue;
                        dest.setBlock(floor.asFloor().wall);
                    }
                }
            }
        }
        for (Tile tile4 : this.tiles) {
            if (!tile4.overlay().needsSurface || tile4.floor().hasSurface()) continue;
            tile4.setOverlay(Blocks.air);
        }
        this.decoration(0.017f);
        Vars.state.rules.env = this.sector.planet.defaultEnv;
        Vars.state.rules.placeRangeCheck = true;
        Schematics.placeLaunchLoadout(spawnX, spawnY);
        Vars.state.rules.waves = false;
        Vars.state.rules.showSpawns = true;
    }
}

