/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.Pixmaps;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.GlyphLayout;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mat;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.math.geom.Rect;
import arc.scene.ui.layout.Scl;
import arc.struct.IntSet;
import arc.struct.LongSeq;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.entities.Units;
import mindustry.game.EventType;
import mindustry.game.MapObjectives;
import mindustry.gen.Building;
import mindustry.gen.Groups;
import mindustry.gen.Icon;
import mindustry.gen.Indicator;
import mindustry.gen.Player;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.graphics.Shaders;
import mindustry.io.MapIO;
import mindustry.ui.Fonts;
import mindustry.world.Block;
import mindustry.world.Tile;

public class MinimapRenderer {
    private static final float baseSize = 16.0f;
    private static final float updateInterval = 2.0f;
    private final Seq<Unit> units = new Seq();
    private Pixmap pixmap;
    private Texture texture;
    private TextureRegion region;
    private Rect rect = new Rect();
    private float zoom = 4.0f;
    private IntSet updates = new IntSet();
    private float updateCounter = 0.0f;

    public MinimapRenderer() {
        Events.on(EventType.WorldLoadEvent.class, event -> {
            this.reset();
            this.updateAll();
        });
        Events.on(EventType.TileChangeEvent.class, event -> {
            if (!Vars.ui.editor.isShown()) {
                this.update(event.tile);
                if (event.tile.block().solid && event.tile.y > 0 && event.tile.isCenter()) {
                    event.tile.getLinkedTiles(t -> {
                        Tile tile = Vars.world.tile(t.x, t.y - 1);
                        if (tile != null && tile.block() == Blocks.air) {
                            this.update(tile);
                        }
                    });
                }
            }
        });
        Events.on(EventType.TilePreChangeEvent.class, e -> {
            Tile tile;
            if (e.tile.block().solid && e.tile.y > 0 && (tile = Vars.world.tile(e.tile.x, e.tile.y - 1)).block() == Blocks.air) {
                Time.run(0.0f, () -> this.update(tile));
            }
        });
        Events.on(EventType.BuildTeamChangeEvent.class, event -> this.update(event.build.tile));
    }

    public void update() {
        float f;
        this.updateCounter += Time.delta;
        if (f >= 2.0f) {
            this.updateCounter %= 2.0f;
            this.updates.each(pos -> {
                Tile tile = Vars.world.tile(pos);
                if (tile == null) {
                    return;
                }
                int color = this.colorFor(tile);
                this.pixmap.set((int)tile.x, this.pixmap.height - 1 - tile.y, color);
                Pixmaps.drawPixel(this.texture, tile.x, this.pixmap.height - 1 - tile.y, color);
            });
            this.updates.clear();
        }
    }

    public Pixmap getPixmap() {
        return this.pixmap;
    }

    @Nullable
    public Texture getTexture() {
        return this.texture;
    }

    public void zoomBy(float amount) {
        this.zoom += amount;
        this.setZoom(this.zoom);
    }

    public void setZoom(float amount) {
        this.zoom = Mathf.clamp(amount, 1.0f, (float)Math.min(Vars.world.width(), Vars.world.height()) / 16.0f / 2.0f);
    }

    public float getZoom() {
        return this.zoom;
    }

    public void reset() {
        this.updates.clear();
        if (this.pixmap != null) {
            this.pixmap.dispose();
            this.texture.dispose();
        }
        this.setZoom(4.0f);
        this.pixmap = new Pixmap(Vars.world.width(), Vars.world.height());
        this.texture = new Texture(this.pixmap);
        this.region = new TextureRegion(this.texture);
    }

    public void drawEntities(float x, float y, float w, float h, boolean fullView) {
        float scaleFactor;
        if (!fullView) {
            this.updateUnitArray();
        } else {
            this.units.clear();
            Groups.unit.copy(this.units);
        }
        float sz = 16.0f * this.zoom;
        float dx = Core.camera.position.x / 8.0f;
        float dy = Core.camera.position.y / 8.0f;
        dx = Mathf.clamp(dx, sz, (float)Vars.world.width() - sz);
        dy = Mathf.clamp(dy, sz, (float)Vars.world.height() - sz);
        this.rect.set((dx - sz) * 8.0f, (dy - sz) * 8.0f, sz * 2.0f * 8.0f, sz * 2.0f * 8.0f);
        Tmp.m2.set(Draw.trans());
        Mat trans = Tmp.m1.idt();
        trans.translate(x, y);
        if (!fullView) {
            scaleFactor = w / this.rect.width;
            trans.scl(Tmp.v1.set(scaleFactor, h / this.rect.height));
            trans.translate(-this.rect.x, -this.rect.y);
        } else {
            scaleFactor = w / (float)Vars.world.unitWidth();
            trans.scl(Tmp.v1.set(scaleFactor, h / (float)Vars.world.unitHeight()));
        }
        trans.translate(4.0f, 4.0f);
        Draw.trans(trans);
        scaleFactor = 1.0f / scaleFactor;
        for (Unit unit : this.units) {
            if (unit.inFogTo(Vars.player.team()) || !unit.type.drawMinimap) continue;
            float scale = Scl.scl(1.0f) * 8.0f * 3.0f;
            TextureRegion region = unit.icon();
            Draw.mixcol(unit.team.color, 1.0f);
            Draw.rect(region, unit.x, unit.y, scale, scale * (float)region.height / (float)region.width, unit.rotation() - 90.0f);
            Draw.reset();
        }
        if (fullView && Vars.net.active()) {
            for (Player player : Groups.player) {
                if (player.dead()) continue;
                this.drawLabel(player.x, player.y, player.name, player.color, scaleFactor);
            }
        }
        Draw.reset();
        if (Vars.state.rules.fog) {
            if (fullView) {
                float z = this.zoom;
                this.setZoom(99999.0f);
                this.getRegion();
                this.zoom = z;
            }
            Draw.shader(Shaders.fog);
            Texture staticTex = Vars.renderer.fog.getStaticTexture();
            Texture dynamicTex = Vars.renderer.fog.getDynamicTexture();
            dynamicTex.setFilter(Texture.TextureFilter.nearest);
            Tmp.tr1.set(dynamicTex);
            Tmp.tr1.set(0.0f, 1.0f, 1.0f, 0.0f);
            float wf = Vars.world.width() * 8;
            float hf = Vars.world.height() * 8;
            Draw.color(Vars.state.rules.dynamicColor, Float.isNaN(Vars.state.rules.dynamicColor.a) ? 0.5f : Math.max(0.5f, Vars.state.rules.dynamicColor.a));
            Draw.rect(Tmp.tr1, wf / 2.0f, hf / 2.0f, wf, hf);
            if (Vars.state.rules.staticFog) {
                staticTex.setFilter(Texture.TextureFilter.nearest);
                Tmp.tr1.texture = staticTex;
                Draw.color(0.0f, 0.0f, 0.0f, 1.0f);
                Draw.rect(Tmp.tr1, wf / 2.0f, hf / 2.0f, wf, hf);
            }
            Draw.color();
            Draw.shader();
        }
        if (fullView) {
            this.drawSpawns();
            if (!Vars.mobile) {
                Rect r = Core.camera.bounds(Tmp.r1);
                Lines.stroke(Scl.scl(3.0f) * scaleFactor);
                Draw.color(Pal.accent);
                Lines.rect(r.x, r.y, r.width, r.height);
                Draw.reset();
            }
        }
        LongSeq indicators = Vars.control.indicators.list();
        float fin = Time.globalTime / 30.0f % 1.0f;
        float rad = fin * 5.0f + 8.0f - 2.0f;
        Lines.stroke(Scl.scl((1.0f - fin) * 4.0f + 0.5f));
        for (int i = 0; i < indicators.size; ++i) {
            long ind = indicators.items[i];
            int pos = Indicator.pos(ind);
            short ix = Point2.x(pos);
            short iy = Point2.y(pos);
            float time = Indicator.time(ind);
            float offset = 0.0f;
            Building build = Vars.world.build(pos);
            if (build != null) {
                offset = build.block.offset / 8.0f;
            }
            Draw.color(Color.orange, Color.scarlet, Mathf.clamp(time / 70.0f));
            Lines.square(((float)ix + 0.5f + offset) * 8.0f, ((float)iy + 0.5f + offset) * 8.0f, rad);
        }
        Draw.reset();
        Vars.state.rules.objectives.eachRunning(obj -> {
            for (MapObjectives.ObjectiveMarker marker : obj.markers) {
                if (!marker.minimap) continue;
                marker.draw(1.0f);
            }
        });
        for (MapObjectives.ObjectiveMarker marker : Vars.state.markers) {
            if (!marker.minimap) continue;
            marker.draw(1.0f);
        }
        Draw.trans(Tmp.m2);
    }

    public void drawSpawns() {
        if (!(Vars.state.rules.showSpawns && Vars.state.hasSpawns() && Vars.state.rules.waves)) {
            return;
        }
        TextureRegion icon = Icon.units.getRegion();
        Lines.stroke(Scl.scl(3.0f));
        Draw.color(Vars.state.rules.waveTeam.color, Tmp.c2.set(Vars.state.rules.waveTeam.color).value(1.2f), Mathf.absin(Time.time, 16.0f, 1.0f));
        float rad = Vars.state.rules.dropZoneRadius;
        float curve = Mathf.curve(Time.time % 240.0f, 120.0f, 240.0f);
        for (Tile tile : Vars.spawner.getSpawns()) {
            float tx = tile.worldx();
            float ty = tile.worldy();
            Draw.rect(icon, tx, ty, (float)icon.width, (float)icon.height);
            Lines.circle(tx, ty, rad);
            if (!(curve > 0.0f)) continue;
            Lines.circle(tx, ty, rad * Interp.pow3Out.apply(curve));
        }
        Draw.reset();
    }

    @Nullable
    public TextureRegion getRegion() {
        if (this.texture == null) {
            return null;
        }
        float sz = Mathf.clamp(16.0f * this.zoom, 16.0f, (float)Math.min(Vars.world.width(), Vars.world.height()));
        float dx = Core.camera.position.x / 8.0f;
        float dy = Core.camera.position.y / 8.0f;
        dx = Mathf.clamp(dx, sz, (float)Vars.world.width() - sz);
        dy = Mathf.clamp(dy, sz, (float)Vars.world.height() - sz);
        float invTexWidth = 1.0f / (float)this.texture.width;
        float invTexHeight = 1.0f / (float)this.texture.height;
        float x = dx - sz;
        float y = (float)Vars.world.height() - dy - sz;
        float width = sz * 2.0f;
        float height = sz * 2.0f;
        this.region.set(x * invTexWidth, y * invTexHeight, (x + width) * invTexWidth, (y + height) * invTexHeight);
        return this.region;
    }

    public void updateAll() {
        if (this.pixmap.isDisposed() || this.texture.isDisposed()) {
            return;
        }
        for (Tile tile : Vars.world.tiles) {
            this.pixmap.set((int)tile.x, this.pixmap.height - 1 - tile.y, this.colorFor(tile));
        }
        this.texture.draw(this.pixmap);
    }

    public void update(Tile tile) {
        if (Vars.world.isGenerating() || !Vars.state.isGame()) {
            return;
        }
        if (tile.build != null && tile.isCenter()) {
            tile.getLinkedTiles(other -> {
                Tile low;
                if (!other.isCenter()) {
                    this.updatePixel((Tile)other);
                }
                if (tile.block().solid && other.y > 0 && !(low = Vars.world.tile(other.x, other.y - 1)).solid()) {
                    this.updatePixel(low);
                }
            });
        }
        this.updatePixel(tile);
    }

    public void updatePixel(Tile tile) {
        this.updates.add(tile.pos());
    }

    public void updateUnitArray() {
        float sz = 16.0f * this.zoom;
        float dx = Core.camera.position.x / 8.0f;
        float dy = Core.camera.position.y / 8.0f;
        dx = Mathf.clamp(dx, sz, (float)Vars.world.width() - sz);
        dy = Mathf.clamp(dy, sz, (float)Vars.world.height() - sz);
        this.units.clear();
        Units.nearby((dx - sz) * 8.0f, (dy - sz) * 8.0f, sz * 2.0f * 8.0f, sz * 2.0f * 8.0f, this.units::add);
    }

    private Block realBlock(Tile tile) {
        return tile.build == null ? tile.block() : (Vars.state.rules.fog && !tile.build.wasVisible ? Blocks.air : tile.block());
    }

    private int colorFor(Tile tile) {
        if (tile == null) {
            return 0;
        }
        Block real = this.realBlock(tile);
        int bc = real.minimapColor(tile);
        if (bc == 0 && tile.block() == Blocks.air && tile.overlay() == Blocks.air) {
            bc = tile.floor().minimapColor(tile);
        }
        Color color = Tmp.c1.set(bc == 0 ? MapIO.colorFor(real, tile.floor(), tile.overlay(), tile.team()) : bc);
        color.mul(1.0f - Mathf.clamp(Vars.world.getDarkness(tile.x, tile.y) / 4.0f));
        if (real == Blocks.air && tile.y < Vars.world.height() - 1 && this.realBlock((Tile)Vars.world.tile((int)tile.x, (int)(tile.y + 1))).solid) {
            color.mul(0.7f);
        } else if (tile.floor().isLiquid && (tile.y >= Vars.world.height() - 1 || !Vars.world.tile((int)tile.x, (int)(tile.y + 1)).floor().isLiquid)) {
            color.mul(0.84f, 0.84f, 0.9f, 1.0f);
        }
        return color.rgba();
    }

    public void drawLabel(float x, float y, String text, Color color, float scaleFactor) {
        Font font = Fonts.outline;
        GlyphLayout l = Pools.obtain(GlyphLayout.class, GlyphLayout::new);
        boolean ints = font.usesIntegerPositions();
        font.getData().setScale(0.8f / Scl.scl(1.0f) * scaleFactor * 1.0f);
        font.setUseIntegerPositions(false);
        l.setText(font, text, color, 90.0f * scaleFactor, 8, false);
        float yOffset = 20.0f;
        float margin = 3.0f * scaleFactor;
        Draw.color(0.0f, 0.0f, 0.0f, 0.2f);
        Fill.rect(x, y + yOffset - l.height / 2.0f, l.width + margin, l.height + margin);
        Draw.color();
        font.setColor(color);
        font.draw(text, x - l.width / 2.0f, y + yOffset, 90.0f * scaleFactor, 8, false);
        font.setUseIntegerPositions(ints);
        font.getData().setScale(1.0f);
        Pools.free(l);
    }
}

