/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.math.Mathf;
import arc.math.geom.Vec2;

public class InverseKinematics {
    private static final Vec2[] mat1 = new Vec2[]{new Vec2(), new Vec2()};
    private static final Vec2[] mat2 = new Vec2[]{new Vec2(), new Vec2()};
    private static final Vec2 temp = new Vec2();
    private static final Vec2 temp2 = new Vec2();
    private static final Vec2 at1 = new Vec2();

    public static boolean solve(float lengthA, float lengthB, Vec2 end, boolean side, Vec2 result) {
        at1.set(end).rotate(side ? 1.0f : -1.0f).setLength(lengthA + lengthB).add(end.x / 2.0f, end.y / 2.0f);
        return InverseKinematics.solve(lengthA, lengthB, end, at1, result);
    }

    public static boolean solve(float lengthA, float lengthB, Vec2 end, Vec2 attractor, Vec2 result) {
        Vec2 axis = mat2[0].set(end).nor();
        mat2[1].set(attractor).sub(temp2.set(axis).scl(attractor.dot(axis))).nor();
        mat1[0].set(InverseKinematics.mat2[0].x, InverseKinematics.mat2[1].x);
        mat1[1].set(InverseKinematics.mat2[0].y, InverseKinematics.mat2[1].y);
        result.set(mat2[0].dot(end), mat2[1].dot(end));
        float len = result.len();
        float dist = Math.max(0.0f, Math.min(lengthA, (len + (lengthA * lengthA - lengthB * lengthB) / len) / 2.0f));
        Vec2 src = temp.set(dist, Mathf.sqrt(lengthA * lengthA - dist * dist));
        result.set(mat1[0].dot(src), mat1[1].dot(src));
        return dist > 0.0f && dist < lengthA;
    }
}

