/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.gen.Player;
import mindustry.gen.Unit;
import mindustry.input.InputHandler;
import mindustry.io.TypeIO;
import mindustry.net.NetConnection;
import mindustry.net.Packet;

public class RequestUnitPayloadCallPacket
extends Packet {
    private byte[] DATA = NODATA;
    public Player player;
    public Unit target;

    @Override
    public void write(Writes WRITE) {
        if (Vars.net.server()) {
            TypeIO.writeEntity(WRITE, this.player);
        }
        TypeIO.writeUnit(WRITE, this.target);
    }

    @Override
    public void read(Reads READ, int LENGTH) {
        this.DATA = READ.b(LENGTH);
    }

    @Override
    public void handled() {
        BAIS.setBytes(this.DATA);
        if (Vars.net.client()) {
            this.player = (Player)TypeIO.readEntity(READ);
        }
        this.target = TypeIO.readUnit(READ);
    }

    @Override
    public void handleServer(NetConnection con) {
        if (con.player == null || con.kicked) {
            return;
        }
        Player player = con.player;
        InputHandler.requestUnitPayload(player, this.target);
    }

    @Override
    public void handleClient() {
        InputHandler.requestUnitPayload(this.player, this.target);
    }
}

