/*
 * Decompiled with CFR 0.152.
 */
package mindustry.game;

import arc.func.Boolf;
import arc.func.Cons;
import arc.func.Prov;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.QuadTree;
import arc.math.geom.Rect;
import arc.struct.IntSeq;
import arc.struct.ObjectMap;
import arc.struct.Queue;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import java.util.Arrays;
import mindustry.Vars;
import mindustry.ai.BaseBuilderAI;
import mindustry.ai.RtsAI;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Groups;
import mindustry.gen.Payloadc;
import mindustry.gen.Player;
import mindustry.gen.Unit;
import mindustry.type.UnitType;
import mindustry.world.Block;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.UnitPayload;
import mindustry.world.blocks.storage.CoreBlock;

public class Teams {
    private TeamData[] map = new TeamData[256];
    public Seq<TeamData> active = new Seq();
    public Seq<TeamData> present = new Seq(TeamData.class);
    public Seq<Unit> bosses = new Seq();

    public Teams() {
        this.active.add(this.get(Team.crux));
    }

    @Nullable
    public CoreBlock.CoreBuild closestEnemyCore(float x, float y, Team team) {
        CoreBlock.CoreBuild closest = null;
        float closestDst = Float.MAX_VALUE;
        for (Team enemy : team.data().coreEnemies) {
            for (CoreBlock.CoreBuild core : enemy.cores()) {
                float dst = Mathf.dst2(x, y, core.getX(), core.getY());
                if (!(closestDst > dst)) continue;
                closest = core;
                closestDst = dst;
            }
        }
        return closest;
    }

    @Nullable
    public CoreBlock.CoreBuild closestCore(float x, float y, Team team) {
        return Geometry.findClosest(x, y, this.get((Team)team).cores);
    }

    public boolean anyEnemyCoresWithinBuildRadius(Team team, float x, float y) {
        for (TeamData data : this.active) {
            if (team == data.team) continue;
            for (CoreBlock.CoreBuild tile : data.cores) {
                if (!tile.within(x, y, Vars.state.rules.buildRadius(tile.team) + 8.0f)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean anyEnemyCoresWithin(Team team, float x, float y, float radius) {
        for (TeamData data : this.active) {
            if (team == data.team) continue;
            for (CoreBlock.CoreBuild tile : data.cores) {
                if (!tile.within(x, y, radius)) continue;
                return true;
            }
        }
        return false;
    }

    public void eachEnemyCore(Team team, Cons<Building> ret) {
        for (TeamData data : this.active) {
            if (team == data.team) continue;
            for (Building building : data.cores) {
                ret.get(building);
            }
        }
    }

    public TeamData get(Team team) {
        TeamData data = this.map[team.id];
        if (data != null) {
            return data;
        }
        this.map[team.id] = new TeamData(team);
        return this.map[team.id];
    }

    @Nullable
    public TeamData getOrNull(Team team) {
        return this.map[team.id];
    }

    public Seq<CoreBlock.CoreBuild> playerCores() {
        return this.get((Team)Vars.state.rules.defaultTeam).cores;
    }

    public Seq<CoreBlock.CoreBuild> cores(Team team) {
        return this.get((Team)team).cores;
    }

    public boolean isActive(Team team) {
        return this.get(team).active();
    }

    public boolean canInteract(Team team, Team other) {
        return team == other || other == Team.derelict;
    }

    public Seq<TeamData> getActive() {
        this.active.removeAll(t -> !t.active());
        return this.active;
    }

    public void updateActive(Team team) {
        TeamData data = this.get(team);
        if (data.active() && !this.active.contains(data)) {
            this.active.add(data);
            this.updateEnemies();
        }
    }

    public void registerCore(CoreBlock.CoreBuild core) {
        TeamData data = this.get(core.team);
        if (!data.cores.contains(core)) {
            data.cores.add(core);
        }
        if (data.active() && !this.active.contains(data)) {
            this.active.add(data);
            this.updateEnemies();
        }
    }

    public void unregisterCore(CoreBlock.CoreBuild entity) {
        TeamData data = this.get(entity.team);
        data.cores.remove(entity);
        if (!data.active()) {
            this.active.remove(data);
            this.updateEnemies();
        }
    }

    private void count(Unit unit) {
        unit.team.data().updateCount(unit.type, 1);
        if (unit instanceof Payloadc) {
            Payloadc payloadc = (Payloadc)((Object)unit);
            Seq<Payload> payloads = payloadc.payloads();
            for (int i = 0; i < payloads.size; ++i) {
                Payload payload = payloads.get(i);
                if (!(payload instanceof UnitPayload)) continue;
                UnitPayload payload2 = (UnitPayload)payload;
                this.count(payload2.unit);
            }
        }
    }

    public void updateTeamStats() {
        TeamData data;
        this.present.clear();
        this.bosses.clear();
        for (Team team : Team.all) {
            data = team.data();
            data.presentFlag = data.buildings.size > 0;
            data.unitCount = 0;
            data.units.clear();
            data.players.clear();
            if (data.cores.size > 0) {
                data.lastCore = data.cores.first();
            }
            if (data.unitTree != null) {
                data.unitTree.clear();
            }
            if (data.typeCounts != null) {
                Arrays.fill(data.typeCounts, 0);
            }
            if (data.unitsByType == null) continue;
            for (int i = 0; i < data.unitsByType.length; ++i) {
                if (data.unitsByType[i] == null) continue;
                data.unitsByType[i].clear();
            }
        }
        for (Unit unit : Groups.unit) {
            if (unit.type == null) continue;
            TeamData data2 = unit.team.data();
            data2.tree().insert(unit);
            data2.units.add(unit);
            data2.presentFlag = true;
            if (unit.team == Vars.state.rules.waveTeam && unit.isBoss()) {
                this.bosses.add(unit);
            }
            if (data2.unitsByType == null || data2.unitsByType.length <= unit.type.id) {
                data2.unitsByType = new Seq[Vars.content.units().size];
            }
            if (data2.unitsByType[unit.type.id] == null) {
                data2.unitsByType[unit.type.id] = new Seq();
            }
            data2.unitsByType[unit.type.id].add(unit);
            this.count(unit);
        }
        for (Player player : Groups.player) {
            player.team().data().players.add(player);
        }
        for (Team team : Team.all) {
            data = team.data();
            if (!data.presentFlag && !data.active()) continue;
            this.present.add(data);
        }
    }

    private void updateEnemies() {
        if (Vars.state.rules.waves && !this.active.contains(this.get(Vars.state.rules.waveTeam))) {
            this.active.add(this.get(Vars.state.rules.waveTeam));
        }
        for (TeamData data : this.active) {
            Seq<Team> enemies = new Seq<Team>();
            for (TeamData other : this.active) {
                if (data.team == other.team) continue;
                enemies.add(other.team);
            }
            data.coreEnemies = (Team[])enemies.toArray(Team.class);
        }
    }

    public static void destroyPayload(Building build) {
        Payload payload;
        if (build != null && build.getPayload() instanceof UnitPayload && (payload = build.takePayload()) instanceof UnitPayload) {
            UnitPayload unit = (UnitPayload)payload;
            unit.dump();
            unit.unit.killed();
        }
    }

    public static class TeamData {
        private static final IntSeq derelictBuffer = new IntSeq();
        public final Team team;
        @Nullable
        public BaseBuilderAI buildAi;
        @Nullable
        public RtsAI rtsAi;
        private boolean presentFlag;
        public Team[] coreEnemies = new Team[0];
        public Queue<BlockPlan> plans = new Queue<BlockPlan>(16, BlockPlan.class);
        public final Seq<CoreBlock.CoreBuild> cores = new Seq();
        @Nullable
        public CoreBlock.CoreBuild lastCore;
        @Nullable
        public QuadTree<Building> buildingTree;
        @Nullable
        public QuadTree<Building> turretTree;
        @Nullable
        public QuadTree<Unit> unitTree;
        public int unitCap;
        public int unitCount;
        @Nullable
        public int[] typeCounts;
        public ObjectMap<Block, Seq<Building>> buildingTypes = new ObjectMap();
        public Seq<Unit> units = new Seq(false);
        public Seq<Player> players = new Seq(false);
        public Seq<Building> buildings = new Seq(false);
        @Nullable
        public Seq<Unit>[] unitsByType;

        public TeamData(Team team) {
            this.team = team;
        }

        public Seq<Building> getBuildings(Block block) {
            return (Seq)((Object)this.buildingTypes.get(block, (Seq<Building>)((Object)((Prov<Seq>)() -> new Seq(false)))));
        }

        public int getCount(Block block) {
            Seq<Building> res = this.buildingTypes.get(block);
            return res == null ? 0 : res.size;
        }

        public void destroyToDerelict() {
            Seq builds = new Seq();
            if (this.buildingTree != null) {
                this.buildingTree.getObjects(builds);
            }
            this.plans.clear();
            for (Building b : builds) {
                if (b.block.privileged) continue;
                if (b instanceof CoreBlock.CoreBuild) {
                    b.kill();
                    continue;
                }
                this.scheduleDerelict(b);
            }
            this.finishScheduleDerelict();
            this.units.each(u -> Time.run(Mathf.random(0.0f, 300.0f), () -> {
                if (u.team == this.team) {
                    u.kill();
                }
            }));
        }

        public void timeDestroy(float x, float y, float range) {
            Seq builds = new Seq();
            if (this.buildingTree != null) {
                this.buildingTree.intersect(x - range, y - range, range * 2.0f, range * 2.0f, builds);
            }
            for (Building build : builds) {
                if (build.block.privileged || !build.within(x, y, range) || this.cores.contains((CoreBlock.CoreBuild)((Object)((Boolf<CoreBlock.CoreBuild>)c -> c.within(build, range))))) continue;
                this.scheduleDerelict(build);
            }
            this.finishScheduleDerelict();
        }

        private void scheduleDerelict(Building build) {
            derelictBuffer.add(build.pos());
            if (build.getPayload() instanceof UnitPayload) {
                Call.destroyPayload(build);
            }
            if (Mathf.chance(0.2)) {
                Time.run(Mathf.random(0.0f, 360.0f), build::kill);
            }
            build.addPlan(false, true);
        }

        private void finishScheduleDerelict() {
            derelictBuffer.chunked(1000, values -> Call.setTeams(values, Team.derelict));
            derelictBuffer.clear();
        }

        @Nullable
        public Seq<Unit> getUnits(UnitType type) {
            return this.unitCache(type);
        }

        @Nullable
        public Seq<Unit> unitCache(UnitType type) {
            if (this.unitsByType == null || this.unitsByType.length <= type.id || this.unitsByType[type.id] == null) {
                return null;
            }
            return this.unitsByType[type.id];
        }

        public void updateCount(UnitType type, int amount) {
            if (type == null) {
                return;
            }
            this.unitCount = Math.max(amount + this.unitCount, 0);
            if (this.typeCounts == null || this.typeCounts.length <= type.id) {
                this.typeCounts = new int[Vars.content.units().size];
            }
            this.typeCounts[type.id] = Math.max(amount + this.typeCounts[type.id], 0);
        }

        public QuadTree<Unit> tree() {
            if (this.unitTree == null) {
                this.unitTree = new QuadTree(Vars.world.getQuadBounds(new Rect()));
            }
            return this.unitTree;
        }

        public int countType(UnitType type) {
            return this.typeCounts == null || this.typeCounts.length <= type.id ? 0 : this.typeCounts[type.id];
        }

        public boolean active() {
            return this.team == Vars.state.rules.waveTeam && Vars.state.rules.waves || this.cores.size > 0 || this.buildings.size > 0 || this.team == Team.neoplastic && this.units.size > 0;
        }

        public boolean hasCore() {
            return this.cores.size > 0;
        }

        public boolean isAlive() {
            return this.hasCore();
        }

        public boolean noCores() {
            return this.cores.isEmpty();
        }

        @Nullable
        public CoreBlock.CoreBuild core() {
            return this.cores.isEmpty() ? null : this.cores.first();
        }

        public boolean hasAI() {
            return this.team.rules().rtsAi || this.team.rules().buildAi;
        }

        public String toString() {
            return "TeamData{cores=" + this.cores + ", team=" + this.team + '}';
        }
    }

    public static class BlockPlan {
        public final short x;
        public final short y;
        public final short rotation;
        public final Block block;
        public final Object config;
        public boolean removed;

        public BlockPlan(int x, int y, short rotation, Block block, Object config) {
            this.x = (short)x;
            this.y = (short)y;
            this.rotation = rotation;
            this.block = block;
            this.config = config;
        }

        public String toString() {
            return "BlockPlan{x=" + this.x + ", y=" + this.y + ", rotation=" + this.rotation + ", block=" + this.block + ", config=" + this.config + '}';
        }
    }
}

