/*
 * Decompiled with CFR 0.152.
 */
package arc.math.geom;

import arc.func.Intc;
import arc.math.geom.Rect;
import arc.struct.IntSeq;

public class IntQuadTree {
    protected final Rect tmp = new Rect();
    protected static final int maxObjectsPerNode = 5;
    public IntQuadTreeProvider prov;
    public Rect bounds;
    public IntSeq objects = new IntSeq(false, 10);
    public IntQuadTree botLeft;
    public IntQuadTree botRight;
    public IntQuadTree topLeft;
    public IntQuadTree topRight;
    public boolean leaf = true;
    public int totalObjects;

    public IntQuadTree(Rect bounds, IntQuadTreeProvider prov) {
        this.bounds = bounds;
        this.prov = prov;
    }

    protected void split() {
        if (!this.leaf) {
            return;
        }
        float subW = this.bounds.width / 2.0f;
        float subH = this.bounds.height / 2.0f;
        if (this.botLeft == null) {
            this.botLeft = this.newChild(new Rect(this.bounds.x, this.bounds.y, subW, subH));
            this.botRight = this.newChild(new Rect(this.bounds.x + subW, this.bounds.y, subW, subH));
            this.topLeft = this.newChild(new Rect(this.bounds.x, this.bounds.y + subH, subW, subH));
            this.topRight = this.newChild(new Rect(this.bounds.x + subW, this.bounds.y + subH, subW, subH));
        }
        this.leaf = false;
        for (int i = 0; i < this.objects.size; ++i) {
            int obj = this.objects.items[i];
            this.hitbox(obj);
            IntQuadTree child = this.getFittingChild(this.tmp);
            if (child == null) continue;
            child.insert(obj);
            this.objects.removeIndex(i);
            --i;
        }
    }

    protected void unsplit() {
        if (this.leaf) {
            return;
        }
        this.objects.addAll(this.botLeft.objects);
        this.objects.addAll(this.botRight.objects);
        this.objects.addAll(this.topLeft.objects);
        this.objects.addAll(this.topRight.objects);
        this.botLeft.clear();
        this.botRight.clear();
        this.topLeft.clear();
        this.topRight.clear();
        this.leaf = true;
    }

    public void insert(int obj) {
        this.hitbox(obj);
        if (!this.bounds.overlaps(this.tmp)) {
            return;
        }
        ++this.totalObjects;
        if (this.leaf && this.objects.size + 1 > 5) {
            this.split();
        }
        if (this.leaf) {
            this.objects.add(obj);
        } else {
            this.hitbox(obj);
            IntQuadTree child = this.getFittingChild(this.tmp);
            if (child != null) {
                child.insert(obj);
            } else {
                this.objects.add(obj);
            }
        }
    }

    public boolean remove(int obj) {
        boolean result;
        if (this.leaf) {
            result = this.objects.removeValue(obj);
        } else {
            this.hitbox(obj);
            IntQuadTree child = this.getFittingChild(this.tmp);
            result = child != null ? child.remove(obj) : this.objects.removeValue(obj);
            if (this.totalObjects <= 5) {
                this.unsplit();
            }
        }
        if (result) {
            --this.totalObjects;
        }
        return result;
    }

    public void clear() {
        this.objects.clear();
        this.totalObjects = 0;
        if (!this.leaf) {
            this.topLeft.clear();
            this.topRight.clear();
            this.botLeft.clear();
            this.botRight.clear();
        }
        this.leaf = true;
    }

    protected IntQuadTree getFittingChild(Rect boundingBox) {
        boolean bottomQuadrant;
        float verticalMidpoint = this.bounds.x + this.bounds.width / 2.0f;
        float horizontalMidpoint = this.bounds.y + this.bounds.height / 2.0f;
        boolean topQuadrant = boundingBox.y > horizontalMidpoint;
        boolean bl = bottomQuadrant = boundingBox.y < horizontalMidpoint && boundingBox.y + boundingBox.height < horizontalMidpoint;
        if (boundingBox.x < verticalMidpoint && boundingBox.x + boundingBox.width < verticalMidpoint) {
            if (topQuadrant) {
                return this.topLeft;
            }
            if (bottomQuadrant) {
                return this.botLeft;
            }
        } else if (boundingBox.x > verticalMidpoint) {
            if (topQuadrant) {
                return this.topRight;
            }
            if (bottomQuadrant) {
                return this.botRight;
            }
        }
        return null;
    }

    public void intersect(float x, float y, float width, float height, Intc out) {
        if (!this.leaf) {
            if (this.topLeft.bounds.overlaps(x, y, width, height)) {
                this.topLeft.intersect(x, y, width, height, out);
            }
            if (this.topRight.bounds.overlaps(x, y, width, height)) {
                this.topRight.intersect(x, y, width, height, out);
            }
            if (this.botLeft.bounds.overlaps(x, y, width, height)) {
                this.botLeft.intersect(x, y, width, height, out);
            }
            if (this.botRight.bounds.overlaps(x, y, width, height)) {
                this.botRight.intersect(x, y, width, height, out);
            }
        }
        IntSeq objects = this.objects;
        for (int i = 0; i < objects.size; ++i) {
            int item = objects.items[i];
            this.hitbox(item);
            if (!this.tmp.overlaps(x, y, width, height)) continue;
            out.get(item);
        }
    }

    public boolean any(float x, float y, float width, float height) {
        if (!this.leaf) {
            if (this.topLeft.bounds.overlaps(x, y, width, height) && this.topLeft.any(x, y, width, height)) {
                return true;
            }
            if (this.topRight.bounds.overlaps(x, y, width, height) && this.topRight.any(x, y, width, height)) {
                return true;
            }
            if (this.botLeft.bounds.overlaps(x, y, width, height) && this.botLeft.any(x, y, width, height)) {
                return true;
            }
            if (this.botRight.bounds.overlaps(x, y, width, height) && this.botRight.any(x, y, width, height)) {
                return true;
            }
        }
        IntSeq objects = this.objects;
        for (int i = 0; i < objects.size; ++i) {
            int item = objects.items[i];
            this.hitbox(item);
            if (!this.tmp.overlaps(x, y, width, height)) continue;
            return true;
        }
        return false;
    }

    public void intersect(Rect rect, Intc out) {
        this.intersect(rect.x, rect.y, rect.width, rect.height, out);
    }

    public void intersect(Rect toCheck, IntSeq out) {
        this.intersect(toCheck.x, toCheck.y, toCheck.width, toCheck.height, out);
    }

    public void intersect(float x, float y, float width, float height, IntSeq out) {
        if (!this.leaf) {
            if (this.topLeft.bounds.overlaps(x, y, width, height)) {
                this.topLeft.intersect(x, y, width, height, out);
            }
            if (this.topRight.bounds.overlaps(x, y, width, height)) {
                this.topRight.intersect(x, y, width, height, out);
            }
            if (this.botLeft.bounds.overlaps(x, y, width, height)) {
                this.botLeft.intersect(x, y, width, height, out);
            }
            if (this.botRight.bounds.overlaps(x, y, width, height)) {
                this.botRight.intersect(x, y, width, height, out);
            }
        }
        IntSeq objects = this.objects;
        for (int i = 0; i < objects.size; ++i) {
            int item = objects.items[i];
            this.hitbox(item);
            if (!this.tmp.overlaps(x, y, width, height)) continue;
            out.add(item);
        }
    }

    public void getObjects(IntSeq out) {
        out.addAll(this.objects);
        if (!this.leaf) {
            this.topLeft.getObjects(out);
            this.topRight.getObjects(out);
            this.botLeft.getObjects(out);
            this.botRight.getObjects(out);
        }
    }

    protected IntQuadTree newChild(Rect rect) {
        return new IntQuadTree(rect, this.prov);
    }

    protected void hitbox(int t) {
        this.prov.hitbox(t, this.tmp);
    }

    public static interface IntQuadTreeProvider {
        public void hitbox(int var1, Rect var2);
    }
}

