/*
 * Decompiled with CFR 0.152.
 */
package arc.freetype;

import arc.assets.AssetDescriptor;
import arc.assets.AssetLoaderParameters;
import arc.assets.AssetManager;
import arc.assets.loaders.AsynchronousAssetLoader;
import arc.assets.loaders.FileHandleResolver;
import arc.files.Fi;
import arc.freetype.FreeTypeFontGenerator;
import arc.graphics.g2d.Font;
import arc.struct.Seq;

public class FreetypeFontLoader
extends AsynchronousAssetLoader<Font, FreeTypeFontLoaderParameter> {
    public FreetypeFontLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, Fi file, FreeTypeFontLoaderParameter parameter) {
        if (parameter == null) {
            throw new RuntimeException("FreetypeFontParameter must be set in AssetManager#load to point at a TTF file!");
        }
    }

    @Override
    public Font loadSync(AssetManager manager, String fileName, Fi file, FreeTypeFontLoaderParameter parameter) {
        if (parameter == null) {
            throw new RuntimeException("FreetypeFontParameter must be set in AssetManager#load to point at a TTF file!");
        }
        FreeTypeFontGenerator generator = manager.get(parameter.fontFileName + ".gen", FreeTypeFontGenerator.class);
        return generator.generateFont(parameter.fontParameters);
    }

    @Override
    public Seq<AssetDescriptor> getDependencies(String fileName, Fi file, FreeTypeFontLoaderParameter parameter) {
        Seq<AssetDescriptor> deps = new Seq<AssetDescriptor>();
        deps.add(new AssetDescriptor<FreeTypeFontGenerator>(parameter.fontFileName + ".gen", FreeTypeFontGenerator.class));
        return deps;
    }

    public static class FreeTypeFontLoaderParameter
    extends AssetLoaderParameters<Font> {
        public String fontFileName;
        public FreeTypeFontGenerator.FreeTypeFontParameter fontParameters = new FreeTypeFontGenerator.FreeTypeFontParameter();

        public FreeTypeFontLoaderParameter() {
        }

        public FreeTypeFontLoaderParameter(String fontFileName, FreeTypeFontGenerator.FreeTypeFontParameter fontParameters) {
            this.fontFileName = fontFileName;
            this.fontParameters = fontParameters;
        }
    }
}

