/*
 * Decompiled with CFR 0.152.
 */
package mindustry.mod;

import arc.func.Cons;
import arc.func.Prov;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.struct.OrderedMap;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Reflect;
import arc.util.Strings;
import arc.util.serialization.Json;
import arc.util.serialization.JsonValue;
import arc.util.serialization.Jval;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Locale;
import mindustry.Vars;
import mindustry.core.ContentLoader;
import mindustry.ctype.Content;
import mindustry.ctype.ContentType;
import mindustry.ctype.MappableContent;
import mindustry.mod.NoPatch;

public class ContentPatcher {
    private static final Object root = new Object();
    private static final ObjectMap<String, ContentType> nameToType = new ObjectMap();
    private Json json;
    private boolean applied;
    private ContentLoader contentLoader;
    private ObjectSet<PatchRecord> usedpatches = new ObjectSet();
    private Seq<Runnable> resetters = new Seq();
    private Seq<Runnable> afterCallbacks = new Seq();

    public void apply(String patch) throws Exception {
        this.json = Vars.mods.getContentParser().getJson();
        this.applied = true;
        this.contentLoader = Vars.content.copy();
        try {
            JsonValue value = (JsonValue)this.json.fromJson(null, Jval.read(patch).toString(Jval.Jformat.plain));
            for (JsonValue child : value) {
                this.assign(root, child.name, child, null, null, null);
            }
            this.afterCallbacks.each(Runnable::run);
        }
        catch (Exception e) {
            Log.err("Failed to apply patch: " + patch, e);
        }
    }

    public void unapply() {
        if (!this.applied) {
            return;
        }
        Vars.content = this.contentLoader;
        this.applied = false;
        this.resetters.reverse();
        for (Runnable reset : this.resetters) {
            try {
                reset.run();
            }
            catch (Throwable e) {
                Log.err("Failed to un-apply patch!", e);
            }
        }
        this.resetters.clear();
        this.afterCallbacks.each(Runnable::run);
        this.afterCallbacks.clear();
    }

    void assign(Object object, String field, Object value, @Nullable FieldData metadata, @Nullable Object parentObject, @Nullable String parentField) throws Exception {
        int i;
        if (field == null || field.isEmpty()) {
            return;
        }
        char prefix = '\u0000';
        if (field.charAt(0) == '+') {
            prefix = field.charAt(0);
            field = field.substring(1);
        } else if (field.endsWith(".+")) {
            prefix = field.charAt(field.length() - 1);
            field = field.substring(0, field.length() - 2);
        }
        if (field.indexOf(46) != -1) {
            String[] path = field.split("\\.");
            for (i = 0; i < path.length - 1; ++i) {
                Object[] result = this.resolve(object, path[i], metadata);
                if (result == null) {
                    return;
                }
                object = result[0];
                metadata = (FieldData)result[1];
            }
            field = path[path.length - 1];
        }
        if (object instanceof Content) {
            Content c = (Content)object;
            this.after(c::afterPatch);
        }
        if (object == root) {
            JsonValue jval;
            if (value instanceof JsonValue && (jval = (JsonValue)value).isObject()) {
                for (JsonValue child : jval) {
                    ObjectMap map;
                    Object object2;
                    Object[] otherResolve = this.resolve(object, jval.name, null);
                    if (otherResolve != null && (object2 = otherResolve[0]) instanceof ObjectMap && (map = (ObjectMap)object2).containsKey(child.name)) {
                        this.assign(otherResolve[0], child.name, child, (FieldData)otherResolve[1], object, field);
                        continue;
                    }
                    Log.warn("Content not found: @.@", field, child.name);
                }
            } else {
                this.warn("Content '@' cannot be assigned.", field);
            }
        } else if (object instanceof Seq || object.getClass().isArray()) {
            if (prefix == '+') {
                if (object instanceof Seq) {
                    Seq s = (Seq)object;
                    this.modifiedField(parentObject, parentField, s.copy());
                    this.assignValue(object, field, metadata, () -> null, val -> s.add(val), value, false);
                } else {
                    this.modifiedField(parentObject, parentField, ContentPatcher.copyArray(object));
                    Object fobj = object;
                    this.assignValue(parentObject, parentField, metadata, () -> null, val -> {
                        try {
                            int len = Array.getLength(fobj);
                            Object copy = Array.newInstance(fobj.getClass().getComponentType(), len + 1);
                            Array.set(copy, len - 1, val);
                            System.arraycopy(fobj, 0, copy, 0, len);
                            this.assign(parentObject, parentField, copy, null, null, null);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }, value, false);
                }
            } else {
                int length;
                int n;
                Seq s;
                i = Strings.parseInt(field);
                if (object instanceof Seq) {
                    s = (Seq)object;
                    n = s.size;
                } else {
                    n = length = Array.getLength(object);
                }
                if (i == Integer.MIN_VALUE) {
                    this.warn("Invalid number for array access: '@'", field);
                    return;
                }
                if (i < 0 || i >= length) {
                    this.warn("Number outside of array bounds: '" + field + "' (length is " + length + ")", new Object[0]);
                    return;
                }
                if (object instanceof Seq) {
                    s = (Seq)object;
                    Seq copy = s.copy();
                    this.reset(() -> s.set(copy));
                    this.assignValue(object, field, metadata, () -> s.get(i), val -> s.set(i, val), value, false);
                } else {
                    this.modifiedField(parentObject, parentField, ContentPatcher.copyArray(object));
                    Object fobj = object;
                    this.assignValue(object, field, metadata, () -> Array.get(fobj, i), val -> Array.set(fobj, i, val), value, false);
                }
            }
        } else if (object instanceof ObjectMap) {
            ObjectMap map = (ObjectMap)object;
            if (metadata == null) {
                this.warn("ObjectMap cannot be parsed without metadata: @.@", parentObject, parentField);
                return;
            }
            Object key = this.convertKeyType(field, metadata.keyType);
            if (key == null) {
                this.warn("Null key: '@'", field);
                return;
            }
            ObjectMap copy = map.copy();
            this.reset(() -> map.set(copy));
            this.assignValue(object, field, new FieldData(metadata.elementType, null, null), () -> map.get(key), val -> map.put(key, val), value, false);
        } else {
            OrderedMap<String, Json.FieldMetadata> fields;
            Json.FieldMetadata fdata;
            Class<?> actualType = object.getClass();
            if (actualType.isAnonymousClass()) {
                actualType = actualType.getSuperclass();
            }
            if ((fdata = (Json.FieldMetadata)(fields = this.json.getFields(actualType)).get(field)) != null) {
                if (this.checkField(fdata.field)) {
                    return;
                }
                Object fobj = object;
                this.assignValue(object, field, new FieldData(fdata), () -> Reflect.get(fobj, fdata.field), fv -> Reflect.set(fobj, fdata.field, fv), value, true);
            } else {
                this.warn("Unknown field: '@' for '@'", field, actualType.getName());
            }
        }
    }

    void assignValue(Object object, String field, FieldData metadata, Prov getter, Cons setter, Object value, boolean modify) throws Exception {
        Object prevValue = getter.get();
        if (value instanceof JsonValue) {
            JsonValue jsv = (JsonValue)value;
            if (prevValue == null || !jsv.isObject() || jsv.has("type")) {
                if (modify) {
                    this.modifiedField(object, field, getter.get());
                }
                try {
                    setter.get(this.json.readValue(metadata.type, metadata.elementType, jsv));
                }
                catch (Throwable e) {
                    this.warn("Failed to read value @.@ = @: @ (type = @ elementType = @)", object, field, value, e.getMessage(), metadata.type, metadata.elementType);
                }
            } else {
                OrderedMap<String, Json.FieldMetadata> childFields = this.json.getFields(prevValue.getClass().isAnonymousClass() ? prevValue.getClass().getSuperclass() : prevValue.getClass());
                for (JsonValue child : jsv) {
                    if (child.name == null) continue;
                    this.assign(prevValue, child.name, child, !childFields.containsKey(child.name) ? null : new FieldData((Json.FieldMetadata)childFields.get(child.name)), object, field);
                }
            }
        } else {
            if (modify) {
                this.modifiedField(object, field, prevValue);
            }
            setter.get(value);
        }
    }

    Object[] resolve(Object object, String field, @Nullable FieldData metadata) throws Exception {
        OrderedMap<String, Json.FieldMetadata> fields;
        Json.FieldMetadata fdata;
        if (object == null) {
            return null;
        }
        if (object == root) {
            ContentType ctype = nameToType.get(field);
            if (ctype == null) {
                this.warn("Invalid content type: " + field, new Object[0]);
                return null;
            }
            return new Object[]{Vars.content.getNamesBy(ctype), new FieldData(ObjectMap.class, MappableContent.class, String.class)};
        }
        if (object instanceof Seq || object.getClass().isArray()) {
            Object object2;
            int length;
            int n;
            Seq s;
            int i = Strings.parseInt(field);
            if (object instanceof Seq) {
                s = (Seq)object;
                n = s.size;
            } else {
                n = length = Array.getLength(object);
            }
            if (i == Integer.MIN_VALUE) {
                this.warn("Invalid number for array access: '@'", field);
                return null;
            }
            if (i < 0 || i >= length) {
                this.warn("Number outside of array bounds: '" + field + "' (length is " + length + ")", new Object[0]);
                return null;
            }
            Object[] objectArray = new Object[2];
            if (object instanceof Seq) {
                s = (Seq)object;
                object2 = s.get(i);
            } else {
                object2 = Array.get(object, i);
            }
            objectArray[0] = object2;
            objectArray[1] = null;
            return objectArray;
        }
        if (object instanceof ObjectMap) {
            ObjectMap map = (ObjectMap)object;
            Object key = this.convertKeyType(field, metadata.keyType);
            if (key == null) {
                this.warn("Null key: '@'", field);
                return null;
            }
            Object mapValue = map.get(key);
            if (mapValue == null) {
                this.warn("No key found: '@'", field);
                return null;
            }
            return new Object[]{mapValue, null};
        }
        Class<?> actualType = object.getClass();
        if (actualType.isAnonymousClass()) {
            actualType = actualType.getSuperclass();
        }
        if ((fdata = (Json.FieldMetadata)(fields = this.json.getFields(actualType)).get(field)) != null) {
            if (this.checkField(fdata.field)) {
                return null;
            }
            return new Object[]{fdata.field.get(object), new FieldData(fdata)};
        }
        this.warn("Unknown field: '@' for '@'", field, actualType.getName());
        return null;
    }

    boolean checkField(Field field) {
        if (field.isAnnotationPresent(NoPatch.class) || field.getDeclaringClass().isAnnotationPresent(NoPatch.class)) {
            this.warn("Field '@' cannot be edited.", field);
            return true;
        }
        return false;
    }

    void modifiedField(Object target, String field, Object value) {
        if (!this.applied || target == null) {
            return;
        }
        OrderedMap<String, Json.FieldMetadata> fields = this.json.getFields(target.getClass());
        Json.FieldMetadata meta = (Json.FieldMetadata)fields.get(field);
        if (meta != null) {
            PatchRecord record = new PatchRecord(target, meta.field, value);
            if (this.usedpatches.add(record)) {
                this.resetters.add(() -> {
                    try {
                        record.field.set(record.target, record.value);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        } else {
            this.warn("Missing field " + field + " for object " + target, new Object[0]);
        }
    }

    void reset(Runnable run) {
        this.resetters.add(run);
    }

    Object convertKeyType(String string, Class<?> type) {
        return this.json.fromJson(type, string);
    }

    void warn(String error, Object ... fmt) {
        Log.warn(error, fmt);
    }

    void after(Runnable run) {
        this.afterCallbacks.add(run);
    }

    static Object copyArray(Object object) {
        if (object instanceof int[]) {
            int[] i = (int[])object;
            return i.clone();
        }
        if (object instanceof long[]) {
            long[] i = (long[])object;
            return i.clone();
        }
        if (object instanceof short[]) {
            short[] i = (short[])object;
            return i.clone();
        }
        if (object instanceof byte[]) {
            byte[] i = (byte[])object;
            return i.clone();
        }
        if (object instanceof boolean[]) {
            boolean[] i = (boolean[])object;
            return i.clone();
        }
        if (object instanceof char[]) {
            char[] i = (char[])object;
            return i.clone();
        }
        if (object instanceof float[]) {
            float[] i = (float[])object;
            return i.clone();
        }
        if (object instanceof double[]) {
            double[] i = (double[])object;
            return i.clone();
        }
        return ((Object[])object).clone();
    }

    static {
        for (ContentType type : ContentType.all) {
            if (type.name().indexOf(95) != -1) continue;
            nameToType.put(type.toString().toLowerCase(Locale.ROOT), type);
        }
    }

    private static class FieldData {
        Class type;
        Class elementType;
        Class keyType;

        public FieldData(Class type, Class elementType, Class keyType) {
            this.type = type;
            this.elementType = elementType;
            this.keyType = keyType;
        }

        public FieldData(Json.FieldMetadata data) {
            this(data.field.getType(), data.elementType, data.keyType);
        }
    }

    private static class PatchRecord {
        Object target;
        Field field;
        Object value;

        PatchRecord(Object target, Field field, Object value) {
            this.target = target;
            this.field = field;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PatchRecord that = (PatchRecord)o;
            return this.target.equals(that.target) && this.field.equals(that.field);
        }

        public int hashCode() {
            int result = this.target.hashCode();
            result = 31 * result + this.field.hashCode();
            return result;
        }
    }
}

