/*
 * Decompiled with CFR 0.152.
 */
package mindustry.core;

import arc.Events;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.game.EventType;
import mindustry.game.GameStats;
import mindustry.game.MapMarkers;
import mindustry.game.Rules;
import mindustry.game.Teams;
import mindustry.gen.Unit;
import mindustry.maps.Map;
import mindustry.mod.ContentPatcher;
import mindustry.type.MapLocales;
import mindustry.type.Planet;
import mindustry.type.Sector;
import mindustry.world.blocks.Attributes;

public class GameState {
    public int wave = 1;
    public float wavetime;
    public double tick;
    public long updateId;
    public boolean gameOver = false;
    public boolean afterGameOver = false;
    public boolean won = false;
    public int serverTps = -1;
    public Map map = Vars.emptyMap;
    public Rules rules = new Rules();
    public GameStats stats = new GameStats();
    public MapMarkers markers = new MapMarkers();
    public MapLocales mapLocales = new MapLocales();
    public Attributes envAttrs = new Attributes();
    public Teams teams = new Teams();
    public int enemies;
    @Nullable
    public Map playtestingMap;
    @Nullable
    public ContentPatcher patcher;
    private State state = State.menu;

    @Nullable
    public Unit boss() {
        return this.teams.bosses.firstOpt();
    }

    public void set(State astate) {
        if (this.state == astate) {
            return;
        }
        Events.fire(new EventType.StateChangeEvent(this.state, astate));
        this.state = astate;
    }

    public boolean hasSpawns() {
        return this.rules.waves && (this.rules.waveTeam.cores().size > 0 && this.rules.attackMode || this.rules.spawns.size > 0);
    }

    public boolean isCampaign() {
        return this.rules.sector != null;
    }

    public boolean hasSector() {
        return this.rules.sector != null;
    }

    @Nullable
    public Sector getSector() {
        return this.rules.sector;
    }

    @Nullable
    public Planet getPlanet() {
        return this.rules.sector != null ? this.rules.sector.planet : this.rules.planet;
    }

    public boolean isEditor() {
        return this.rules.editor;
    }

    public boolean isPaused() {
        return this.state == State.paused;
    }

    public boolean isPlaying() {
        return this.state == State.playing;
    }

    public boolean isGame() {
        return this.state != State.menu;
    }

    public boolean isMenu() {
        return this.state == State.menu;
    }

    public boolean is(State astate) {
        return this.state == astate;
    }

    public State getState() {
        return this.state;
    }

    public static enum State {
        paused,
        playing,
        menu;

    }
}

