/*
 * Decompiled with CFR 0.152.
 */
package arc.scene.actions;

import arc.scene.Action;
import arc.scene.Element;
import arc.scene.actions.DelegateAction;
import arc.struct.Seq;

public class AfterAction
extends DelegateAction {
    private Seq<Action> waitForActions = new Seq(false, 4);

    @Override
    public void setTarget(Element target) {
        if (target != null) {
            this.waitForActions.addAll(target.getActions());
        }
        super.setTarget(target);
    }

    @Override
    public void restart() {
        super.restart();
        this.waitForActions.clear();
    }

    @Override
    protected boolean delegate(float delta) {
        Seq<Action> currentActions = this.target.getActions();
        if (currentActions.size == 1) {
            this.waitForActions.clear();
        }
        for (int i = this.waitForActions.size - 1; i >= 0; --i) {
            Action action = this.waitForActions.get(i);
            int index = currentActions.indexOf(action, true);
            if (index != -1) continue;
            this.waitForActions.remove(i);
        }
        return this.waitForActions.size <= 0 && this.action.act(delta);
    }
}

