/*
 * Decompiled with CFR 0.152.
 */
package mindustry.mod;

import arc.func.Cons;
import arc.func.Prov;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.struct.OrderedMap;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Reflect;
import arc.util.Strings;
import arc.util.serialization.Json;
import arc.util.serialization.JsonValue;
import arc.util.serialization.Jval;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Locale;
import mindustry.Vars;
import mindustry.core.ContentLoader;
import mindustry.ctype.ContentType;
import mindustry.ctype.MappableContent;
import mindustry.mod.NoPatch;

public class ContentPatcher {
    private static final Object root = new Object();
    private static final ObjectMap<String, ContentType> nameToType = new ObjectMap();
    private Json json;
    private boolean applied;
    private ContentLoader contentLoader;
    private ObjectSet<PatchRecord> usedpatches = new ObjectSet();
    private Seq<PatchRecord> patches = new Seq();
    private Seq<Runnable> resetters = new Seq();

    public void apply(String patch) throws Exception {
        this.json = Vars.mods.getContentParser().getJson();
        this.applied = true;
        this.contentLoader = Vars.content.copy();
        JsonValue value = (JsonValue)this.json.fromJson(null, Jval.read(patch).toString(Jval.Jformat.plain));
        for (JsonValue child : value) {
            this.assign(root, child.name, child, null, null, null);
        }
    }

    public void unapply() throws Exception {
        if (!this.applied) {
            return;
        }
        Vars.content = this.contentLoader;
        this.applied = false;
        for (PatchRecord record : this.patches) {
            this.assign(record.target, record.field, record.value, record.data, null, null);
        }
        this.resetters.each(Runnable::run);
        this.resetters.clear();
    }

    void assign(Object object, String field, Object value, @Nullable Json.FieldMetadata metadata, @Nullable Object parentObject, @Nullable String parentField) throws Exception {
        int i;
        if (field == null || field.isEmpty()) {
            return;
        }
        if (field.charAt(0) == '-' || field.charAt(0) == '+') {
            char prefix = field.charAt(0);
            field = field.substring(1) + "." + prefix;
        }
        if (field.indexOf(46) != -1) {
            String[] path = field.split("\\.");
            for (i = 0; i < path.length - 1; ++i) {
                Object[] result = this.resolve(object, path[i], null, null);
                if (result == null) {
                    return;
                }
                object = result[0];
                metadata = (Json.FieldMetadata)result[1];
            }
            field = path[path.length - 1];
        }
        if (object == root) {
            this.warn("Content cannot be assigned.", new Object[0]);
        } else if (object instanceof Seq || object.getClass().isArray()) {
            if (field.length() == 1 && field.charAt(0) == '+') {
                if (object instanceof Seq) {
                    Seq s = (Seq)object;
                    this.modified(parentObject, parentField, s.copy(), null);
                    this.assignValue(object, field, metadata, () -> null, val -> s.add(val), value, false);
                } else {
                    this.modified(parentObject, parentField, ContentPatcher.copyArray(object), null);
                    Object fobj = object;
                    this.assignValue(parentObject, parentField, metadata, () -> null, val -> {
                        try {
                            int len = Array.getLength(fobj);
                            Object copy = Array.newInstance(fobj.getClass().getComponentType(), len + 1);
                            Array.set(copy, len - 1, val);
                            System.arraycopy(fobj, 0, copy, 0, len);
                            this.assign(parentObject, parentField, copy, null, null, null);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }, value, false);
                }
            } else {
                int length;
                int n;
                Seq s;
                i = Strings.parseInt(field);
                if (object instanceof Seq) {
                    s = (Seq)object;
                    n = s.size;
                } else {
                    n = length = Array.getLength(object);
                }
                if (i == Integer.MIN_VALUE) {
                    this.warn("Invalid number for array access: '@'", field);
                    return;
                }
                if (i < 0 || i >= length) {
                    this.warn("Number outside of array bounds: '" + field + "' (length is " + length + ")", new Object[0]);
                    return;
                }
                if (object instanceof Seq) {
                    s = (Seq)object;
                    this.modified(parentObject, parentField, s.copy(), null);
                    this.assignValue(object, field, metadata, () -> s.get(i), val -> s.set(i, val), value, false);
                } else {
                    this.modified(parentObject, parentField, ContentPatcher.copyArray(object), null);
                    Object fobj = object;
                    this.assignValue(object, field, metadata, () -> Array.get(fobj, i), val -> Array.set(fobj, i, val), value, false);
                }
            }
        } else if (object instanceof ObjectMap) {
            ObjectMap map = (ObjectMap)object;
            if (metadata == null) {
                this.warn("ObjectMap cannot be parsed without metadata.", new Object[0]);
                return;
            }
            Object key = this.convertKeyType(field, metadata.keyType);
            if (key == null) {
                this.warn("Null key: '@'", field);
                return;
            }
            this.modified(parentObject, parentField, map.copy(), metadata);
            this.assignValue(object, field, metadata, () -> map.get(key), val -> map.put(key, val), value, false);
        } else {
            OrderedMap<String, Json.FieldMetadata> fields;
            Json.FieldMetadata fdata;
            Class<?> actualType = object.getClass();
            if (actualType.isAnonymousClass()) {
                actualType = actualType.getSuperclass();
            }
            if ((fdata = (Json.FieldMetadata)(fields = this.json.getFields(actualType)).get(field)) != null) {
                if (this.checkField(fdata.field)) {
                    return;
                }
                Object fobj = object;
                this.assignValue(object, field, metadata, () -> Reflect.get(fobj, fdata.field), fv -> Reflect.set(fobj, fdata.field, fv), value, true);
            } else {
                this.warn("Unknown field: '@' for '@'", field, actualType.getName());
            }
        }
    }

    void assignValue(Object object, String field, Json.FieldMetadata metadata, Prov getter, Cons setter, Object value, boolean modify) throws Exception {
        Object prevValue = getter.get();
        if (value instanceof JsonValue) {
            JsonValue jsv = (JsonValue)value;
            if (prevValue == null) {
                if (modify) {
                    this.modified(object, field, null, metadata);
                }
                setter.get(this.json.readValue(metadata.field.getType(), metadata.elementType, jsv));
            } else {
                OrderedMap<String, Json.FieldMetadata> childFields = this.json.getFields(prevValue.getClass().isAnonymousClass() ? prevValue.getClass().getSuperclass() : prevValue.getClass());
                for (JsonValue child : jsv) {
                    if (child.name == null) continue;
                    this.assign(prevValue, child.name, child, (Json.FieldMetadata)childFields.get(child.name), object, field);
                }
            }
        } else {
            if (modify) {
                this.modified(object, field, prevValue, metadata);
            }
            setter.get(value);
        }
    }

    Object[] resolve(Object object, String field, Object value, @Nullable Json.FieldMetadata metadata) throws Exception {
        OrderedMap<String, Json.FieldMetadata> fields;
        Json.FieldMetadata fdata;
        if (object == null) {
            return null;
        }
        if (object == root) {
            ContentType ctype = nameToType.get(field);
            if (ctype == null) {
                this.warn("Invalid content type: " + field, new Object[0]);
                return null;
            }
            return new Object[]{Vars.content.getNamesBy(ctype), new Json.FieldMetadata(null, MappableContent.class, String.class)};
        }
        if (object instanceof Seq || object.getClass().isArray()) {
            Object object2;
            int length;
            int n;
            Seq s;
            int i = Strings.parseInt(field);
            if (object instanceof Seq) {
                s = (Seq)object;
                n = s.size;
            } else {
                n = length = Array.getLength(object);
            }
            if (i == Integer.MIN_VALUE) {
                this.warn("Invalid number for array access: '@'", field);
                return null;
            }
            if (i < 0 || i >= length) {
                this.warn("Number outside of array bounds: '" + field + "' (length is " + length + ")", new Object[0]);
                return null;
            }
            Object[] objectArray = new Object[2];
            if (object instanceof Seq) {
                s = (Seq)object;
                object2 = s.get(i);
            } else {
                object2 = Array.get(object, i);
            }
            objectArray[0] = object2;
            objectArray[1] = null;
            return objectArray;
        }
        if (object instanceof ObjectMap) {
            ObjectMap map = (ObjectMap)object;
            Object key = this.convertKeyType(field, metadata.keyType);
            if (key == null) {
                this.warn("Null key: '@'", field);
                return null;
            }
            Object mapValue = map.get(key);
            if (mapValue == null) {
                this.warn("No key found: '@'", field);
                return null;
            }
            return new Object[]{mapValue, null};
        }
        Class<?> actualType = object.getClass();
        if (actualType.isAnonymousClass()) {
            actualType = actualType.getSuperclass();
        }
        if ((fdata = (Json.FieldMetadata)(fields = this.json.getFields(actualType)).get(field)) != null) {
            if (this.checkField(fdata.field)) {
                return null;
            }
            return new Object[]{fdata.field.get(object), fdata};
        }
        this.warn("Unknown field: '@' for '@'", field, actualType.getName());
        return null;
    }

    boolean checkField(Field field) {
        if (field.isAnnotationPresent(NoPatch.class) || field.getDeclaringClass().isAnnotationPresent(NoPatch.class)) {
            this.warn("Field '@' cannot be edited.", field);
            return true;
        }
        return false;
    }

    void modified(Object target, String field, Object value, Json.FieldMetadata data) {
        if (!this.applied) {
            return;
        }
        PatchRecord record = new PatchRecord(target, field, value, data);
        if (this.usedpatches.add(record)) {
            this.patches.add(record);
        }
    }

    Object convertKeyType(String string, Class<?> type) {
        return this.json.fromJson(type, string);
    }

    void warn(String error, Object ... fmt) {
        Log.warn(error, fmt);
    }

    void reset(Runnable run) {
        this.resetters.add(run);
    }

    static Object copyArray(Object object) {
        if (object instanceof int[]) {
            int[] i = (int[])object;
            return i.clone();
        }
        if (object instanceof long[]) {
            long[] i = (long[])object;
            return i.clone();
        }
        if (object instanceof short[]) {
            short[] i = (short[])object;
            return i.clone();
        }
        if (object instanceof byte[]) {
            byte[] i = (byte[])object;
            return i.clone();
        }
        if (object instanceof boolean[]) {
            boolean[] i = (boolean[])object;
            return i.clone();
        }
        if (object instanceof char[]) {
            char[] i = (char[])object;
            return i.clone();
        }
        if (object instanceof float[]) {
            float[] i = (float[])object;
            return i.clone();
        }
        if (object instanceof double[]) {
            double[] i = (double[])object;
            return i.clone();
        }
        return ((Object[])object).clone();
    }

    static {
        for (ContentType type : ContentType.all) {
            if (type.name().indexOf(95) != -1) continue;
            nameToType.put(type.toString().toLowerCase(Locale.ROOT), type);
        }
    }

    private static class PatchRecord {
        Object target;
        String field;
        Object value;
        Json.FieldMetadata data;

        PatchRecord(Object target, String field, Object value, Json.FieldMetadata data) {
            this.target = target;
            this.field = field;
            this.value = value;
            this.data = data;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PatchRecord that = (PatchRecord)o;
            return this.target.equals(that.target) && this.field.equals(that.field);
        }

        public int hashCode() {
            int result = this.target.hashCode();
            result = 31 * result + this.field.hashCode();
            return result;
        }
    }
}

