/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps;

import arc.func.Prov;
import arc.struct.ObjectMap;
import arc.util.Nullable;
import mindustry.content.Planets;
import mindustry.type.Planet;
import mindustry.type.Sector;
import mindustry.type.SectorPreset;

public class SectorSubmissions {
    private static ObjectMap<Sector, MapSubmission> threadMap = new ObjectMap();

    @Nullable
    public static String getSectorThread(Sector sector) {
        if (sector.generateEnemyBase) {
            MapSubmission sub = threadMap.get(sector);
            if (sub == null) {
                return null;
            }
            return sub.mapFileLink.isEmpty() ? sub.threadLink : sub.mapFileLink;
        }
        return null;
    }

    public static void registerSectors() {
        SectorSubmissions.registerSerpuloSector(76, "Skyon", "https://discord.com/channels/391020510269669376/1379926833411391580/1381831690183250056");
        SectorSubmissions.registerSerpuloSector(47, "tinport", "https://discord.com/channels/391020510269669376/1379926802591645820/1397649518203371544");
        SectorSubmissions.registerSerpuloSector(225, "Summi", "https://discord.com/channels/391020510269669376/1379926925719376152/1399286858482978900");
        SectorSubmissions.registerSerpuloSector(111, "gausofid", "https://discord.com/channels/391020510269669376/1379926842659569864/1422257393042985114");
        SectorSubmissions.registerSerpuloSector(176, "wpx", "https://discord.com/channels/391020510269669376/1379926887203213353/1390418885081043135");
        SectorSubmissions.registerSerpuloSector(13, "hoijlhj", "https://discord.com/channels/391020510269669376/1379926785164312810/1402569635299065948");
        SectorSubmissions.registerSerpuloSector(259, "tinport", "https://discord.com/channels/391020510269669376/1379928048245280871/1381300770866987049");
        SectorSubmissions.registerSerpuloSector(192, "Skeledragon", "https://discord.com/channels/391020510269669376/1379926914122256449/1380767793989029923");
        SectorSubmissions.registerSerpuloSector(127, "playfree", "https://discord.com/channels/391020510269669376/1379926869465632829/1380253194428354602");
        SectorSubmissions.registerSerpuloSector(207, "cyan", "https://discord.com/channels/391020510269669376/1379926923370827827/1405919087883976837");
        SectorSubmissions.registerSerpuloSector(94, "Wine", "https://discord.com/channels/391020510269669376/1379926838079393802/1406267666976477196");
        SectorSubmissions.registerSerpuloSector(16, "Namero", "https://discord.com/channels/391020510269669376/1379926788280680579/1409970152283312352");
        SectorSubmissions.registerSerpuloSector(116, "Jamespire", "https://discord.com/channels/391020510269669376/1379926845058711734/1404131805074034712");
        SectorSubmissions.registerSerpuloSector(69, "Oct", "https://discord.com/channels/391020510269669376/1379926831326822610/1406230980120940556");
        SectorSubmissions.registerSerpuloSector(92, "Eggypc/Fish", "https://discord.com/channels/391020510269669376/1379926835621527615/1422178040489971834");
        SectorSubmissions.registerSerpuloSector(197, "Hengryton Luck", "https://discord.com/channels/391020510269669376/1379926916911599676/1411358089759817793");
        SectorSubmissions.registerSerpuloSector(67, "\u1ebech ng\u1ed3i \u0111\u00e1y gi\u1ebfng", "https://discord.com/channels/391020510269669376/1379926828696866898/1389981795386396768");
        SectorSubmissions.registerSerpuloSector(180, "Locla^Glass", "https://discord.com/channels/391020510269669376/1379926889648619580/1413522098370117765");
        SectorSubmissions.registerSerpuloSector(55, "Namero", "https://discord.com/channels/391020510269669376/1379926823277695189/1412588965256761402");
        SectorSubmissions.registerSerpuloSector(19, "Hengryton Luck", "https://discord.com/channels/391020510269669376/1379926792479183019/1411342610525585468");
        SectorSubmissions.registerSerpuloSector(200, "Axye", "https://discord.com/channels/391020510269669376/1379926918429806755/1419180347232485448");
        SectorSubmissions.registerSerpuloSector(191, "Skeledragon", "https://discord.com/channels/391020510269669376/1379926912004001914/1380025875806027849");
        SectorSubmissions.registerSerpuloSector(6, "Namero", "https://discord.com/channels/391020510269669376/1379926782966497322/1415735385828495464");
        SectorSubmissions.registerSerpuloSector(265, "Dem0", "https://discord.com/channels/391020510269669376/1379928052921929891/1420029529619173459");
        SectorSubmissions.registerSerpuloSector(161, "Hengryton Luck", "https://discord.com/channels/391020510269669376/1379926882203730024/1416686287204782217");
        SectorSubmissions.registerSerpuloSector(24, "Stormrider", "https://discord.com/channels/391020510269669376/1379926797042581716/1419213541512187935");
        SectorSubmissions.registerSerpuloSector(263, "ltb12", "https://discord.com/channels/391020510269669376/1379928050010951694/1417750251741249569");
        SectorSubmissions.registerSerpuloSector(66, "quad", "https://discord.com/channels/391020510269669376/1379926825941078128/1417752983889907755");
        SectorSubmissions.registerSerpuloSector(248, "iqtik123", "https://discord.com/channels/391020510269669376/1379926979129774151/1417864622412922890");
        SectorSubmissions.registerSerpuloSector(133, "wpx", "https://discord.com/channels/391020510269669376/1379926871227240770/1417920499761156126");
        SectorSubmissions.registerSerpuloSector(185, "quad", "https://discord.com/channels/391020510269669376/1379926892181983283/1419231958336016458");
        SectorSubmissions.registerSerpuloSector(254, "wpx", "https://discord.com/channels/391020510269669376/1379928045577703424/1420456601667502193");
        SectorSubmissions.registerSerpuloSector(0, "Jamespire", "https://discord.com/channels/391020510269669376/1379926780860698784/1418590967384117311");
        SectorSubmissions.registerSerpuloSector(103, "enwyz", "https://discord.com/channels/391020510269669376/1379926839559979030/1429203869514207255");
    }

    static void registerSerpuloSector(int id, String author, String mapFileLink) {
        SectorSubmissions.registerSerpuloSector(id, author, mapFileLink, -1);
    }

    static void registerSerpuloSector(int id, String author, String mapFileLink, int captureWave) {
        Planet planet = Planets.serpulo;
        Sector sector = planet.sectors.get(id);
        MapSubmission sub = (MapSubmission)((Object)threadMap.get(sector, (MapSubmission)((Object)((Prov<MapSubmission>)MapSubmission::new))));
        sub.author = author;
        sub.mapFileLink = mapFileLink;
        SectorPreset preset = new SectorPreset("sector-" + planet.name + "-" + id, "hidden-serpulo/" + id, planet, id);
        preset.requireUnlock = false;
        if (captureWave > 0) {
            preset.captureWave = captureWave;
        } else {
            sector.generateEnemyBase = true;
        }
    }

    static void registerThread(int id, String link) {
        MapSubmission sub = new MapSubmission();
        sub.threadLink = link;
        threadMap.put(Planets.serpulo.sectors.get(id), sub);
    }

    static {
        SectorSubmissions.registerThread(0, "https://discord.com/channels/391020510269669376/1379926780860698784");
        SectorSubmissions.registerThread(6, "https://discord.com/channels/391020510269669376/1379926782966497322");
        SectorSubmissions.registerThread(13, "https://discord.com/channels/391020510269669376/1379926785164312810");
        SectorSubmissions.registerThread(16, "https://discord.com/channels/391020510269669376/1379926788280680579");
        SectorSubmissions.registerThread(19, "https://discord.com/channels/391020510269669376/1379926792479183019");
        SectorSubmissions.registerThread(20, "https://discord.com/channels/391020510269669376/1379926794114961634");
        SectorSubmissions.registerThread(24, "https://discord.com/channels/391020510269669376/1379926797042581716");
        SectorSubmissions.registerThread(27, "https://discord.com/channels/391020510269669376/1379926798833287289");
        SectorSubmissions.registerThread(30, "https://discord.com/channels/391020510269669376/1379926800854945823");
        SectorSubmissions.registerThread(47, "https://discord.com/channels/391020510269669376/1379926802591645820");
        SectorSubmissions.registerThread(55, "https://discord.com/channels/391020510269669376/1379926823277695189");
        SectorSubmissions.registerThread(66, "https://discord.com/channels/391020510269669376/1379926825941078128");
        SectorSubmissions.registerThread(67, "https://discord.com/channels/391020510269669376/1379926828696866898");
        SectorSubmissions.registerThread(69, "https://discord.com/channels/391020510269669376/1379926831326822610");
        SectorSubmissions.registerThread(76, "https://discord.com/channels/391020510269669376/1379926833411391580");
        SectorSubmissions.registerThread(92, "https://discord.com/channels/391020510269669376/1379926835621527615");
        SectorSubmissions.registerThread(94, "https://discord.com/channels/391020510269669376/1379926838079393802");
        SectorSubmissions.registerThread(103, "https://discord.com/channels/391020510269669376/1379926839559979030");
        SectorSubmissions.registerThread(111, "https://discord.com/channels/391020510269669376/1379926842659569864");
        SectorSubmissions.registerThread(116, "https://discord.com/channels/391020510269669376/1379926845058711734");
        SectorSubmissions.registerThread(127, "https://discord.com/channels/391020510269669376/1379926869465632829");
        SectorSubmissions.registerThread(133, "https://discord.com/channels/391020510269669376/1379926871227240770");
        SectorSubmissions.registerThread(138, "https://discord.com/channels/391020510269669376/1379926873152164004");
        SectorSubmissions.registerThread(150, "https://discord.com/channels/391020510269669376/1379926876457537547");
        SectorSubmissions.registerThread(157, "https://discord.com/channels/391020510269669376/1379926879502598155");
        SectorSubmissions.registerThread(161, "https://discord.com/channels/391020510269669376/1379926882203730024");
        SectorSubmissions.registerThread(162, "https://discord.com/channels/391020510269669376/1379926884606808247");
        SectorSubmissions.registerThread(176, "https://discord.com/channels/391020510269669376/1379926887203213353");
        SectorSubmissions.registerThread(180, "https://discord.com/channels/391020510269669376/1379926889648619580");
        SectorSubmissions.registerThread(185, "https://discord.com/channels/391020510269669376/1379926892181983283");
        SectorSubmissions.registerThread(191, "https://discord.com/channels/391020510269669376/1379926912004001914");
        SectorSubmissions.registerThread(192, "https://discord.com/channels/391020510269669376/1379926914122256449");
        SectorSubmissions.registerThread(197, "https://discord.com/channels/391020510269669376/1379926916911599676");
        SectorSubmissions.registerThread(200, "https://discord.com/channels/391020510269669376/1379926918429806755");
        SectorSubmissions.registerThread(204, "https://discord.com/channels/391020510269669376/1379926921130807447");
        SectorSubmissions.registerThread(207, "https://discord.com/channels/391020510269669376/1379926923370827827");
        SectorSubmissions.registerThread(225, "https://discord.com/channels/391020510269669376/1379926925719376152");
        SectorSubmissions.registerThread(230, "https://discord.com/channels/391020510269669376/1379926927585841163");
        SectorSubmissions.registerThread(237, "https://discord.com/channels/391020510269669376/1379926929636851812");
        SectorSubmissions.registerThread(242, "https://discord.com/channels/391020510269669376/1379926931923013843");
        SectorSubmissions.registerThread(243, "https://discord.com/channels/391020510269669376/1379926955423694978");
        SectorSubmissions.registerThread(244, "https://discord.com/channels/391020510269669376/1379926957738954762");
        SectorSubmissions.registerThread(245, "https://discord.com/channels/391020510269669376/1379926971286290584");
        SectorSubmissions.registerThread(246, "https://discord.com/channels/391020510269669376/1379926973454745600");
        SectorSubmissions.registerThread(247, "https://discord.com/channels/391020510269669376/1379926976361533752");
        SectorSubmissions.registerThread(248, "https://discord.com/channels/391020510269669376/1379926979129774151");
        SectorSubmissions.registerThread(251, "https://discord.com/channels/391020510269669376/1379928042637361382");
        SectorSubmissions.registerThread(254, "https://discord.com/channels/391020510269669376/1379928045577703424");
        SectorSubmissions.registerThread(259, "https://discord.com/channels/391020510269669376/1379928048245280871");
        SectorSubmissions.registerThread(263, "https://discord.com/channels/391020510269669376/1379928050010951694");
        SectorSubmissions.registerThread(265, "https://discord.com/channels/391020510269669376/1379928052921929891");
    }

    public static class MapSubmission {
        public String author = "";
        public String threadLink = "";
        public String mapFileLink = "";
    }
}

