/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Player;
import mindustry.input.InputHandler;
import mindustry.io.TypeIO;
import mindustry.net.NetConnection;
import mindustry.net.Packet;

public class BuildingControlSelectCallPacket
extends Packet {
    private byte[] DATA = NODATA;
    public Player player;
    public Building build;

    @Override
    public void write(Writes WRITE) {
        if (Vars.net.server()) {
            TypeIO.writeEntity(WRITE, this.player);
        }
        TypeIO.writeBuilding(WRITE, this.build);
    }

    @Override
    public void read(Reads READ, int LENGTH) {
        this.DATA = READ.b(LENGTH);
    }

    @Override
    public void handled() {
        BAIS.setBytes(this.DATA);
        if (Vars.net.client()) {
            this.player = (Player)TypeIO.readEntity(READ);
        }
        this.build = TypeIO.readBuilding(READ);
    }

    @Override
    public void handleServer(NetConnection con) {
        if (con.player == null || con.kicked) {
            return;
        }
        Player player = con.player;
        InputHandler.buildingControlSelect(player, this.build);
        Call.buildingControlSelect__forward(con, player, this.build);
    }

    @Override
    public void handleClient() {
        InputHandler.buildingControlSelect(this.player, this.build);
    }
}

