/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.g2d;

import arc.Core;
import arc.func.Cons;
import arc.func.FloatFloatf;
import arc.graphics.Blending;
import arc.graphics.Camera;
import arc.graphics.Color;
import arc.graphics.Gl;
import arc.graphics.Texture;
import arc.graphics.g2d.Batch;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.ScreenQuad;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.FrameBuffer;
import arc.graphics.gl.Shader;
import arc.math.Mat;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Nullable;
import arc.util.Tmp;

public class Draw {
    private static ScreenQuad squad;
    private static final Color[] carr;
    private static final float[] vertices;
    @Nullable
    private static FloatFloatf zTransformer;
    private static float actualZ;
    private static Color retColor;
    private static Color retPackedColor;
    public static float scl;
    public static float xscl;
    public static float yscl;

    private static ScreenQuad getQuad() {
        if (squad == null) {
            squad = new ScreenQuad();
        }
        return squad;
    }

    public static void blit(Shader shader) {
        shader.bind();
        shader.apply();
        Draw.getQuad().render(shader);
    }

    public static void blit(Texture texture, Shader shader) {
        texture.bind(0);
        shader.bind();
        shader.apply();
        Draw.getQuad().render(shader);
    }

    public static void blit(FrameBuffer buffer, Shader shader) {
        Draw.blit((Texture)buffer.getTexture(), shader);
    }

    public static void batch(Batch nextBatch) {
        Draw.flush();
        Core.batch = nextBatch;
    }

    public static void batch(Batch nextBatch, Runnable run) {
        Batch prev = Core.batch;
        prev.flush();
        Core.batch = nextBatch;
        run.run();
        nextBatch.flush();
        Core.batch = prev;
    }

    public static void stencil(Runnable stencil, Runnable contents) {
        Draw.beginStencil();
        stencil.run();
        Draw.beginStenciled();
        contents.run();
        Draw.endStencil();
    }

    public static void beginStencil() {
        Draw.flush();
        Gl.stencilMask(255);
        Gl.colorMask(false, false, false, false);
        Gl.enable(2960);
        Gl.stencilFunc(519, 1, 255);
        Gl.stencilMask(255);
        Gl.stencilOp(7681, 7681, 7681);
    }

    public static void beginStenciled() {
        Draw.flush();
        Gl.stencilOp(7680, 7680, 7680);
        Gl.colorMask(true, true, true, true);
        Gl.stencilFunc(514, 1, 255);
    }

    public static void endStencil() {
        Draw.flush();
        Gl.disable(2960);
    }

    public static void scl(float nscl) {
        Draw.scl(nscl, nscl);
    }

    public static void scl(float nxscl, float nyscl) {
        xscl = nxscl;
        yscl = nyscl;
    }

    public static void scl() {
        yscl = 1.0f;
        xscl = 1.0f;
    }

    public static Shader getShader() {
        return Core.batch.getShader();
    }

    public static void shader(Shader shader) {
        Draw.shader(shader, true);
    }

    public static void shader(Shader shader, boolean apply) {
        Core.batch.setShader(shader, apply);
    }

    public static void shader() {
        Core.batch.setShader(null);
    }

    public static void sort(boolean sort) {
        Core.batch.setSort(sort);
    }

    public static void zTransform(FloatFloatf f) {
        zTransformer = f;
    }

    public static void zTransform() {
        Draw.zTransform(null);
    }

    public static float z() {
        return actualZ;
    }

    public static void z(float z) {
        float f;
        if (zTransformer == null) {
            f = actualZ = z;
        } else {
            actualZ = z;
            f = zTransformer.get(actualZ);
        }
        Core.batch.z(f);
    }

    public static float getColorAlpha() {
        int abgr = Color.floatToIntColor(Core.batch.getPackedColor());
        return (float)((abgr & 0xFF000000) >>> 24) / 255.0f;
    }

    public static float getColorPacked() {
        return Core.batch.getPackedColor();
    }

    public static float getMixColorPacked() {
        return Core.batch.getPackedMixColor();
    }

    public static Color getColor() {
        return retColor.abgr8888(Core.batch.getPackedColor());
    }

    public static Color getMixColor() {
        return retPackedColor.abgr8888(Core.batch.getPackedMixColor());
    }

    public static void mixcol(Color color, float a) {
        Core.batch.setPackedMixColor(Color.toFloatBits(color.r, color.g, color.b, Mathf.clamp(a)));
    }

    public static void mixcol(Color a, Color b, float prog) {
        Core.batch.setPackedMixColor(Tmp.c1.set(a).lerp(b, prog).toFloatBits());
    }

    public static void mixcol() {
        Core.batch.setPackedMixColor(Color.clearFloatBits);
    }

    public static void mixcol(float color) {
        Core.batch.setPackedMixColor(color);
    }

    public static void tint(Color a, Color b, float s) {
        Tmp.c1.set(a).lerp(b, s);
        Tmp.c1.a = Draw.getColorAlpha();
        Draw.color(Tmp.c1);
    }

    public static void tint(Color color) {
        Core.batch.setPackedColor(Color.toFloatBits(color.r, color.g, color.b, Draw.getColorAlpha()));
    }

    public static void colorMul(Color color, float mul) {
        Draw.color(color.r * mul, color.g * mul, color.b * mul, 1.0f);
    }

    public static void color(Color color) {
        Core.batch.setPackedColor(color.toFloatBits());
    }

    public static void color(Color color, float alpha) {
        Core.batch.setPackedColor(Color.toFloatBits(color.r, color.g, color.b, Mathf.clamp(alpha)));
    }

    public static void color(int color) {
        Core.batch.setPackedColor(Tmp.c1.rgba8888(color).toFloatBits());
    }

    public static void color(float color) {
        Core.batch.setPackedColor(color);
    }

    public static void color(Color a, Color b, Color c, float progress) {
        Draw.carr[0] = a;
        Draw.carr[1] = b;
        Draw.carr[2] = c;
        Draw.color(Tmp.c1.lerp(carr, progress));
    }

    public static void color(Color a, Color b, float s) {
        Core.batch.setPackedColor(Tmp.c1.set(a).lerp(b, s).toFloatBits());
    }

    public static void color() {
        Core.batch.setPackedColor(Color.whiteFloatBits);
    }

    public static void color(float r, float g, float b) {
        Core.batch.setPackedColor(Color.toFloatBits(r, g, b, 1.0f));
    }

    public static void color(float r, float g, float b, float a) {
        Core.batch.setPackedColor(Color.toFloatBits(r, g, b, Mathf.clamp(a)));
    }

    public static void colorl(float l) {
        Draw.color(l, l, l);
    }

    public static void colorl(float l, float a) {
        Draw.color(l, l, l, a);
    }

    public static void blend(Blending blending) {
        Core.batch.setBlending(blending);
    }

    public static void blend() {
        Draw.blend(Blending.normal);
    }

    public static Blending getBlend() {
        return Core.batch.getBlending();
    }

    public static void reset() {
        Draw.color();
        Draw.mixcol();
        yscl = 1.0f;
        xscl = 1.0f;
        Lines.stroke(1.0f);
    }

    public static void alpha(float alpha) {
        int abgr = Color.floatToIntColor(Core.batch.getPackedColor());
        int rawAlpha = (int)(Mathf.clamp(alpha) * 255.0f);
        Core.batch.setPackedColor(Color.intToFloatColor(abgr & 0xFFFFFF | rawAlpha << 24));
    }

    public static void fbo(FrameBuffer buffer, int worldWidth, int worldHeight, int tilesize) {
        Draw.fbo((Texture)buffer.getTexture(), worldWidth, worldHeight, tilesize);
    }

    public static void fbo(Texture texture, int worldWidth, int worldHeight, int tilesize) {
        Draw.fbo(texture, worldWidth, worldHeight, tilesize, 0.0f);
    }

    public static void fbo(Texture texture, int worldWidth, int worldHeight, int tilesize, float offset) {
        float ww = worldWidth * tilesize;
        float wh = worldHeight * tilesize;
        float x = Core.camera.position.x + offset;
        float y = Core.camera.position.y + offset;
        float u = (x - Core.camera.width / 2.0f) / ww;
        float v = (y - Core.camera.height / 2.0f) / wh;
        float u2 = (x + Core.camera.width / 2.0f) / ww;
        float v2 = (y + Core.camera.height / 2.0f) / wh;
        Tmp.tr1.set(texture);
        Tmp.tr1.set(u, v2, u2, v);
        Draw.rect(Tmp.tr1, Core.camera.position.x, Core.camera.position.y, Core.camera.width, Core.camera.height);
    }

    public static void draw(float z, Runnable run) {
        Draw.z(z);
        Core.batch.draw(run);
    }

    public static void drawRange(float z, Runnable begin, Runnable end) {
        Draw.drawRange(z, 0.001f, begin, end);
    }

    public static void drawRange(float z, float range, Runnable begin, Runnable end) {
        Draw.draw(z - range, begin);
        Draw.draw(z + range, end);
    }

    public static void quad(TextureRegion region, float x1, float y1, float c1, float x2, float y2, float c2, float x3, float y3, float c3, float x4, float y4, float c4) {
        float mcolor = Core.batch.getPackedMixColor();
        float u = region.u;
        float v = region.v2;
        float u2 = region.u2;
        float v2 = region.v;
        Draw.vertices[0] = x1;
        Draw.vertices[1] = y1;
        Draw.vertices[2] = c1;
        Draw.vertices[3] = u;
        Draw.vertices[4] = v;
        Draw.vertices[5] = mcolor;
        Draw.vertices[6] = x2;
        Draw.vertices[7] = y2;
        Draw.vertices[8] = c2;
        Draw.vertices[9] = u;
        Draw.vertices[10] = v2;
        Draw.vertices[11] = mcolor;
        Draw.vertices[12] = x3;
        Draw.vertices[13] = y3;
        Draw.vertices[14] = c3;
        Draw.vertices[15] = u2;
        Draw.vertices[16] = v2;
        Draw.vertices[17] = mcolor;
        Draw.vertices[18] = x4;
        Draw.vertices[19] = y4;
        Draw.vertices[20] = c4;
        Draw.vertices[21] = u2;
        Draw.vertices[22] = v;
        Draw.vertices[23] = mcolor;
        Draw.vert(region.texture, vertices, 0, vertices.length);
    }

    public static void rect() {
        Fill.rect(Core.camera.position.x, Core.camera.position.y, Core.camera.width, Core.camera.height);
    }

    public static void rect(String region, float x, float y, float w, float h) {
        Draw.rect((TextureRegion)Core.atlas.find(region), x, y, w, h);
    }

    public static void rect(TextureRegion region, float x, float y, float w, float h) {
        Core.batch.draw(region, x - w / 2.0f, y - h / 2.0f, 0.0f, 0.0f, w, h, 0.0f);
    }

    public static void rect(TextureRegion region, float x, float y) {
        Draw.rect(region, x, y, (float)region.width * region.scl() * xscl, (float)region.height * region.scl() * yscl);
    }

    public static void rect(String region, float x, float y) {
        Draw.rect((TextureRegion)Core.atlas.find(region), x, y);
    }

    public static void rect(TextureRegion region, float x, float y, float w, float h, float originX, float originY, float rotation) {
        Core.batch.draw(region, x - w / 2.0f, y - h / 2.0f, originX, originY, w, h, rotation);
    }

    public static void rect(String region, float x, float y, float w, float h, float originX, float originY, float rotation) {
        Core.batch.draw(Core.atlas.find(region), x - w / 2.0f, y - h / 2.0f, originX, originY, w, h, rotation);
    }

    public static void rect(TextureRegion region, float x, float y, float w, float h, float rotation) {
        Draw.rect(region, x, y, w, h, w / 2.0f, h / 2.0f, rotation);
    }

    public static void rect(String region, float x, float y, float w, float h, float rotation) {
        Draw.rect(Core.atlas.find(region), x, y, w, h, w / 2.0f, h / 2.0f, rotation);
    }

    public static void rect(TextureRegion region, Position pos, float w, float h) {
        Draw.rect(region, pos.getX(), pos.getY(), w, h);
    }

    public static void rect(TextureRegion region, Position pos, float w, float h, float rotation) {
        Draw.rect(region, pos.getX(), pos.getY(), w, h, rotation);
    }

    public static void rect(TextureRegion region, Position pos, float rotation) {
        Draw.rect(region, pos.getX(), pos.getY(), rotation);
    }

    public static void rect(TextureRegion region, float x, float y, float rotation) {
        Draw.rect(region, x, y, (float)region.width * region.scl() * xscl, (float)region.height * region.scl() * yscl, rotation);
    }

    public static void rect(String region, float x, float y, float rotation) {
        Draw.rect((TextureRegion)Core.atlas.find(region), x, y, rotation);
    }

    public static void vert(Texture texture, float[] vertices, int offset, int length) {
        Core.batch.draw(texture, vertices, offset, length);
    }

    public static void flush() {
        Core.batch.flush();
    }

    public static void discard() {
        Core.batch.discard();
    }

    public static void proj(float x, float y, float w, float h) {
        Draw.flush();
        Core.batch.getProjection().setOrtho(x, y, w, h);
    }

    public static void proj(Camera proj) {
        Draw.proj(proj.mat);
    }

    public static void proj(Mat proj) {
        Core.batch.setProjection(proj);
    }

    public static Mat proj() {
        return Core.batch.getProjection();
    }

    public static void trans(Mat trans) {
        Core.batch.setTransform(trans);
    }

    public static Mat trans() {
        return Core.batch.getTransform();
    }

    public static TextureRegion wrap(Texture texture) {
        Tmp.tr2.set(texture);
        return Tmp.tr2;
    }

    public static void rectv(TextureRegion region, float x, float y, float width, float height, Cons<Vec2> tweaker) {
        Draw.rectv(region, x, y, width, height, 0.0f, tweaker);
    }

    public static void rectv(TextureRegion region, float x, float y, float width, float height, float rotation, Cons<Vec2> tweaker) {
        Draw.rectv(region, x, y, width, height, width / 2.0f, height / 2.0f, rotation, tweaker);
    }

    public static void rectv(TextureRegion region, float x, float y, float width, float height, float originX, float originY, float rotation, Cons<Vec2> tweaker) {
        float worldOriginX = (x -= width / 2.0f) + originX;
        float worldOriginY = (y -= height / 2.0f) + originY;
        float fx = -originX;
        float fy = -originY;
        float fx2 = width - originX;
        float fy2 = height - originY;
        float cos = Mathf.cosDeg(rotation);
        float sin = Mathf.sinDeg(rotation);
        float x1 = cos * fx - sin * fy + worldOriginX;
        float y1 = sin * fx + cos * fy + worldOriginY;
        float x2 = cos * fx - sin * fy2 + worldOriginX;
        float y2 = sin * fx + cos * fy2 + worldOriginY;
        float x3 = cos * fx2 - sin * fy2 + worldOriginX;
        float y3 = sin * fx2 + cos * fy2 + worldOriginY;
        float x4 = x1 + (x3 - x2);
        float y4 = y3 - (y2 - y1);
        tweaker.get(Tmp.v1.set(x1, y1));
        x1 = Tmp.v1.x;
        y1 = Tmp.v1.y;
        tweaker.get(Tmp.v1.set(x2, y2));
        x2 = Tmp.v1.x;
        y2 = Tmp.v1.y;
        tweaker.get(Tmp.v1.set(x3, y3));
        x3 = Tmp.v1.x;
        y3 = Tmp.v1.y;
        tweaker.get(Tmp.v1.set(x4, y4));
        x4 = Tmp.v1.x;
        y4 = Tmp.v1.y;
        float u = region.u;
        float v = region.v2;
        float u2 = region.u2;
        float v2 = region.v;
        float color = Core.batch.getPackedColor();
        float mixColor = Core.batch.getPackedMixColor();
        Draw.vertices[0] = x1;
        Draw.vertices[1] = y1;
        Draw.vertices[2] = color;
        Draw.vertices[3] = u;
        Draw.vertices[4] = v;
        Draw.vertices[5] = mixColor;
        Draw.vertices[6] = x2;
        Draw.vertices[7] = y2;
        Draw.vertices[8] = color;
        Draw.vertices[9] = u;
        Draw.vertices[10] = v2;
        Draw.vertices[11] = mixColor;
        Draw.vertices[12] = x3;
        Draw.vertices[13] = y3;
        Draw.vertices[14] = color;
        Draw.vertices[15] = u2;
        Draw.vertices[16] = v2;
        Draw.vertices[17] = mixColor;
        Draw.vertices[18] = x4;
        Draw.vertices[19] = y4;
        Draw.vertices[20] = color;
        Draw.vertices[21] = u2;
        Draw.vertices[22] = v;
        Draw.vertices[23] = mixColor;
        Draw.vert(region.texture, vertices, 0, vertices.length);
    }

    static {
        carr = new Color[3];
        vertices = new float[24];
        retColor = new Color();
        retPackedColor = new Color();
        scl = 1.0f;
        xscl = 1.0f;
        yscl = 1.0f;
    }
}

